/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.block;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.registry.OxidizableBlocksRegistry;
import net.minecraft.class_2248;

public class CopperRegistries {
    private static final BiMap<Supplier<class_2248>, Supplier<class_2248>> WEATHERING = HashBiMap.create();
    private static final BiMap<Supplier<class_2248>, Supplier<class_2248>> WAXABLE = HashBiMap.create();
    private static boolean injected;
    private static boolean weatheringMemoized;
    private static boolean waxableMemoized;

    public static synchronized void addWeathering(Supplier<class_2248> original, Supplier<class_2248> weathered) {
        if (weatheringMemoized) {
            throw new IllegalStateException("Cannot add weathering entry to CopperRegistries after memoization!");
        }
        WEATHERING.put(original, weathered);
    }

    public static synchronized void addWaxable(Supplier<class_2248> original, Supplier<class_2248> waxed) {
        if (waxableMemoized) {
            throw new IllegalStateException("Cannot add waxable entry to CopperRegistries after memoization!");
        }
        WAXABLE.put(original, waxed);
    }

    public static void inject() {
        if (injected) {
            throw new IllegalStateException("Cannot inject CopperRegistries twice!");
        }
        injected = true;
        WEATHERING.forEach((original, weathered) -> OxidizableBlocksRegistry.registerOxidizableBlockPair((class_2248)((class_2248)original.get()), (class_2248)((class_2248)weathered.get())));
        weatheringMemoized = true;
        WAXABLE.forEach((original, waxed) -> OxidizableBlocksRegistry.registerWaxableBlockPair((class_2248)((class_2248)original.get()), (class_2248)((class_2248)waxed.get())));
        waxableMemoized = true;
    }
}

