/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.client.gui.screens.strawstatue;

import com.google.common.collect.Lists;
import fuzs.puzzlesapi.api.client.statues.v1.gui.components.NewTextureTickButton;
import fuzs.puzzlesapi.api.client.statues.v1.gui.screens.armorstand.ArmorStandPositionScreen;
import fuzs.puzzlesapi.api.client.statues.v1.gui.screens.armorstand.ArmorStandWidgetsScreen;
import fuzs.puzzlesapi.api.statues.v1.network.client.data.DataSyncHandler;
import fuzs.puzzlesapi.api.statues.v1.world.inventory.ArmorStandHolder;
import fuzs.puzzlesapi.api.statues.v1.world.inventory.data.ArmorStandPose;
import fuzs.puzzlesapi.api.statues.v1.world.inventory.data.ArmorStandScreenType;
import fuzs.strawstatues.init.ModRegistry;
import fuzs.strawstatues.network.client.C2SStrawStatueScaleMessage;
import fuzs.strawstatues.world.entity.decoration.StrawStatue;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import net.minecraft.class_1531;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_7919;

public class StrawStatueScaleScreen
extends ArmorStandPositionScreen {
    public static final String SCALE_TRANSLATION_KEY = "strawstatues.screen.position.scale";
    public static final String ROTATION_X_TRANSLATION_KEY = "strawstatues.screen.position.rotationX";
    public static final String ROTATION_Y_TRANSLATION_KEY = "strawstatues.screen.position.rotationY";
    public static final String ROTATION_Z_TRANSLATION_KEY = "strawstatues.screen.position.rotationZ";
    private class_339 resetButton;

    public StrawStatueScaleScreen(ArmorStandHolder holder, class_1661 inventory, class_2561 component, DataSyncHandler dataSyncHandler) {
        super(holder, inventory, component, dataSyncHandler);
    }

    protected void method_25426() {
        super.method_25426();
        this.resetButton = (class_339)class_156.method_654((Object)((NewTextureTickButton)this.method_37063((class_364)new NewTextureTickButton(this.leftPos + 6, this.topPos + 6, 20, 20, 240, 124, StrawStatueScaleScreen.getArmorStandWidgetsLocation(), button -> {
            C2SStrawStatueScaleMessage.ScaleDataType.RESET.consumer.accept((StrawStatue)this.holder.getArmorStand(), Float.valueOf(-1.0f));
            C2SStrawStatueScaleMessage.sendReset();
            this.widgets.forEach(ArmorStandWidgetsScreen.ArmorStandWidget::reset);
        }))), widget -> widget.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"puzzlesapi.screen.rotations.reset"))));
    }

    protected List<ArmorStandWidgetsScreen.ArmorStandWidget> buildWidgets(class_1531 armorStand) {
        StrawStatue strawStatue = (StrawStatue)armorStand;
        Object[] objectArray = new ArmorStandWidgetsScreen.ArmorStandWidget[4];
        objectArray[0] = new ScaleWidget((class_2561)class_2561.method_43471((String)SCALE_TRANSLATION_KEY), strawStatue::getEntityScale, C2SStrawStatueScaleMessage::sendScale);
        objectArray[1] = new StrawRotationWidget((class_2561)class_2561.method_43471((String)ROTATION_X_TRANSLATION_KEY), strawStatue::getEntityXRotation, C2SStrawStatueScaleMessage::sendRotationX, strawStatue::setEntityXRotation);
        objectArray[2] = new ArmorStandPositionScreen.RotationWidget((ArmorStandPositionScreen)this, (class_2561)class_2561.method_43471((String)ROTATION_Y_TRANSLATION_KEY), () -> ((class_1531)armorStand).method_36454(), arg_0 -> ((DataSyncHandler)this.dataSyncHandler).sendRotation(arg_0));
        objectArray[3] = new StrawRotationWidget((class_2561)class_2561.method_43471((String)ROTATION_Z_TRANSLATION_KEY), strawStatue::getEntityZRotation, C2SStrawStatueScaleMessage::sendRotationZ, strawStatue::setEntityZRotation);
        return Lists.newArrayList((Object[])objectArray);
    }

    protected void toggleMenuRendering(boolean disableMenuRendering) {
        super.toggleMenuRendering(disableMenuRendering);
        this.resetButton.field_22764 = !disableMenuRendering;
    }

    public ArmorStandScreenType getScreenType() {
        return ModRegistry.STRAW_STATUE_SCALE_SCREEN_TYPE;
    }

    public static float toModelScale(double newValue) {
        newValue = newValue * 7.0 + 1.0;
        return StrawStatue.clampModelScale(newValue);
    }

    private class ScaleWidget
    extends ArmorStandPositionScreen.RotationWidget {
        public ScaleWidget(class_2561 title, DoubleSupplier currentValue, Consumer<Float> newValue) {
            super((ArmorStandPositionScreen)StrawStatueScaleScreen.this, title, currentValue, newValue, -1.0);
        }

        protected double getCurrentValue() {
            return (this.currentValue.getAsDouble() - 1.0) / 7.0;
        }

        protected void setNewValue(double newValue) {
            this.newValue.accept(Float.valueOf(StrawStatueScaleScreen.toModelScale(newValue)));
        }

        protected class_2561 getTooltipComponent(double mouseValue) {
            mouseValue = mouseValue * 9.0 + 1.0;
            mouseValue = class_3532.method_15350((double)mouseValue, (double)1.0, (double)10.0);
            return class_2561.method_43470((String)ArmorStandPose.ROTATION_FORMAT.format(mouseValue));
        }

        protected void applyClientValue(double newValue) {
            ((StrawStatue)StrawStatueScaleScreen.this.holder.getArmorStand()).setEntityScale(StrawStatueScaleScreen.toModelScale(newValue));
        }
    }

    private class StrawRotationWidget
    extends ArmorStandPositionScreen.RotationWidget {
        private final Consumer<Float> newClientValue;

        public StrawRotationWidget(class_2561 title, DoubleSupplier currentValue, Consumer<Float> newValue, Consumer<Float> newClientValue) {
            super((ArmorStandPositionScreen)StrawStatueScaleScreen.this, title, currentValue, newValue);
            this.newClientValue = newClientValue;
        }

        protected double getCurrentValue() {
            return this.currentValue.getAsDouble() / 360.0;
        }

        protected void setNewValue(double newValue) {
            this.newValue.accept(Float.valueOf((float)(newValue * 360.0)));
        }

        protected void applyClientValue(double newValue) {
            this.newClientValue.accept(Float.valueOf((float)(newValue * 360.0)));
        }
    }
}

