/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.world.entity.decoration;

import com.google.common.collect.ImmutableSortedMap;
import com.mojang.authlib.GameProfile;
import fuzs.puzzlesapi.api.statues.v1.helper.ArmorStandInteractHelper;
import fuzs.puzzlesapi.api.statues.v1.world.entity.decoration.ArmorStandDataProvider;
import fuzs.puzzlesapi.api.statues.v1.world.inventory.data.ArmorStandPose;
import fuzs.puzzlesapi.api.statues.v1.world.inventory.data.ArmorStandScreenType;
import fuzs.puzzlesapi.api.statues.v1.world.inventory.data.ArmorStandStyleOption;
import fuzs.puzzlesapi.api.statues.v1.world.inventory.data.ArmorStandStyleOptions;
import fuzs.puzzlesapi.api.statues.v1.world.inventory.data.PosePartMutator;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.strawstatues.init.ModRegistry;
import fuzs.strawstatues.mixin.accessor.ArmorStandAccessor;
import java.util.NavigableMap;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2379;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2631;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5712;
import net.minecraft.class_8103;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class StrawStatue
extends class_1531
implements ArmorStandDataProvider {
    public static final class_2379 DEFAULT_ENTITY_ROTATIONS = new class_2379(180.0f, 0.0f, 180.0f);
    public static final float DEFAULT_ENTITY_SCALE = 3.0f;
    public static final float MIN_MODEL_SCALE = 1.0f;
    public static final float MAX_MODEL_SCALE = 8.0f;
    public static final String OWNER_KEY = "Owner";
    public static final String SLIM_ARMS_KEY = "SlimArms";
    public static final String CROUCHING_KEY = "Crouching";
    public static final String MODEL_PARTS_KEY = "ModelParts";
    public static final String ENTITY_SCALE_KEY = "EntityScale";
    public static final String ENTITY_ROTATIONS_KEY = "EntityRotations";
    public static final class_2940<Optional<GameProfile>> DATA_OWNER = class_2945.method_12791(StrawStatue.class, ModRegistry.GAME_PROFILE_ENTITY_DATA_SERIALIZER);
    public static final class_2940<Boolean> DATA_SLIM_ARMS = class_2945.method_12791(StrawStatue.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> DATA_CROUCHING = class_2945.method_12791(StrawStatue.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Byte> DATA_PLAYER_MODE_CUSTOMISATION = class_2945.method_12791(StrawStatue.class, (class_2941)class_2943.field_13319);
    public static final class_2940<Float> DATA_ENTITY_SCALE = class_2945.method_12791(StrawStatue.class, (class_2941)class_2943.field_13320);
    public static final class_2940<class_2379> DATA_ENTITY_ROTATIONS = class_2945.method_12791(StrawStatue.class, (class_2941)class_2943.field_13316);
    private final NavigableMap<Float, class_4048> defaultDimensions;
    private final NavigableMap<Float, class_4048> babyDimensions;
    public float entityScaleO = 3.0f;
    public class_2379 entityRotationsO = DEFAULT_ENTITY_ROTATIONS;

    public StrawStatue(class_1299<? extends StrawStatue> entityType, class_1937 level) {
        super(entityType, level);
        ArmorStandStyleOption.setArmorStandData((class_1531)this, (boolean)true, (int)4);
        ArmorStandStyleOption.setArmorStandData((class_1531)this, (boolean)true, (int)8);
        this.defaultDimensions = StrawStatue.buildStatueDimensions(entityType, false);
        this.babyDimensions = StrawStatue.buildStatueDimensions(entityType, true);
    }

    public StrawStatue(class_1937 level, double x, double y, double z) {
        this((class_1299<? extends StrawStatue>)((class_1299)ModRegistry.STRAW_STATUE_ENTITY_TYPE.get()), level);
        this.method_5814(x, y, z);
    }

    private static NavigableMap<Float, class_4048> buildStatueDimensions(class_1299<?> entityType, boolean forBaby) {
        float defaultScale = 3.0f * (forBaby ? 2.0f : 1.0f);
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (float scale = 1.0f; scale <= 8.0f; scale += 0.5f) {
            builder.put((Object)Float.valueOf(scale - 0.25f), (Object)entityType.method_18386().method_18383(scale / defaultScale));
        }
        return builder.build();
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_OWNER, Optional.empty());
        this.field_6011.method_12784(DATA_SLIM_ARMS, (Object)false);
        this.field_6011.method_12784(DATA_CROUCHING, (Object)false);
        this.field_6011.method_12784(DATA_PLAYER_MODE_CUSTOMISATION, (Object)StrawStatue.getAllModelParts());
        this.field_6011.method_12784(DATA_ENTITY_SCALE, (Object)Float.valueOf(3.0f));
        this.field_6011.method_12784(DATA_ENTITY_ROTATIONS, (Object)DEFAULT_ENTITY_ROTATIONS);
    }

    private static byte getAllModelParts() {
        byte value = 0;
        for (class_1664 modelPart : class_1664.values()) {
            value = (byte)(value | modelPart.method_7430());
        }
        return value;
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10556(SLIM_ARMS_KEY, this.slimArms());
        tag.method_10556(CROUCHING_KEY, this.method_18276());
        tag.method_10567(MODEL_PARTS_KEY, ((Byte)this.field_6011.method_12789(DATA_PLAYER_MODE_CUSTOMISATION)).byteValue());
        ((Optional)this.field_6011.method_12789(DATA_OWNER)).ifPresent(owner -> {
            class_2487 gameProfileTag = new class_2487();
            class_2512.method_10684((class_2487)gameProfileTag, (GameProfile)owner);
            tag.method_10566(OWNER_KEY, (class_2520)gameProfileTag);
        });
        tag.method_10548(ENTITY_SCALE_KEY, this.getEntityScale());
        class_2379 entityRotations = this.getEntityRotations();
        if (!DEFAULT_ENTITY_ROTATIONS.equals((Object)entityRotations)) {
            tag.method_10566(ENTITY_ROTATIONS_KEY, (class_2520)entityRotations.method_10255());
        }
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        if (tag.method_10573(SLIM_ARMS_KEY, 1)) {
            this.setSlimArms(tag.method_10577(SLIM_ARMS_KEY));
        }
        if (tag.method_10573(CROUCHING_KEY, 1)) {
            this.setCrouching(tag.method_10577(CROUCHING_KEY));
        }
        if (tag.method_10573(MODEL_PARTS_KEY, 1)) {
            this.field_6011.method_12778(DATA_PLAYER_MODE_CUSTOMISATION, (Object)tag.method_10571(MODEL_PARTS_KEY));
        }
        if (tag.method_10573(OWNER_KEY, 10)) {
            this.verifyAndSetOwner(class_2512.method_10683((class_2487)tag.method_10562(OWNER_KEY)));
        }
        if (tag.method_10573(ENTITY_SCALE_KEY, 5)) {
            this.setEntityScale(tag.method_10583(ENTITY_SCALE_KEY));
            this.entityScaleO = this.getEntityScale();
        }
        if (tag.method_10573(ENTITY_ROTATIONS_KEY, 9)) {
            class_2379 entityRotations = new class_2379(tag.method_10554(ENTITY_ROTATIONS_KEY, 5));
            this.setEntityRotations(entityRotations.method_10256(), entityRotations.method_10258());
            this.entityRotationsO = this.getEntityRotations();
        }
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return dimensions.field_18068 * 0.85f;
    }

    public class_4048 method_18377(class_4050 pose) {
        if (this.method_6912() || this.babyDimensions == null || this.defaultDimensions == null) {
            return super.method_18377(pose);
        }
        NavigableMap<Float, class_4048> dimensions = this.method_6109() ? this.babyDimensions : this.defaultDimensions;
        return dimensions.floorEntry(Float.valueOf(this.getEntityScale())).getValue();
    }

    public void method_5674(class_2940<?> key) {
        if (DATA_ENTITY_SCALE.equals(key)) {
            this.method_18382();
        }
        super.method_5674(key);
    }

    public class_1269 method_5664(class_1657 player, class_243 vec, class_1268 hand) {
        class_1799 itemInHand = player.method_5998(hand);
        class_1269 result = super.method_5664(player, vec, hand);
        if (!player.method_37908().field_9236 && !player.method_7325() && result == class_1269.field_5812 && itemInHand.method_31574(class_1802.field_8575) && itemInHand.method_7985()) {
            GameProfile gameProfile = null;
            class_2487 compoundTag = itemInHand.method_7969();
            if (compoundTag.method_10573("SkullOwner", 10)) {
                gameProfile = class_2512.method_10683((class_2487)compoundTag.method_10562("SkullOwner"));
            } else if (compoundTag.method_10573("SkullOwner", 8) && !StringUtils.isBlank((CharSequence)compoundTag.method_10558("SkullOwner"))) {
                gameProfile = new GameProfile(null, compoundTag.method_10558("SkullOwner"));
            }
            if (gameProfile != null) {
                this.verifyAndSetOwner(gameProfile);
            }
        }
        return result;
    }

    public static EventResultHolder<class_1269> onUseEntityAt(class_1657 player, class_1937 level, class_1268 interactionHand, class_1297 target, class_243 hitVector) {
        if (!player.method_7325() && target.method_5864() == ModRegistry.STRAW_STATUE_ENTITY_TYPE.get()) {
            return ArmorStandInteractHelper.tryOpenArmorStatueMenu((class_1657)player, (class_1937)level, (class_1268)interactionHand, (class_1531)((class_1531)target), (class_3917)((class_3917)ModRegistry.STRAW_STATUE_MENU_TYPE.get()), null);
        }
        return EventResultHolder.pass();
    }

    public boolean method_6929() {
        return true;
    }

    public boolean method_6901() {
        return true;
    }

    public Optional<GameProfile> getOwner() {
        return (Optional)this.field_6011.method_12789(DATA_OWNER);
    }

    public void verifyAndSetOwner(@Nullable GameProfile gameProfile) {
        if (!(gameProfile == null || gameProfile.isComplete() && gameProfile.getName().length() <= 16)) {
            if (gameProfile.getName().length() > 16) {
                if (gameProfile.getId() != null) {
                    gameProfile = new GameProfile(gameProfile.getId(), "");
                } else {
                    this.setOwner(null);
                    return;
                }
            }
            class_2631.method_11335((GameProfile)gameProfile, this::setOwner);
        } else {
            this.setOwner(gameProfile);
        }
    }

    private void setOwner(@Nullable GameProfile gameProfile) {
        this.field_6011.method_12778(DATA_OWNER, Optional.ofNullable(gameProfile));
    }

    public boolean slimArms() {
        return (Boolean)this.field_6011.method_12789(DATA_SLIM_ARMS);
    }

    public void setSlimArms(boolean slimArms) {
        this.field_6011.method_12778(DATA_SLIM_ARMS, (Object)slimArms);
    }

    public boolean isModelPartShown(class_1664 part) {
        return ((Byte)this.method_5841().method_12789(DATA_PLAYER_MODE_CUSTOMISATION) & part.method_7430()) == part.method_7430();
    }

    public void setModelPart(class_1664 modelPart, boolean enable) {
        this.field_6011.method_12778(DATA_PLAYER_MODE_CUSTOMISATION, (Object)ArmorStandStyleOption.setBit((byte)((Byte)this.field_6011.method_12789(DATA_PLAYER_MODE_CUSTOMISATION)), (int)modelPart.method_7430(), (boolean)enable));
    }

    public float getEntityScale() {
        return ((Float)this.field_6011.method_12789(DATA_ENTITY_SCALE)).floatValue();
    }

    public float getEntityXRotation() {
        return this.getEntityRotations().method_10256();
    }

    public class_2379 getEntityRotations() {
        return (class_2379)this.field_6011.method_12789(DATA_ENTITY_ROTATIONS);
    }

    public float getEntityZRotation() {
        return this.getEntityRotations().method_10258();
    }

    public void setEntityXRotation(float rotationX) {
        this.setEntityRotations(rotationX, this.getEntityZRotation());
    }

    public void setEntityZRotation(float rotationZ) {
        this.setEntityRotations(this.getEntityXRotation(), rotationZ);
    }

    public void setEntityRotations(float rotationX, float rotationZ) {
        rotationX = class_3532.method_15363((float)rotationX, (float)0.0f, (float)360.0f);
        rotationZ = class_3532.method_15363((float)rotationZ, (float)0.0f, (float)360.0f);
        this.field_6011.method_12778(DATA_ENTITY_ROTATIONS, (Object)new class_2379(rotationX, 0.0f, rotationZ));
    }

    public void setEntityScale(float modelScale) {
        modelScale = StrawStatue.clampModelScale(modelScale);
        this.field_6011.method_12778(DATA_ENTITY_SCALE, (Object)Float.valueOf(modelScale));
    }

    public static float clampModelScale(double modelScale) {
        modelScale = (double)((int)(modelScale * 10.0)) / 10.0;
        return class_3532.method_15363((float)((float)modelScale), (float)1.0f, (float)8.0f);
    }

    public void method_5670() {
        super.method_5670();
        this.entityScaleO = this.getEntityScale();
        this.entityRotationsO = this.getEntityRotations();
    }

    public void setCrouching(boolean crouching) {
        this.field_6011.method_12778(DATA_CROUCHING, (Object)crouching);
    }

    public boolean method_18276() {
        return (Boolean)this.field_6011.method_12789(DATA_CROUCHING);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (!this.method_37908().field_9236 && !this.method_31481()) {
            if (source.method_48789(class_8103.field_42242)) {
                this.method_5768();
                return false;
            }
            if (!(this.method_5679(source) || this.method_5767() || this.method_6912())) {
                if (source.method_48789(class_8103.field_42249)) {
                    ((ArmorStandAccessor)((Object)this)).strawstatues$callBrokenByAnything(source);
                    this.method_5768();
                    return false;
                }
                if (source.method_48789(class_8103.field_42258)) {
                    if (this.method_5809()) {
                        ((ArmorStandAccessor)((Object)this)).strawstatues$callCauseDamage(source, 0.15f);
                    } else {
                        this.method_5639(5);
                    }
                    return false;
                }
                if (source.method_48789(class_8103.field_42259) && this.method_6032() > 0.5f) {
                    ((ArmorStandAccessor)((Object)this)).strawstatues$callCauseDamage(source, 4.0f);
                    return false;
                }
                boolean bl = source.method_5526() instanceof class_1665;
                boolean bl2 = bl && ((class_1665)source.method_5526()).method_7447() > 0;
                boolean bl3 = "player".equals(source.method_5525());
                if (!bl3 && !bl) {
                    return false;
                }
                if (source.method_5529() instanceof class_1657 && !((class_1657)source.method_5529()).method_31549().field_7476) {
                    return false;
                }
                if (source.method_5530()) {
                    this.playBrokenSound();
                    this.showBreakingParticles();
                    this.method_5768();
                    return bl2;
                }
                long gameTime = this.method_37908().method_8510();
                if (gameTime - this.field_7112 > 5L && !bl) {
                    this.method_37908().method_8421((class_1297)this, (byte)32);
                    this.method_32875(class_5712.field_28736, source.method_5529());
                    this.field_7112 = gameTime;
                    this.field_6008 = 20;
                    this.field_6235 = this.field_6254 = 10;
                } else {
                    this.brokenByPlayer(source);
                    this.showBreakingParticles();
                    this.method_5768();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void brokenByPlayer(class_1282 source) {
        class_2248.method_9577((class_1937)this.method_37908(), (class_2338)this.method_24515(), (class_1799)new class_1799((class_1935)ModRegistry.STRAW_STATUE_ITEM.get()));
        ((ArmorStandAccessor)((Object)this)).strawstatues$callBrokenByAnything(source);
    }

    private void playBrokenSound() {
        this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15037, this.method_5634(), 1.0f, 1.0f);
    }

    private void showBreakingParticles() {
        if (this.method_37908() instanceof class_3218) {
            ((class_3218)this.method_37908()).method_14199((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10359.method_9564()), this.method_23317(), this.method_23323(0.6666666666666666), this.method_23321(), 10, (double)(this.method_17681() / 4.0f), (double)(this.method_17682() / 4.0f), (double)(this.method_17681() / 4.0f), 0.05);
        }
    }

    public void method_5711(byte id) {
        if (id == 32) {
            this.field_7112 = this.method_37908().method_8510();
        }
        super.method_5711(id);
    }

    public class_1309.class_6823 method_39760() {
        return new class_1309.class_6823(class_3417.field_14965, class_3417.field_14965);
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return class_3417.field_14720;
    }

    @Nullable
    protected class_3414 method_6002() {
        return class_3417.field_15037;
    }

    @Nullable
    public class_1799 method_31480() {
        return new class_1799((class_1935)ModRegistry.STRAW_STATUE_ITEM.get());
    }

    public ArmorStandScreenType[] getScreenTypes() {
        return new ArmorStandScreenType[]{ArmorStandScreenType.ROTATIONS, ArmorStandScreenType.POSES, ArmorStandScreenType.STYLE, ModRegistry.MODEL_PARTS_SCREEN_TYPE, ModRegistry.STRAW_STATUE_POSITION_SCREEN_TYPE, ModRegistry.STRAW_STATUE_SCALE_SCREEN_TYPE, ArmorStandScreenType.EQUIPMENT};
    }

    public PosePartMutator[] getPosePartMutators() {
        return new PosePartMutator[]{PosePartMutator.HEAD, ModRegistry.CAPE_POSE_PART_MUTATOR, PosePartMutator.RIGHT_ARM, PosePartMutator.LEFT_ARM, PosePartMutator.RIGHT_LEG, PosePartMutator.LEFT_LEG};
    }

    public ArmorStandPose getRandomPose(boolean clampRotations) {
        return ArmorStandPose.randomize((PosePartMutator[])this.getPosePartMutators(), (boolean)clampRotations);
    }

    public ArmorStandStyleOption[] getStyleOptions() {
        return new ArmorStandStyleOption[]{ArmorStandStyleOptions.SHOW_NAME, ArmorStandStyleOptions.SMALL, ModRegistry.SLIM_ARMS_STYLE_OPTION, ModRegistry.CROUCHING_STYLE_OPTION, ArmorStandStyleOptions.NO_GRAVITY, ArmorStandStyleOptions.SEALED};
    }
}

