/*
 * Decompiled with CFR 0.152.
 */
package org.dfood.mixin.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2551;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.minecraft.class_837;
import org.dfood.render.HangingItemTransform;
import org.dfood.util.DFoodUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_837.class})
public class SignBlockEntityRendererMixin {
    @Unique
    private static final float STANDING_Z_OFFSET = 0.01f;
    @Unique
    private static final float WALL_Z_OFFSET = 0.015f;

    @Inject(method={"method_23083(Lnet/minecraft/class_2625;FLnet/minecraft/class_4587;Lnet/minecraft/class_4597;II)V"}, at={@At(value="TAIL")})
    private void dFood$renderHangingItems(class_2625 signBlockEntity, float f, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i, int j, CallbackInfo ci) {
        class_1799 backItem;
        class_1799 frontItem = signBlockEntity.dFood$getItem(true);
        if (!frontItem.method_7960()) {
            this.renderSideItem(signBlockEntity, frontItem, true, matrixStack, vertexConsumerProvider, i, j);
        }
        if (!(backItem = signBlockEntity.dFood$getItem(false)).method_7960()) {
            this.renderSideItem(signBlockEntity, backItem, false, matrixStack, vertexConsumerProvider, i, j);
        }
    }

    @Unique
    private void renderSideItem(class_2625 signBlockEntity, class_1799 stack, boolean front, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, int overlay) {
        class_2680 blockState = DFoodUtils.getBlockStateFromItem(stack.method_7909());
        if (blockState == null) {
            return;
        }
        class_2680 signState = signBlockEntity.method_11010();
        boolean isWallSign = signState.method_26204() instanceof class_2551;
        class_2350 itemFacing = this.calculateItemFacing(signState, front);
        matrixStack.method_22903();
        if (isWallSign) {
            this.setupWallItemPosition(matrixStack, signState, front, itemFacing);
        } else {
            this.setupStandingItemPosition(matrixStack, signState, front, itemFacing);
        }
        HangingItemTransform.applyTransformation(stack, matrixStack, signState, itemFacing);
        class_310.method_1551().method_1541().method_3353(blockState, matrixStack, vertexConsumerProvider, light, overlay);
        matrixStack.method_22909();
    }

    @Unique
    private class_2350 calculateItemFacing(class_2680 signState, boolean front) {
        boolean isWallSign = signState.method_26204() instanceof class_2551;
        if (isWallSign) {
            return (class_2350)signState.method_11654((class_2769)class_2383.field_11177);
        }
        if (signState.method_28498((class_2769)class_2741.field_12532)) {
            int rotation = (Integer)signState.method_11654((class_2769)class_2741.field_12532);
            float rotationDegrees = (float)(-rotation) * 22.5f;
            float itemRotation = front ? rotationDegrees : rotationDegrees + 180.0f;
            if ((itemRotation = (itemRotation % 360.0f + 360.0f) % 360.0f) >= 45.0f && itemRotation < 135.0f) {
                return class_2350.field_11039;
            }
            if (itemRotation >= 135.0f && itemRotation < 225.0f) {
                return class_2350.field_11043;
            }
            if (itemRotation >= 225.0f && itemRotation < 315.0f) {
                return class_2350.field_11034;
            }
            return class_2350.field_11035;
        }
        return class_2350.field_11043;
    }

    @Unique
    private void setupStandingItemPosition(class_4587 matrixStack, class_2680 signState, boolean front, class_2350 itemFacing) {
        matrixStack.method_22904(0.5, 0.5, 0.5);
        if (signState.method_28498((class_2769)class_2741.field_12532)) {
            int rotation = (Integer)signState.method_11654((class_2769)class_2741.field_12532);
            float rotationDegrees = (float)(-rotation) * 22.5f;
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(rotationDegrees));
        }
        float zOffset = front ? -0.01f : 0.01f;
        matrixStack.method_22904(0.0, 0.4, (double)zOffset);
        if (!front) {
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        }
    }

    @Unique
    private void setupWallItemPosition(class_4587 matrixStack, class_2680 signState, boolean front, class_2350 itemFacing) {
        class_2350 signFacing = (class_2350)signState.method_11654((class_2769)class_2383.field_11177);
        float wallOffset = 0.44f;
        switch (signFacing) {
            case field_11043: {
                matrixStack.method_22904(0.5, 0.5, 0.5 + (double)wallOffset);
                break;
            }
            case field_11035: {
                matrixStack.method_22904(0.5, 0.5, 0.5 - (double)wallOffset);
                break;
            }
            case field_11039: {
                matrixStack.method_22904(0.5 + (double)wallOffset, 0.5, 0.5);
                break;
            }
            case field_11034: {
                matrixStack.method_22904(0.5 - (double)wallOffset, 0.5, 0.5);
            }
        }
        float rotationDegrees = switch (signFacing) {
            case class_2350.field_11043 -> 180.0f;
            case class_2350.field_11034 -> 90.0f;
            case class_2350.field_11035 -> 0.0f;
            case class_2350.field_11039 -> 270.0f;
            default -> 360.0f;
        };
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(rotationDegrees));
        float zOffset = front ? -0.015f : 0.015f;
        matrixStack.method_22904(0.0, 0.085, (double)zOffset);
        if (!front) {
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        }
    }
}

