/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.tab;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.config.entry.BooleanConfigEntry;
import su.plo.config.entry.ConfigEntry;
import su.plo.config.entry.EnumConfigEntry;
import su.plo.lib.mod.client.gui.components.Button;
import su.plo.lib.mod.client.gui.screen.ScreenWrapper;
import su.plo.lib.mod.client.gui.widget.GuiAbstractWidget;
import su.plo.lib.mod.client.render.Colors;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.lib.mod.client.render.gui.GuiRenderContext;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.line.ClientSourceLine;
import su.plo.voice.api.client.audio.line.ClientSourceLineManager;
import su.plo.voice.api.client.config.IconPosition;
import su.plo.voice.api.client.config.overlay.OverlayPosition;
import su.plo.voice.api.client.config.overlay.OverlaySourceState;
import su.plo.voice.api.client.config.overlay.OverlayStyle;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.gui.settings.VoiceSettingsScreen;
import su.plo.voice.client.gui.settings.tab.ActivationIconPositionScreen;
import su.plo.voice.client.gui.settings.tab.OverlayPositionScreen;
import su.plo.voice.client.gui.settings.tab.TabWidget;
import su.plo.voice.client.gui.settings.widget.DropDownWidget;
import su.plo.voice.client.gui.settings.widget.ToggleButton;
import su.plo.voice.client.gui.settings.widget.UpdatableWidget;

public final class OverlayTabWidget
extends TabWidget {
    private static final List<McTextComponent> ICONS_LIST = ImmutableList.of((Object)McTextComponent.translatable("gui.plasmovoice.overlay.show_source_icons.hud", new Object[0]), (Object)McTextComponent.translatable("gui.plasmovoice.overlay.show_source_icons.always", new Object[0]), (Object)McTextComponent.translatable("gui.plasmovoice.overlay.show_source_icons.hidden", new Object[0]));
    private static final List<McTextComponent> OVERLAY_DISPLAYS = ImmutableList.of((Object)McTextComponent.translatable("gui.plasmovoice.overlay.sources.when_talking", new Object[0]), (Object)McTextComponent.translatable("gui.plasmovoice.overlay.sources.always", new Object[0]), (Object)McTextComponent.translatable("gui.plasmovoice.overlay.sources.never", new Object[0]));
    private final ClientSourceLineManager sourceLines;

    public OverlayTabWidget(VoiceSettingsScreen parent, PlasmoVoiceClient voiceClient, VoiceClientConfig config) {
        super(parent, voiceClient, config);
        this.sourceLines = voiceClient.getSourceLineManager();
    }

    @Override
    public void init() {
        super.init();
        this.addEntry(new TabWidget.CategoryEntry(this, McTextComponent.translatable("gui.plasmovoice.overlay.activation_icon", new Object[0])));
        this.addEntry(this.createToggleEntry(McTextComponent.translatable("gui.plasmovoice.overlay.activation_icon_show", new Object[0]), null, this.config.getOverlay().getShowActivationIcon()));
        this.addEntry(this.createActivationIconPosition());
        this.addEntry(new TabWidget.CategoryEntry(this, McTextComponent.translatable("gui.plasmovoice.overlay.source_icons", new Object[0])));
        this.addEntry(this.createShowIcons());
        this.addEntry(this.createToggleEntry(McTextComponent.translatable("gui.plasmovoice.overlay.show_static_source_icons", new Object[0]), null, this.config.getOverlay().getShowStaticSourceIcons()));
        this.addEntry(new TabWidget.CategoryEntry(this, McTextComponent.translatable("gui.plasmovoice.overlay", new Object[0])));
        this.addEntry(this.createToggleEntry(McTextComponent.translatable("gui.plasmovoice.overlay.enable", new Object[0]), null, this.config.getOverlay().getOverlayEnabled()));
        this.addEntry(this.createOverlayPosition());
        this.addEntry(this.createOverlayStyle());
        this.addEntry(new TabWidget.CategoryEntry(this, McTextComponent.translatable("gui.plasmovoice.overlay.sources", new Object[0])));
        ArrayList sourceLines = Lists.newArrayList(this.sourceLines.getLines());
        Collections.reverse(sourceLines);
        sourceLines.forEach(this::createOverlaySource);
    }

    private void createOverlaySource(@NotNull ClientSourceLine sourceLine) {
        EnumConfigEntry<OverlaySourceState> configEntry = this.config.getOverlay().getSourceStates().getState(sourceLine);
        if (!sourceLine.hasPlayers()) {
            BooleanConfigEntry booleanConfigEntry = new BooleanConfigEntry(false);
            booleanConfigEntry.set(((OverlaySourceState)((Object)configEntry.value())).toBoolean());
            booleanConfigEntry.addChangeListener(state -> configEntry.set(OverlaySourceState.fromBoolean(state)));
            ToggleButton widget = new ToggleButton(booleanConfigEntry, 0, 0, 124, 20);
            this.addEntry(new OverlaySourceEntry(this, (McTextComponent)McTextComponent.translatable(sourceLine.getTranslation(), new Object[0]), (GuiAbstractWidget)widget, (ConfigEntry)booleanConfigEntry, null, class_2960.method_12829((String)sourceLine.getIcon()), null));
        } else {
            DropDownWidget widget = new DropDownWidget((VoiceSettingsScreen)this.parent, 0, 0, 124, 20, OVERLAY_DISPLAYS.get(((OverlaySourceState)((Object)configEntry.value())).ordinal() - 2), OVERLAY_DISPLAYS, true, index -> {
                switch (index) {
                    case 0: {
                        configEntry.set(OverlaySourceState.WHEN_TALKING);
                        break;
                    }
                    case 1: {
                        configEntry.set(OverlaySourceState.ALWAYS);
                        break;
                    }
                    case 2: {
                        configEntry.set(OverlaySourceState.NEVER);
                    }
                }
            });
            this.addEntry(new OverlaySourceEntry(this, (McTextComponent)McTextComponent.translatable(sourceLine.getTranslation(), new Object[0]), (GuiAbstractWidget)widget, configEntry, null, class_2960.method_12829((String)sourceLine.getIcon()), (button, element) -> element.setText(OVERLAY_DISPLAYS.get(0))));
        }
    }

    private TabWidget.OptionEntry<DropDownWidget> createShowIcons() {
        DropDownWidget dropdown = new DropDownWidget((VoiceSettingsScreen)this.parent, 0, 0, 124, 20, ICONS_LIST.get((Integer)this.config.getOverlay().getShowSourceIcons().value()), ICONS_LIST, true, index -> this.config.getOverlay().getShowSourceIcons().set((Integer)index));
        return new TabWidget.OptionEntry((TabWidget)this, (McTextComponent)McTextComponent.translatable("gui.plasmovoice.overlay.show_source_icons", new Object[0]), (GuiAbstractWidget)dropdown, (ConfigEntry)this.config.getOverlay().getShowSourceIcons(), (button, element) -> element.setText(ICONS_LIST.get((Integer)this.config.getOverlay().getShowSourceIcons().value())));
    }

    private TabWidget.OptionEntry<Button> createActivationIconPosition() {
        Button button = new Button(0, 0, 124, 20, McTextComponent.translatable(((IconPosition)((Object)this.config.getOverlay().getActivationIconPosition().value())).getTranslation(), new Object[0]), btn -> {
            IconPosition disabledPosition = null;
            try {
                disabledPosition = IconPosition.valueOf(((OverlayPosition)((Object)((Object)this.config.getOverlay().getOverlayPosition().value()))).toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ScreenWrapper.openScreen(new ActivationIconPositionScreen((VoiceSettingsScreen)this.parent, this.config.getOverlay().getActivationIconPosition(), disabledPosition));
        }, Button.NO_TOOLTIP);
        return new TabWidget.OptionEntry((TabWidget)this, (McTextComponent)McTextComponent.translatable("gui.plasmovoice.overlay.activation_icon_position", new Object[0]), (GuiAbstractWidget)button, this.config.getOverlay().getActivationIconPosition(), (btn, element) -> element.setText(McTextComponent.translatable(((IconPosition)((Object)((Object)this.config.getOverlay().getActivationIconPosition().value()))).getTranslation(), new Object[0])));
    }

    private TabWidget.OptionEntry<DropDownWidget> createOverlayStyle() {
        EnumConfigEntry<OverlayStyle> configEntry = this.config.getOverlay().getOverlayStyle();
        DropDownWidget dropDown = new DropDownWidget((VoiceSettingsScreen)this.parent, 0, 0, 124, 20, ((OverlayStyle)((Object)configEntry.value())).getTranslatable(), Arrays.stream(OverlayStyle.values()).map(OverlayStyle::getTranslatable).collect(Collectors.toList()), false, index -> configEntry.set(OverlayStyle.Companion.fromOrdinal((int)index)));
        return new TabWidget.OptionEntry((TabWidget)this, (McTextComponent)McTextComponent.translatable("gui.plasmovoice.overlay.style", new Object[0]), (GuiAbstractWidget)dropDown, configEntry, (btn, element) -> element.setText(((OverlayStyle)((Object)((Object)configEntry.value()))).getTranslatable()));
    }

    private TabWidget.OptionEntry<Button> createOverlayPosition() {
        Button button = new Button(0, 0, 124, 20, McTextComponent.translatable(((OverlayPosition)((Object)this.config.getOverlay().getOverlayPosition().value())).getTranslation(), new Object[0]), btn -> {
            OverlayPosition disabledPosition = null;
            try {
                disabledPosition = OverlayPosition.valueOf(((IconPosition)((Object)((Object)this.config.getOverlay().getActivationIconPosition().value()))).toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ScreenWrapper.openScreen(new OverlayPositionScreen((VoiceSettingsScreen)this.parent, this.config.getOverlay().getOverlayPosition(), disabledPosition));
        }, Button.NO_TOOLTIP);
        return new TabWidget.OptionEntry((TabWidget)this, (McTextComponent)McTextComponent.translatable("gui.plasmovoice.overlay.position", new Object[0]), (GuiAbstractWidget)button, this.config.getOverlay().getOverlayPosition(), (btn, element) -> element.setText(McTextComponent.translatable(((OverlayPosition)((Object)((Object)this.config.getOverlay().getOverlayPosition().value()))).getTranslation(), new Object[0])));
    }

    static class OverlaySourceEntry<W extends GuiAbstractWidget>
    extends TabWidget.OptionEntry<W> {
        private final class_2960 iconLocation;
        final /* synthetic */ OverlayTabWidget this$0;

        public OverlaySourceEntry(@NotNull McTextComponent text, @NotNull W widget, @Nullable ConfigEntry<?> entry, @NotNull McTextComponent tooltip, @Nullable class_2960 iconLocation, TabWidget.OptionResetAction<W> resetAction) {
            this.this$0 = this$0;
            super((TabWidget)this$0, text, widget, entry, tooltip, resetAction);
            this.iconLocation = iconLocation;
        }

        @Override
        protected void renderText(@NotNull GuiRenderContext context, int index, int x, int y, int entryWidth, int mouseX, int mouseY, boolean hovered, float delta) {
            context.blit(this.iconLocation, x, y + this.height / 2 - 8, 0.0f, 0.0f, 16, 16, 16, 16);
            context.drawString(this.text, x + 20, y + this.height / 2 - RenderUtil.getFontHeight() / 2, Colors.WHITE);
        }

        @Override
        protected boolean isDefault() {
            return this.entry.isDefault();
        }

        @Override
        protected void onReset(@NotNull Button button) {
            this.entry.reset();
            if (this.element instanceof UpdatableWidget) {
                ((UpdatableWidget)((Object)this.element)).updateValue();
            }
            if (this.resetAction != null) {
                this.resetAction.onReset(this.resetButton, this.element);
            }
        }
    }
}

