/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.cape.impl.networking;

import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.frozenblock.lib.FrozenSharedConstants;
import net.frozenblock.lib.cape.api.CapeUtil;
import net.frozenblock.lib.cape.impl.Cape;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.Contract;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.NotNull;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.Nullable;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public final class CapeCustomizePacket
implements FabricPacket {
    private static final class_2960 DUMMY = FrozenSharedConstants.id("dummy");
    public static final PacketType<CapeCustomizePacket> PACKET_TYPE = PacketType.create((class_2960)FrozenSharedConstants.id("cape_packet"), CapeCustomizePacket::new);
    private final UUID playerUUID;
    private final boolean enabled;
    private class_2960 capeId = null;

    private CapeCustomizePacket(UUID uuid, boolean enabled) {
        this.playerUUID = uuid;
        this.enabled = enabled;
    }

    private CapeCustomizePacket(UUID uuid, boolean enabled, class_2960 capeId) {
        this(uuid, enabled);
        this.capeId = capeId;
    }

    public CapeCustomizePacket(@NotNull class_2540 buf) {
        this(buf.method_10790(), buf.readBoolean());
        if (this.enabled) {
            this.capeId = buf.method_10810();
        }
    }

    public void write(@NotNull class_2540 buf) {
        buf.method_10797(this.playerUUID);
        buf.writeBoolean(this.enabled);
        if (this.enabled) {
            buf.method_10812(this.capeId);
        }
    }

    @NotNull
    public static CapeCustomizePacket createDisablePacket(UUID uuid) {
        return new CapeCustomizePacket(uuid, false);
    }

    @NotNull
    public static CapeCustomizePacket createPacket(UUID uuid, @Nullable class_2960 capeId) {
        return new CapeCustomizePacket(uuid, !CapeCustomizePacket.shouldDisable(CapeUtil.getCape(capeId).orElse(null)), capeId);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static CapeCustomizePacket createPacket(UUID uuid, @NotNull Cape cape) {
        return new CapeCustomizePacket(uuid, !CapeCustomizePacket.shouldDisable(cape), cape.registryId());
    }

    public static void sendCapeToAll(MinecraftServer server, UUID uuid, @Nullable class_2960 capeId) {
        CapeCustomizePacket frozenCapePacket = CapeCustomizePacket.createPacket(uuid, capeId);
        PlayerLookup.all((MinecraftServer)server).forEach(player -> ServerPlayNetworking.send((class_3222)player, (FabricPacket)frozenCapePacket));
    }

    public static boolean shouldDisable(Cape cape) {
        return cape == null || CapeCustomizePacket.shouldDisable(cape.registryId()) || cape.texture() == null;
    }

    public static boolean shouldDisable(class_2960 capeId) {
        return capeId == null || capeId.equals((Object)DUMMY);
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public class_2960 getCapeId() {
        return this.capeId;
    }

    public PacketType<?> getType() {
        return PACKET_TYPE;
    }
}

