/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.image_transfer;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.frozenblock.lib.FrozenSharedConstants;
import net.frozenblock.lib.config.frozenlib_config.FrozenLibConfig;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.NotNull;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.Nullable;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public record FileTransferPacket(String transferPath, String fileName, boolean request, byte[] bytes) implements FabricPacket
{
    public static final PacketType<FileTransferPacket> PACKET_TYPE = PacketType.create((class_2960)FrozenSharedConstants.id("file_transfer"), FileTransferPacket::create);

    @NotNull
    public static FileTransferPacket create(@NotNull class_2540 buf) {
        return new FileTransferPacket(buf.method_19772(), buf.method_19772(), buf.readBoolean(), buf.method_10795());
    }

    @NotNull
    public static FileTransferPacket create(String destPath, @NotNull File file) throws IOException {
        return new FileTransferPacket(destPath, file.getName(), false, FileTransferPacket.readFile(file));
    }

    @NotNull
    public static FileTransferPacket createRequest(String directory, String fileName) {
        return new FileTransferPacket(directory, fileName, true, new byte[0]);
    }

    private static byte @Nullable [] readFile(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            fileInputStream.transferTo(byteArrayOutputStream);
            fileInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void sendToPlayer(File file, String transferPath, class_3222 player) throws IOException {
        if (!FrozenLibConfig.FILE_TRANSFER_SERVER) {
            return;
        }
        ServerPlayNetworking.send((class_3222)player, (FabricPacket)FileTransferPacket.create(transferPath, file));
    }

    public void write(@NotNull class_2540 buf) {
        buf.method_10814(this.transferPath);
        buf.method_10814(this.fileName);
        buf.writeBoolean(this.request);
        buf.method_10813(this.bytes);
    }

    public PacketType<?> getType() {
        return PACKET_TYPE;
    }
}

