/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.screenshake.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.frozenblock.lib.FrozenSharedConstants;
import net.frozenblock.lib.screenshake.api.ScreenShakeManager;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public class EntityScreenShakeManager {
    private final ArrayList<EntityScreenShake> shakes = new ArrayList();
    public class_1297 entity;

    public EntityScreenShakeManager(class_1297 entity) {
        this.entity = entity;
    }

    public void load(class_2487 nbt) {
        if (nbt.method_10573("ScreenShakes", 9)) {
            this.shakes.clear();
            DataResult var10000 = EntityScreenShake.CODEC.listOf().parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)nbt.method_10554("ScreenShakes", 10)));
            NOPLogger var10001 = FrozenSharedConstants.LOGGER4;
            Objects.requireNonNull(var10001);
            Optional list = var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0));
            list.ifPresent(this.shakes::addAll);
        }
    }

    public void save(class_2487 nbt) {
        if (!this.shakes.isEmpty()) {
            DataResult var10000 = EntityScreenShake.CODEC.listOf().encodeStart((DynamicOps)class_2509.field_11560, this.shakes);
            NOPLogger var10001 = FrozenSharedConstants.LOGGER4;
            Objects.requireNonNull(var10001);
            var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0)).ifPresent(cursorsNbt -> nbt.method_10566("ScreenShakes", cursorsNbt));
        }
    }

    public void addShake(float intensity, int duration, int durationFalloffStart, float maxDistance, int ticks) {
        this.shakes.add(new EntityScreenShake(intensity, duration, durationFalloffStart, maxDistance, ticks));
    }

    public void tick() {
        this.shakes.removeIf(EntityScreenShake::shouldRemove);
        for (EntityScreenShake entityScreenShake : this.shakes) {
            ++entityScreenShake.ticks;
        }
    }

    public void syncWithPlayer(class_3222 serverPlayer) {
        for (EntityScreenShake nbt : this.getShakes()) {
            ScreenShakeManager.sendEntityScreenShakeTo(serverPlayer, this.entity, nbt.intensity, nbt.duration, nbt.durationFalloffStart, nbt.maxDistance, nbt.ticks);
        }
    }

    public ArrayList<EntityScreenShake> getShakes() {
        return this.shakes;
    }

    public static class EntityScreenShake {
        public final float intensity;
        public final int duration;
        public final int durationFalloffStart;
        public final float maxDistance;
        public int ticks;
        public static final Codec<EntityScreenShake> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("Intensity").forGetter(EntityScreenShake::getIntensity), (App)Codec.INT.fieldOf("Duration").forGetter(EntityScreenShake::getDuration), (App)Codec.INT.fieldOf("FalloffStart").forGetter(EntityScreenShake::getDurationFalloffStart), (App)Codec.FLOAT.fieldOf("MaxDistance").forGetter(EntityScreenShake::getMaxDistance), (App)Codec.INT.fieldOf("Ticks").forGetter(EntityScreenShake::getTicks)).apply((Applicative)instance, EntityScreenShake::new));

        public EntityScreenShake(float intensity, int duration, int durationFalloffStart, float maxDistance, int ticks) {
            this.intensity = intensity;
            this.duration = duration;
            this.durationFalloffStart = durationFalloffStart;
            this.maxDistance = maxDistance;
            this.ticks = ticks;
        }

        public boolean shouldRemove() {
            return this.ticks > this.duration;
        }

        public float getIntensity() {
            return this.intensity;
        }

        public int getDuration() {
            return this.duration;
        }

        public int getDurationFalloffStart() {
            return this.durationFalloffStart;
        }

        public float getMaxDistance() {
            return this.maxDistance;
        }

        public int getTicks() {
            return this.ticks;
        }
    }
}

