/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.blue.endless.jankson;

import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.frozenblock.lib.shadow.blue.endless.jankson.JsonArray;
import net.frozenblock.lib.shadow.blue.endless.jankson.JsonElement;
import net.frozenblock.lib.shadow.blue.endless.jankson.JsonGrammar;
import net.frozenblock.lib.shadow.blue.endless.jankson.JsonNull;
import net.frozenblock.lib.shadow.blue.endless.jankson.JsonPrimitive;
import net.frozenblock.lib.shadow.blue.endless.jankson.api.JanksonOps;
import net.frozenblock.lib.shadow.blue.endless.jankson.api.Marshaller;
import net.frozenblock.lib.shadow.blue.endless.jankson.impl.MarshallerImpl;
import net.frozenblock.lib.shadow.blue.endless.jankson.impl.serializer.CommentSerializer;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.NotNull;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.Nullable;

public class JsonObject
extends JsonElement
implements Map<String, JsonElement> {
    private static final Predicate<String> CAN_BE_UNQUOTED = Pattern.compile("^[a-zA-Z0-9]+$").asPredicate();
    protected Marshaller marshaller = MarshallerImpl.getFallback();
    private List<Entry> entries = new ArrayList<Entry>();

    @Override
    public void dataFix(@NotNull DataFixer dataFixer, int newVersion) {
        boolean shouldAddVersion = true;
        String versionKey = "jankson:schema_version";
        for (Entry entry : this.entries) {
            if (!versionKey.equals(entry.key)) continue;
            shouldAddVersion = false;
            break;
        }
        if (shouldAddVersion) {
            this.entries.add(0, new Entry("The version of this JSON file\nDon't modify!", versionKey, JanksonOps.INSTANCE.createNumeric(newVersion)));
        }
        Entry versionEntry = null;
        for (Entry entry : this.entries) {
            if (!versionKey.equals(entry.key)) continue;
            versionEntry = entry;
            break;
        }
        assert (versionEntry != null);
        int n = ((JsonPrimitive)versionEntry.value).asInt(newVersion);
        for (Entry entry : this.entries) {
            Dynamic dynamic = new Dynamic((DynamicOps)JanksonOps.INSTANCE, (Object)entry.value);
            entry.value = (JsonElement)dataFixer.update(JanksonOps.TYPE, dynamic, n, newVersion).getValue();
        }
    }

    @Nullable
    public JsonObject getObject(@NotNull String name) {
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(name)) continue;
            JsonElement jsonElement = entry.value;
            if (jsonElement instanceof JsonObject) {
                JsonObject object = (JsonObject)jsonElement;
                return object;
            }
            return null;
        }
        return null;
    }

    public JsonElement put(@NotNull String key, @NotNull JsonElement elem, @Nullable String comment) {
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(key)) continue;
            JsonElement result = entry.value;
            entry.value = elem;
            entry.setComment(comment);
            return result;
        }
        Entry entry = new Entry();
        if (elem instanceof JsonObject) {
            ((JsonObject)elem).marshaller = this.marshaller;
        }
        if (elem instanceof JsonArray) {
            ((JsonArray)elem).marshaller = this.marshaller;
        }
        entry.key = key;
        entry.value = elem;
        entry.setComment(comment);
        this.entries.add(entry);
        return null;
    }

    @NotNull
    public JsonElement putDefault(@NotNull String key, @NotNull JsonElement elem, @Nullable String comment) {
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(key)) continue;
            return entry.value;
        }
        Entry entry = new Entry();
        entry.key = key;
        entry.value = elem;
        entry.setComment(comment);
        this.entries.add(entry);
        return elem;
    }

    @Nullable
    public <T> T putDefault(@NotNull String key, @NotNull T elem, @Nullable String comment) {
        return this.putDefault(key, elem, elem.getClass(), comment);
    }

    @Nullable
    public <T> T putDefault(@NotNull String key, @NotNull T elem, Class<? extends T> clazz, @Nullable String comment) {
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(key)) continue;
            return this.marshaller.marshall(clazz, entry.value);
        }
        Entry entry = new Entry();
        entry.key = key;
        entry.value = this.marshaller.serialize(elem);
        if (entry.value == null) {
            entry.value = JsonNull.INSTANCE;
        }
        entry.setComment(comment);
        this.entries.add(entry);
        return elem;
    }

    @NotNull
    public JsonObject getDelta(@NotNull JsonObject defaults) {
        JsonObject result = new JsonObject();
        for (Entry entry : this.entries) {
            String key = entry.key;
            JsonElement defaultValue = defaults.get(key);
            if (defaultValue == null) {
                result.put(entry.key, entry.value, entry.getComment());
                continue;
            }
            JsonElement jsonElement = entry.value;
            if (jsonElement instanceof JsonObject) {
                JsonObject object = (JsonObject)jsonElement;
                if (defaultValue instanceof JsonObject) {
                    JsonObject defaultObject = (JsonObject)defaultValue;
                    JsonObject subDelta = object.getDelta(defaultObject);
                    if (subDelta.isEmpty()) continue;
                    result.put(entry.key, subDelta, entry.getComment());
                    continue;
                }
            }
            if (entry.value.equals(defaultValue)) continue;
            result.put(entry.key, entry.value, entry.getComment());
        }
        return result;
    }

    @Nullable
    public String getComment(@NotNull String name) {
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(name)) continue;
            return entry.getComment();
        }
        return null;
    }

    public void setComment(@NotNull String name, @Nullable String comment) {
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(name)) continue;
            entry.setComment(comment);
            return;
        }
    }

    @Override
    public String toJson(boolean comments, boolean newlines, int depth) {
        JsonGrammar grammar = JsonGrammar.builder().withComments(comments).printWhitespace(newlines).build();
        return this.toJson(grammar, depth);
    }

    @Override
    public void toJson(Writer w, JsonGrammar grammar, int depth) throws IOException {
        int nextDepth;
        boolean skipBraces = depth == 0 && grammar.bareRootObject;
        int effectiveDepth = grammar.bareRootObject ? depth - 1 : depth;
        int n = nextDepth = grammar.bareRootObject ? depth : depth + 1;
        if (!skipBraces) {
            w.append("{");
            if (grammar.printWhitespace && this.entries.size() > 0) {
                w.append('\n');
            } else {
                w.append(' ');
            }
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            boolean quoted;
            Entry entry = this.entries.get(i);
            if (grammar.printWhitespace) {
                for (int j = 0; j < nextDepth; ++j) {
                    w.append("\t");
                }
            }
            CommentSerializer.print(w, entry.getComment(), effectiveDepth, grammar);
            boolean bl = quoted = !grammar.printUnquotedKeys;
            if (!CAN_BE_UNQUOTED.test(entry.key)) {
                quoted = true;
            }
            if (quoted) {
                w.append("\"");
            }
            w.append(entry.key);
            if (quoted) {
                w.append("\"");
            }
            w.append(": ");
            w.append(entry.value.toJson(grammar, depth + 1));
            if (grammar.printCommas) {
                if (i < this.entries.size() - 1 || grammar.printTrailingCommas) {
                    w.append(",");
                    if (i < this.entries.size() - 1 && !grammar.printWhitespace) {
                        w.append(' ');
                    }
                }
            } else if (!grammar.printWhitespace) {
                w.append(" ");
            }
            if (!grammar.printWhitespace) continue;
            w.append('\n');
        }
        if (!skipBraces) {
            if (!this.entries.isEmpty()) {
                if (grammar.printWhitespace) {
                    for (int j = 0; j < effectiveDepth; ++j) {
                        w.append("\t");
                    }
                } else {
                    w.append(' ');
                }
            }
            w.append("}");
        }
    }

    public String toString() {
        return this.toJson(true, false, 0);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof JsonObject)) {
            return false;
        }
        JsonObject otherObject = (JsonObject)other;
        if (this.entries.size() != otherObject.entries.size()) {
            return false;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry b;
            Entry a = this.entries.get(i);
            if (a.equals(b = otherObject.entries.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.entries.hashCode();
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    @Nullable
    public <E> E get(@NotNull Class<E> clazz, @NotNull String key) {
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Cannot get from empty key");
        }
        JsonElement elem = this.get(key);
        return this.marshaller.marshall(clazz, elem);
    }

    public boolean getBoolean(@NotNull String key, boolean defaultValue) {
        JsonElement elem = this.get(key);
        if (elem instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)elem;
            return primitive.asBoolean(defaultValue);
        }
        return defaultValue;
    }

    public byte getByte(@NotNull String key, byte defaultValue) {
        JsonElement elem = this.get(key);
        if (elem instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)elem;
            return ((JsonPrimitive)elem).asByte(defaultValue);
        }
        return defaultValue;
    }

    public char getChar(@NotNull String key, char defaultValue) {
        JsonElement elem = this.get(key);
        if (elem instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)elem;
            return primitive.asChar(defaultValue);
        }
        return defaultValue;
    }

    public short getShort(@NotNull String key, short defaultValue) {
        JsonElement elem = this.get(key);
        if (elem instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)elem;
            return primitive.asShort(defaultValue);
        }
        return defaultValue;
    }

    public int getInt(@NotNull String key, int defaultValue) {
        JsonElement elem = this.get(key);
        if (elem instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)elem;
            return primitive.asInt(defaultValue);
        }
        return defaultValue;
    }

    public long getLong(@NotNull String key, long defaultValue) {
        JsonElement elem = this.get(key);
        if (elem instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)elem;
            return primitive.asLong(defaultValue);
        }
        return defaultValue;
    }

    public float getFloat(@NotNull String key, float defaultValue) {
        JsonElement elem = this.get(key);
        if (elem instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)elem;
            return primitive.asFloat(defaultValue);
        }
        return defaultValue;
    }

    public double getDouble(@NotNull String key, double defaultValue) {
        JsonElement elem = this.get(key);
        if (elem instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)elem;
            return primitive.asDouble(defaultValue);
        }
        return defaultValue;
    }

    @Nullable
    public <E> E recursiveGet(@NotNull Class<E> clazz, @NotNull String key) {
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Cannot get from empty key");
        }
        String[] parts = key.split("\\.");
        JsonObject cur = this;
        for (int i = 0; i < parts.length; ++i) {
            JsonObject object;
            String s = parts[i];
            if (s.isEmpty()) {
                throw new IllegalArgumentException("Cannot get from broken key '" + key + "'");
            }
            JsonElement elem = cur.get(s);
            if (i < parts.length - 1) {
                if (!(elem instanceof JsonObject)) {
                    return null;
                }
            } else {
                return this.marshaller.marshall(clazz, elem);
            }
            cur = object = (JsonObject)elem;
        }
        throw new IllegalArgumentException("Cannot get from broken key '" + key + "'");
    }

    public <E extends JsonElement> E recursiveGetOrCreate(@NotNull Class<E> clazz, @NotNull String key, @NotNull E fallback, @Nullable String comment) {
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Cannot get from empty key");
        }
        String[] parts = key.split("\\.");
        JsonObject cur = this;
        for (int i = 0; i < parts.length; ++i) {
            String s = parts[i];
            if (s.isEmpty()) {
                throw new IllegalArgumentException("Cannot get from broken key '" + key + "'");
            }
            JsonElement elem = cur.get(s);
            if (i < parts.length - 1) {
                if (elem instanceof JsonObject) {
                    JsonObject object;
                    cur = object = (JsonObject)elem;
                    continue;
                }
                JsonObject replacement = new JsonObject();
                cur.put(s, replacement);
                cur = replacement;
                continue;
            }
            if (elem != null && clazz.isAssignableFrom(elem.getClass())) {
                return (E)elem;
            }
            JsonElement result = fallback.clone();
            cur.put(s, result, comment);
            return (E)result;
        }
        throw new IllegalArgumentException("Cannot get from broken key '" + key + "'");
    }

    @Override
    public JsonObject clone() {
        JsonObject result = new JsonObject();
        for (Entry entry : this.entries) {
            result.put(entry.key, entry.value.clone(), entry.comment);
        }
        result.marshaller = this.marshaller;
        return result;
    }

    @Override
    @Nullable
    public JsonElement put(@NotNull String key, @NotNull JsonElement elem) {
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(key)) continue;
            JsonElement result = entry.value;
            entry.value = elem;
            return result;
        }
        Entry entry = new Entry();
        entry.key = key;
        entry.value = elem;
        this.entries.add(entry);
        return null;
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        if (key == null) {
            return false;
        }
        if (!(key instanceof String)) {
            return false;
        }
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase((String)key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(@Nullable Object val) {
        if (val == null) {
            return false;
        }
        if (!(val instanceof JsonElement)) {
            return false;
        }
        for (Entry entry : this.entries) {
            if (!entry.value.equals(val)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, JsonElement>> entrySet() {
        LinkedHashSet<Map.Entry<String, JsonElement>> result = new LinkedHashSet<Map.Entry<String, JsonElement>>();
        for (final Entry entry : this.entries) {
            result.add(new Map.Entry<String, JsonElement>(){

                @Override
                public String getKey() {
                    return entry.key;
                }

                @Override
                public JsonElement getValue() {
                    return entry.value;
                }

                @Override
                public JsonElement setValue(JsonElement value) {
                    JsonElement oldValue = entry.value;
                    entry.value = value;
                    return oldValue;
                }
            });
        }
        return result;
    }

    @Override
    @Nullable
    public JsonElement get(@Nullable Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        String str = (String)key;
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(str)) continue;
            return entry.value;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    @NotNull
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        for (Entry entry : this.entries) {
            keys.add(entry.key);
        }
        return keys;
    }

    @Override
    public void putAll(Map<? extends String, ? extends JsonElement> map) {
        for (Map.Entry<? extends String, ? extends JsonElement> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @Nullable
    public JsonElement remove(@Nullable Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        String str = (String)key;
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry entry = this.entries.get(i);
            if (!entry.key.equalsIgnoreCase(str)) continue;
            return this.entries.remove((int)i).value;
        }
        return null;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public Collection<JsonElement> values() {
        ArrayList<JsonElement> values = new ArrayList<JsonElement>();
        for (Entry entry : this.entries) {
            values.add(entry.value);
        }
        return values;
    }

    private static final class Entry {
        private String comment;
        private String key;
        private JsonElement value;

        private Entry(String comment, String key, JsonElement value) {
            this.comment = comment;
            this.key = key;
            this.value = value;
        }

        private Entry() {
            this(null, null, null);
        }

        public boolean equals(Object other) {
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry o = (Entry)other;
            if (!this.comment.equals(o.comment)) {
                return false;
            }
            if (!this.key.equals(o.key)) {
                return false;
            }
            return this.value.equals(o.value);
        }

        public int hashCode() {
            return Objects.hash(this.comment, this.key, this.value);
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment != null && !comment.trim().isEmpty() ? comment : null;
        }
    }
}

