/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data;

import java.util.function.Function;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.NotNull;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.Nullable;
import net.frozenblock.lib.shadow.xjs.data.Json;
import net.frozenblock.lib.shadow.xjs.data.JsonValue;

public class JsonReference {
    protected JsonValue referent;
    protected boolean accessed;
    protected boolean mutable;

    public JsonReference(@Nullable JsonValue referent) {
        this.referent = Json.nonnull(referent);
        this.accessed = false;
        this.mutable = true;
    }

    @NotNull
    public JsonValue get() {
        this.accessed = true;
        return this.getOnly();
    }

    public JsonValue getOnly() {
        return this.referent;
    }

    public JsonReference set(@Nullable JsonValue referent) {
        this.accessed = true;
        return this.setOnly(referent);
    }

    public JsonReference setOnly(@Nullable JsonValue referent) {
        this.checkMutable();
        this.referent = Json.nonnull(referent);
        return this;
    }

    public JsonReference apply(Function<JsonValue, Object> updater) {
        this.accessed = true;
        return this.applyOnly(updater);
    }

    public JsonReference applyOnly(Function<JsonValue, Object> updater) {
        this.checkMutable();
        Object result = updater.apply(this.referent);
        this.referent = result instanceof JsonValue ? (JsonValue)result : Json.any(result).setDefaultMetadata(this.referent);
        return this;
    }

    public boolean isAccessed() {
        return this.accessed;
    }

    public JsonReference setAccessed(boolean accessed) {
        this.accessed = accessed;
        return this;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public JsonReference freeze() {
        this.mutable = false;
        return this;
    }

    private void checkMutable() {
        if (!this.mutable) {
            throw new UnsupportedOperationException("Reference is immutable: " + this);
        }
    }

    public JsonReference copy(boolean trackAccess) {
        JsonReference clone = new JsonReference(this.referent);
        return trackAccess ? clone.setAccessed(this.accessed) : clone;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.referent.hashCode();
        if (this.accessed) {
            result *= 17;
        }
        if (this.mutable) {
            result *= 31;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof JsonReference) {
            JsonReference other = (JsonReference)o;
            return this.referent.equals(other.referent) && this.accessed == other.accessed && this.mutable == other.mutable;
        }
        return false;
    }

    public String toString() {
        return this.referent.toString();
    }
}

