/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.block_hit_effects;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.block_hit_effects.ProjectileHitEffect;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;

public class ProjectileHitEffectsHandler {
    private static final Map<class_1299<?>, ProjectileHitEffect> PROJECTILE_MAP = new Reference2ObjectOpenHashMap();
    private static final ProjectileHitEffect DEFAULT = new ProjectileHitEffect(1.0f, 3.0f, -0.5f, 3.5f);

    public static ProjectileHitEffect getProperties(class_1297 entity) {
        return ProjectileHitEffectsHandler.getProperties(entity.method_5864());
    }

    public static ProjectileHitEffect getProperties(class_1299<?> entityType) {
        return PROJECTILE_MAP.getOrDefault(entityType, DEFAULT);
    }

    public static class ReloadListener
    extends class_4309 {
        private static final Gson GSON = new Gson();
        public static final ReloadListener INSTANCE = new ReloadListener();

        ReloadListener() {
            super(GSON, "projectile_hit_effects");
        }

        protected void apply(Map<class_2960, JsonElement> map, class_3300 manager, class_3695 profiler) {
            PROJECTILE_MAP.clear();
            for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
                JsonElement el = entry.getValue();
                if (!el.isJsonObject()) continue;
                try {
                    class_2960 loc = entry.getKey();
                    class_1299<?> entityType = CBCRegistryUtils.getOptionalEntityType(loc).orElseThrow(() -> new JsonSyntaxException("Unknown block '" + loc + "'"));
                    PROJECTILE_MAP.put(entityType, ProjectileHitEffect.fromJson(el.getAsJsonObject()));
                }
                catch (Exception e) {
                    CreateBigCannons.LOGGER.warn("Exception loading projectile hit effects: {}", (Object)e.getMessage());
                }
            }
        }
    }
}

