/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights;

import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;

public final class LambDynLightsCompat {
    private static final SodiumInstallation SODIUM_INSTALLATION = FabricLoader.getInstance().getModContainer("sodium").map(mod -> {
        try {
            if (mod.getMetadata().getVersion().compareTo((Object)Version.parse((String)"0.6.0")) >= 0) {
                return SodiumInstallation.V06X;
            }
            if (mod.getMetadata().getVersion().compareTo((Object)Version.parse((String)"0.5.0")) >= 0) {
                return SodiumInstallation.V05X;
            }
            return SodiumInstallation.OLDER;
        }
        catch (VersionParsingException e) {
            throw new RuntimeException(e);
        }
    }).orElse(SodiumInstallation.NONE);

    public static boolean isCanvasInstalled() {
        return FabricLoader.getInstance().isModLoaded("canvas");
    }

    public static SodiumInstallation isSodiumInstalled() {
        return SODIUM_INSTALLATION;
    }

    public static enum SodiumInstallation {
        NONE,
        V06X,
        V05X,
        OLDER;

    }
}

