/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.engine.source;

import dev.lambdaurora.lambdynlights.engine.CellHasher;
import dev.lambdaurora.lambdynlights.engine.lookup.SpatialLookupCollectionEntry;
import dev.lambdaurora.lambdynlights.engine.lookup.SpatialLookupEntry;
import dev.lambdaurora.lambdynlights.engine.source.DynamicLightSource;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteList;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Stream;
import net.minecraft.class_2338;
import org.jetbrains.annotations.NotNull;

public class CollectionDynamicLightSource
implements DynamicLightSource {
    private boolean dirty;
    private Collection<Entry> entries;

    public CollectionDynamicLightSource(Collection<Entry> entries) {
        this.entries = entries;
        this.dirty = true;
    }

    @Override
    public Stream<SpatialLookupEntry> splitIntoDynamicLightEntries(@NotNull CellHasher cellHasher) {
        record Data(LongList position, ByteList luminance) {
        }
        Int2ObjectOpenHashMap cellKeyToData = new Int2ObjectOpenHashMap();
        for (Entry entry2 : this.entries) {
            int cellKey = cellHasher.hashAt(entry2.x(), entry2.y(), entry2.z());
            Data data = (Data)cellKeyToData.computeIfAbsent(cellKey, k -> new Data((LongList)new LongArrayList(), (ByteList)new ByteArrayList()));
            data.position.add(class_2338.method_10064((int)entry2.x(), (int)entry2.y(), (int)entry2.z()));
            data.luminance.add((byte)entry2.luminance());
        }
        return cellKeyToData.int2ObjectEntrySet().stream().map(entry -> new SpatialLookupCollectionEntry(entry.getIntKey(), ((Data)entry.getValue()).position.toLongArray(), ((Data)entry.getValue()).luminance.toByteArray()));
    }

    @Override
    public LongSet getDynamicLightChunksToRebuild(boolean forced) {
        if (!forced && !this.dirty) {
            return LongSet.of();
        }
        LongOpenHashSet chunks = new LongOpenHashSet();
        for (Entry entry : this.entries) {
            DynamicLightSource.gatherClosestChunks((LongSet)chunks, entry.x, entry.y, entry.z);
        }
        return chunks;
    }

    public static CollectionDynamicLightSource cuboid(int startX, int startY, int startZ, int endX, int endY, int endZ, int luminance) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (int x = startX; x <= endX; ++x) {
            for (int y = startY; y <= endY; ++y) {
                for (int z = startZ; z <= endZ; ++z) {
                    entries.add(new Entry(x, y, z, luminance));
                }
            }
        }
        return new CollectionDynamicLightSource(entries);
    }

    public record Entry(int x, int y, int z, int luminance) {
    }
}

