/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.util;

import dev.lambdaurora.lambdynlights.DynamicLightsConfig;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.spruceui.util.ColorUtil;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_251;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_761;
import net.minecraft.class_863;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public abstract class DynamicLightDebugRenderer
implements class_863.class_864 {
    final class_310 client = class_310.method_1551();
    final DynamicLightsConfig config;

    public DynamicLightDebugRenderer(LambDynLights mod) {
        this.config = mod.config;
    }

    static void renderFaces(class_4587 matrices, class_251 shape, class_2382 origin, class_4588 vertexConsumer, double x, double y, double z, int cellSize, int color) {
        shape.method_1046((direction, cellX, cellY, cellZ) -> {
            int realCellX = cellX + origin.method_10263();
            int realCellY = cellY + origin.method_10264();
            int realCellZ = cellZ + origin.method_10260();
            DynamicLightDebugRenderer.renderFace(matrices, vertexConsumer, direction, x, y, z, cellSize, realCellX, realCellY, realCellZ, color);
        });
    }

    static void renderEdges(class_4587 matrices, class_251 shape, class_2382 origin, class_4597 multiBufferSource, double x, double y, double z, int cellSize, int color) {
        shape.method_1064((startCellX, startCellY, startCellZ, endCellX, endCellY, endCellZ) -> {
            int realStartCellX = startCellX + origin.method_10263();
            int realStartCellY = startCellY + origin.method_10264();
            int realStartCellZ = startCellZ + origin.method_10260();
            int realEndCellX = endCellX + origin.method_10263();
            int realEndCellY = endCellY + origin.method_10264();
            int realEndCellZ = endCellZ + origin.method_10260();
            class_4588 vertexConsumer = multiBufferSource.getBuffer(class_1921.method_49043((double)1.0));
            DynamicLightDebugRenderer.renderEdge(matrices, vertexConsumer, x, y, z, cellSize, realStartCellX, realStartCellY, realStartCellZ, realEndCellX, realEndCellY, realEndCellZ, color);
        }, true);
    }

    static void renderFace(class_4587 matrices, class_4588 vertexConsumer, class_2350 direction, double x, double y, double z, int cellSize, int cellX, int cellY, int cellZ, int color) {
        float faceX = (float)((double)(cellX * cellSize) - x);
        float faceY = (float)((double)(cellY * cellSize) - y);
        float faceZ = (float)((double)(cellZ * cellSize) - z);
        DynamicLightDebugRenderer.renderFace(matrices, vertexConsumer, direction, faceX, faceY, faceZ, faceX + (float)cellSize, faceY + (float)cellSize, faceZ + (float)cellSize, ColorUtil.floatColor((int)ColorUtil.argbUnpackRed((int)color)), ColorUtil.floatColor((int)ColorUtil.argbUnpackGreen((int)color)), ColorUtil.floatColor((int)ColorUtil.argbUnpackBlue((int)color)), ColorUtil.floatColor((int)ColorUtil.argbUnpackAlpha((int)color)));
    }

    static void renderEdge(class_4587 matrices, class_4588 vertexConsumer, double x, double y, double z, int cellSize, int startCellX, int startCellY, int startCellZ, int endCellX, int endCellY, int endCellZ, int color) {
        float startX = (float)((double)(startCellX * cellSize) - x);
        float startY = (float)((double)(startCellY * cellSize) - y);
        float startZ = (float)((double)(startCellZ * cellSize) - z);
        float endX = (float)((double)(endCellX * cellSize) - x);
        float endY = (float)((double)(endCellY * cellSize) - y);
        float endZ = (float)((double)(endCellZ * cellSize) - z);
        DynamicLightDebugRenderer.renderLine(matrices, vertexConsumer, startX, startY, startZ, endX, endY, endZ, color);
    }

    static void renderLine(class_4587 matrices, class_4588 vertexConsumer, float startX, float startY, float startZ, float endX, float endY, float endZ, int color) {
        Matrix4f modelMatrix = matrices.method_23760().method_23761();
        vertexConsumer.method_22918(modelMatrix, startX, startY, startZ).method_39415(color);
        vertexConsumer.method_22918(modelMatrix, endX, endY, endZ).method_39415(color);
    }

    private static void renderFace(class_4587 matrices, class_4588 vertexConsumer, class_2350 direction, float startX, float startY, float startZ, float endX, float endY, float endZ, float red, float green, float blue, float alpha) {
        Matrix4f model = matrices.method_23760().method_23761();
        switch (direction) {
            case field_11033: {
                vertexConsumer.method_22918(model, startX, startY, startZ).method_22915(red, green, blue, alpha).method_1344();
                vertexConsumer.method_22918(model, endX, startY, startZ).method_22915(red, green, blue, alpha).method_1344();
                vertexConsumer.method_22918(model, endX, startY, endZ).method_22915(red, green, blue, alpha).method_1344();
                vertexConsumer.method_22918(model, startX, startY, endZ).method_22915(red, green, blue, alpha).method_1344();
                break;
            }
            case field_11036: {
                vertexConsumer.method_22918(model, startX, endY, startZ).method_22915(red, green, blue, alpha).method_1344();
                vertexConsumer.method_22918(model, startX, endY, endZ).method_22915(red, green, blue, alpha).method_1344();
                vertexConsumer.method_22918(model, endX, endY, endZ).method_22915(red, green, blue, alpha).method_1344();
                vertexConsumer.method_22918(model, endX, endY, startZ).method_22915(red, green, blue, alpha).method_1344();
                break;
            }
            case field_11043: {
                vertexConsumer.method_22918(model, startX, startY, startZ).method_22915(red, green, blue, alpha).method_1344();
                vertexConsumer.method_22918(model, startX, endY, startZ).method_22915(red, green, blue, alpha).method_1344();
                vertexConsumer.method_22918(model, endX, endY, startZ).method_22915(red, green, blue, alpha).method_1344();
                vertexConsumer.method_22918(model, endX, startY, startZ).method_22915(red, green, blue, alpha).method_1344();
                break;
            }
            case field_11035: {
                vertexConsumer.method_22918(model, startX, startY, endZ).method_22915(red, green, blue, alpha).method_1344();
                vertexConsumer.method_22918(model, endX, startY, endZ).method_22915(red, green, blue, alpha).method_1344();
                vertexConsumer.method_22918(model, endX, endY, endZ).method_22915(red, green, blue, alpha).method_1344();
                vertexConsumer.method_22918(model, startX, endY, endZ).method_22915(red, green, blue, alpha).method_1344();
                break;
            }
            case field_11039: {
                vertexConsumer.method_22918(model, startX, startY, startZ).method_22915(red, green, blue, alpha).method_1344();
                vertexConsumer.method_22918(model, startX, startY, endZ).method_22915(red, green, blue, alpha).method_1344();
                vertexConsumer.method_22918(model, startX, endY, endZ).method_22915(red, green, blue, alpha).method_1344();
                vertexConsumer.method_22918(model, startX, endY, startZ).method_22915(red, green, blue, alpha).method_1344();
                break;
            }
            case field_11034: {
                vertexConsumer.method_22918(model, endX, startY, startZ).method_22915(red, green, blue, alpha).method_1344();
                vertexConsumer.method_22918(model, endX, endY, startZ).method_22915(red, green, blue, alpha).method_1344();
                vertexConsumer.method_22918(model, endX, endY, endZ).method_22915(red, green, blue, alpha).method_1344();
                vertexConsumer.method_22918(model, endX, startY, endZ).method_22915(red, green, blue, alpha).method_1344();
            }
        }
    }

    public static class SectionRebuild
    extends DynamicLightDebugRenderer {
        private static final int COLOR = 1057004031;
        private final Long2IntMap chunks = new Long2IntOpenHashMap();

        public SectionRebuild(LambDynLights mod) {
            super(mod);
        }

        private boolean isEnabled() {
            return (Boolean)this.config.getDebugDisplayDynamicLightingChunkRebuilds().get();
        }

        public void method_23109(class_4587 matrices, class_4597 bufferSource, double x, double y, double z) {
            if (!this.isEnabled()) {
                return;
            }
            matrices.method_22903();
            matrices.method_22904(-x, -y, -z);
            for (Long2IntMap.Entry entry : this.chunks.long2IntEntrySet()) {
                class_4076 chunk = class_4076.method_18677((long)entry.getLongKey());
                float red = ColorUtil.floatColor((int)ColorUtil.argbUnpackRed((int)1057004031));
                float green = ColorUtil.floatColor((int)ColorUtil.argbUnpackGreen((int)1057004031));
                float blue = ColorUtil.floatColor((int)ColorUtil.argbUnpackBlue((int)1057004031));
                float alpha = (float)entry.getIntValue() / 4.0f;
                class_761.method_22980((class_4587)matrices, (class_4588)bufferSource.getBuffer(class_1921.method_23594()), (double)chunk.method_19527(), (double)chunk.method_19528(), (double)chunk.method_19529(), (double)class_4076.method_32205((int)chunk.method_18674(), (int)16), (double)class_4076.method_32205((int)chunk.method_18683(), (int)16), (double)class_4076.method_32205((int)chunk.method_18687(), (int)16), (float)red, (float)green, (float)blue, (float)alpha);
            }
            matrices.method_22909();
        }

        public void scheduleChunkRebuild(long chunkPos) {
            if (!this.isEnabled()) {
                return;
            }
            this.chunks.put(chunkPos, 4);
        }

        public void tick() {
            if (!this.isEnabled()) {
                return;
            }
            ObjectIterator iterator = this.chunks.long2IntEntrySet().iterator();
            while (iterator.hasNext()) {
                Long2IntMap.Entry entry = (Long2IntMap.Entry)iterator.next();
                if (entry.getIntValue() == 0) {
                    iterator.remove();
                    continue;
                }
                entry.setValue(entry.getIntValue() - 1);
            }
        }
    }
}

