/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.data.storage;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.capture.component.ICaptureComponent;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.data.ExposureSize;
import io.github.mortuusars.exposure.data.storage.ExposureExporter;
import io.github.mortuusars.exposure.render.modifiers.ExposurePixelModifiers;
import io.github.mortuusars.exposure.render.modifiers.IPixelModifier;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Date;
import net.minecraft.class_1011;
import net.minecraft.class_2487;
import net.minecraft.class_3620;
import net.minecraft.class_5253;
import org.jetbrains.annotations.NotNull;

public class ClientsideExposureExporter
extends ExposureExporter<ClientsideExposureExporter>
implements ICaptureComponent {
    public ClientsideExposureExporter(String name) {
        super(name);
    }

    @Override
    public boolean save(byte[] mapColorPixels, int width, int height, class_2487 properties) {
        boolean bl;
        block8: {
            class_1011 image = this.convertToNativeImage(mapColorPixels, width, height, properties);
            try {
                bl = this.save(image, properties);
                if (image == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (image != null) {
                        try {
                            image.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Exposure.LOGGER.error("Cannot convert exposure pixels to NativeImage: {}", (Object)e.toString());
                    return false;
                }
            }
            image.close();
        }
        return bl;
    }

    public boolean save(class_1011 image, class_2487 properties) {
        try {
            String filepath = this.getFolder() + "/" + (String)(this.getWorldSubfolder() != null ? this.getWorldSubfolder() + "/" : "") + this.getName() + ".png";
            File outputFile = new File(filepath);
            boolean ignored = outputFile.getParentFile().mkdirs();
            image.method_4325(outputFile);
            if (properties.method_10573("Timestamp", 4)) {
                long unixSeconds = properties.method_10537("Timestamp");
                this.trySetFileCreationDate(outputFile.getAbsolutePath(), unixSeconds);
            }
            Exposure.LOGGER.info("Exposure saved: {}", (Object)outputFile);
            return true;
        }
        catch (IOException e) {
            Exposure.LOGGER.error("Failed to save exposure to file: {}", (Object)e.toString());
            return false;
        }
    }

    @Override
    protected void trySetFileCreationDate(String filePath, long creationTimeUnixSeconds) {
        try {
            Date creationDate = Date.from(Instant.ofEpochSecond(creationTimeUnixSeconds));
            BasicFileAttributeView attributes = Files.getFileAttributeView(Paths.get(filePath, new String[0]), BasicFileAttributeView.class, new LinkOption[0]);
            FileTime creationTime = FileTime.fromMillis(creationDate.getTime());
            FileTime modifyTime = FileTime.fromMillis(System.currentTimeMillis());
            attributes.setTimes(modifyTime, modifyTime, creationTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    protected class_1011 convertToNativeImage(byte[] MapColorPixels, int width, int height, class_2487 properties) {
        class_1011 image = new class_1011(width, height, false);
        IPixelModifier modifier = this.getModifier();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                FilmType filmType;
                int ABGR = class_3620.method_38480((int)MapColorPixels[x + y * width]);
                ABGR = modifier.modifyPixel(ABGR);
                if (modifier == ExposurePixelModifiers.NEGATIVE_FILM && (filmType = FilmType.byName(properties.method_10558("Type"))) != null) {
                    int a = class_5253.class_8045.method_48342((int)ABGR);
                    int b = class_5253.class_8045.method_48347((int)ABGR);
                    int g = class_5253.class_8045.method_48346((int)ABGR);
                    int r = class_5253.class_8045.method_48345((int)ABGR);
                    b = b * filmType.frameB / 255;
                    g = g * filmType.frameG / 255;
                    r = r * filmType.frameR / 255;
                    ABGR = class_5253.class_8045.method_48344((int)a, (int)b, (int)g, (int)r);
                }
                image.method_4305(x, y, ABGR);
            }
        }
        if (this.getSize() != ExposureSize.X1) {
            int resultWidth = image.method_4307() * this.getSize().getMultiplier();
            int resultHeight = image.method_4323() * this.getSize().getMultiplier();
            class_1011 resized = this.resize(image, 0, 0, image.method_4307(), image.method_4323(), resultWidth, resultHeight);
            image.close();
            image = resized;
        }
        return image;
    }

    protected class_1011 resize(class_1011 source, int sourceX, int sourceY, int sourceWidth, int sourceHeight, int resultWidth, int resultHeight) {
        class_1011 result = new class_1011(source.method_4318(), resultWidth, resultHeight, false);
        for (int x = 0; x < resultWidth; ++x) {
            float ratioX = (float)x / (float)resultWidth;
            int sourcePosX = (int)((float)sourceX + (float)sourceWidth * ratioX);
            for (int y = 0; y < resultHeight; ++y) {
                float ratioY = (float)y / (float)resultHeight;
                int sourcePosY = (int)((float)sourceY + (float)sourceHeight * ratioY);
                int color = source.method_4315(sourcePosX, sourcePosY);
                result.method_4305(x, y, color);
            }
        }
        return result;
    }
}

