/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.data.storage;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.data.ExposureSize;
import io.github.mortuusars.exposure.data.storage.ExposureExporter;
import io.github.mortuusars.exposure.render.modifiers.ExposurePixelModifiers;
import io.github.mortuusars.exposure.render.modifiers.IPixelModifier;
import io.github.mortuusars.exposure.util.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.class_2487;
import net.minecraft.class_3620;
import net.minecraft.class_5253;
import org.jetbrains.annotations.NotNull;

public class ServersideExposureExporter
extends ExposureExporter<ServersideExposureExporter> {
    public ServersideExposureExporter(String name) {
        super(name);
    }

    @Override
    public boolean save(byte[] mapColorPixels, int width, int height, class_2487 properties) {
        try {
            BufferedImage image = this.convertToBufferedImage(mapColorPixels, width, height, properties);
            return this.save(image, properties);
        }
        catch (Exception e) {
            Exposure.LOGGER.error("Failed to save exposure: {}", (Object)e.toString());
            return false;
        }
    }

    public boolean save(BufferedImage image, class_2487 properties) {
        try {
            String filepath = this.getFolder() + "/" + (String)(this.getWorldSubfolder() != null ? this.getWorldSubfolder() + "/" : "") + this.getName() + ".png";
            File outputFile = new File(filepath);
            boolean ignored = outputFile.getParentFile().mkdirs();
            if (!ImageIO.write((RenderedImage)image, "png", outputFile)) {
                Exposure.LOGGER.error("Exposure was not saved. No appropriate writer has been found.");
                return false;
            }
            if (properties.method_10573("Timestamp", 4)) {
                long unixSeconds = properties.method_10537("Timestamp");
                this.trySetFileCreationDate(outputFile.getAbsolutePath(), unixSeconds);
            }
            Exposure.LOGGER.info("Exposure saved: {}", (Object)outputFile);
            return true;
        }
        catch (IOException e) {
            Exposure.LOGGER.error("Failed to save exposure to file: {}", (Object)e.toString());
            return false;
        }
    }

    @NotNull
    protected BufferedImage convertToBufferedImage(byte[] MapColorPixels, int width, int height, class_2487 properties) {
        BufferedImage image = new BufferedImage(width, height, 2);
        IPixelModifier modifier = this.getModifier();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                FilmType filmType;
                int ABGR = class_3620.method_38480((int)MapColorPixels[x + y * width]);
                ABGR = modifier.modifyPixel(ABGR);
                if (modifier == ExposurePixelModifiers.NEGATIVE_FILM && (filmType = FilmType.byName(properties.method_10558("Type"))) != null) {
                    int a = class_5253.class_8045.method_48342((int)ABGR);
                    int b = class_5253.class_8045.method_48347((int)ABGR);
                    int g = class_5253.class_8045.method_48346((int)ABGR);
                    int r = class_5253.class_8045.method_48345((int)ABGR);
                    b = b * filmType.frameB / 255;
                    g = g * filmType.frameG / 255;
                    r = r * filmType.frameR / 255;
                    ABGR = class_5253.class_8045.method_48344((int)a, (int)b, (int)g, (int)r);
                }
                image.setRGB(x, y, Color.BGRtoRGB(ABGR));
            }
        }
        if (this.getSize() != ExposureSize.X1) {
            image = this.resize(image, this.getSize());
        }
        return image;
    }

    protected BufferedImage resize(BufferedImage sourceImage, ExposureSize size) {
        int targetWidth = sourceImage.getWidth() * size.getMultiplier();
        int targetHeight = sourceImage.getHeight() * size.getMultiplier();
        Image scaledInstance = sourceImage.getScaledInstance(targetWidth, targetHeight, 2);
        BufferedImage outputImg = new BufferedImage(targetWidth, targetHeight, 2);
        outputImg.getGraphics().drawImage(scaledInstance, 0, 0, null);
        return outputImg;
    }
}

