/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen.camera.button;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.Camera;
import io.github.mortuusars.exposure.camera.CameraClient;
import io.github.mortuusars.exposure.camera.infrastructure.ShutterSpeed;
import io.github.mortuusars.exposure.gui.screen.camera.button.CycleButton;
import io.github.mortuusars.exposure.item.CameraItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public class ShutterSpeedButton
extends CycleButton {
    private final List<ShutterSpeed> shutterSpeeds;
    private final int secondaryFontColor;
    private final int mainFontColor;

    public ShutterSpeedButton(class_437 screen, int x, int y, int width, int height, int u, int v, class_2960 texture) {
        super(screen, x, y, width, height, u, v, height, texture);
        Camera<?> camera = CameraClient.getCamera().orElseThrow();
        ArrayList<ShutterSpeed> speeds = new ArrayList<ShutterSpeed>(((CameraItem)((Object)camera.get().getItem())).getAllShutterSpeeds(camera.get().getStack()));
        Collections.reverse(speeds);
        this.shutterSpeeds = speeds;
        ShutterSpeed shutterSpeed = ((CameraItem)((Object)camera.get().getItem())).getShutterSpeed(camera.get().getStack());
        if (!this.shutterSpeeds.contains(shutterSpeed)) {
            throw new IllegalStateException("Camera {" + String.valueOf(camera.get().getStack()) + "} has invalid shutter speed.");
        }
        int currentShutterSpeedIndex = 0;
        for (int i = 0; i < this.shutterSpeeds.size(); ++i) {
            if (!shutterSpeed.equals(this.shutterSpeeds.get(i))) continue;
            currentShutterSpeedIndex = i;
        }
        this.setupButtonElements(this.shutterSpeeds.size(), currentShutterSpeedIndex);
        this.secondaryFontColor = Config.Client.getSecondaryFontColor();
        this.mainFontColor = Config.Client.getMainFontColor();
    }

    public void method_25354(class_1144 handler) {
        handler.method_4873((class_1113)class_1109.method_4757((class_3414)Exposure.SoundEvents.CAMERA_DIAL_CLICK.get(), (float)(Objects.requireNonNull(class_310.method_1551().field_1687).field_9229.method_43057() * 0.05f + 0.9f + (float)this.currentIndex * 0.01f), (float)0.7f));
    }

    @Override
    public void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
        ShutterSpeed shutterSpeed = this.shutterSpeeds.get(this.currentIndex);
        Object text = shutterSpeed.toString();
        if (shutterSpeed.equals(ShutterSpeed.DEFAULT)) {
            text = (String)text + "\u2022";
        }
        class_327 font = class_310.method_1551().field_1772;
        int textWidth = font.method_1727((String)text);
        int xPos = 35 - textWidth / 2;
        guiGraphics.method_51433(font, (String)text, this.method_46426() + xPos, this.method_46427() + 4, this.secondaryFontColor, false);
        guiGraphics.method_51433(font, (String)text, this.method_46426() + xPos, this.method_46427() + 3, this.mainFontColor, false);
    }

    @Override
    public void renderToolTip(@NotNull class_332 guiGraphics, int mouseX, int mouseY) {
        guiGraphics.method_51438(class_310.method_1551().field_1772, (class_2561)class_2561.method_43471((String)"gui.exposure.viewfinder.shutter_speed.tooltip"), mouseX, mouseY);
    }

    @Override
    protected void onCycle() {
        CameraClient.setShutterSpeed(this.shutterSpeeds.get(this.currentIndex));
    }
}

