/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client;

import java.io.IOException;
import me.jellysquid.mods.sodium.client.data.fingerprint.FingerprintMeasure;
import me.jellysquid.mods.sodium.client.data.fingerprint.HashedFingerprint;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.gui.console.Console;
import me.jellysquid.mods.sodium.client.gui.console.message.MessageLevel;
import me.jellysquid.mods.sodium.client.util.FlawlessFrames;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2561;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SodiumClientMod
implements ClientModInitializer {
    private static SodiumGameOptions CONFIG;
    private static Logger LOGGER;
    private static String MOD_VERSION;

    public void onInitializeClient() {
        ModContainer mod = (ModContainer)FabricLoader.getInstance().getModContainer("sodium").orElseThrow(NullPointerException::new);
        MOD_VERSION = mod.getMetadata().getVersion().getFriendlyString();
        LOGGER = LoggerFactory.getLogger((String)"Sodium");
        CONFIG = SodiumClientMod.loadConfig();
        FlawlessFrames.onClientInitialization();
        try {
            SodiumClientMod.updateFingerprint();
        }
        catch (Throwable t) {
            LOGGER.error("Failed to update fingerprint", t);
        }
    }

    public static SodiumGameOptions options() {
        if (CONFIG == null) {
            throw new IllegalStateException("Config not yet available");
        }
        return CONFIG;
    }

    public static Logger logger() {
        if (LOGGER == null) {
            throw new IllegalStateException("Logger not yet available");
        }
        return LOGGER;
    }

    private static SodiumGameOptions loadConfig() {
        try {
            return SodiumGameOptions.loadFromDisk();
        }
        catch (Exception e) {
            LOGGER.error("Failed to load configuration file", (Throwable)e);
            LOGGER.error("Using default configuration file in read-only mode");
            Console.instance().logMessage(MessageLevel.SEVERE, (class_2561)class_2561.method_43471((String)"sodium.console.config_not_loaded"), 12.5);
            SodiumGameOptions config = SodiumGameOptions.defaults();
            config.setReadOnly();
            return config;
        }
    }

    public static void restoreDefaultOptions() {
        CONFIG = SodiumGameOptions.defaults();
        try {
            SodiumGameOptions.writeToDisk(CONFIG);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write config file", e);
        }
    }

    public static String getVersion() {
        if (MOD_VERSION == null) {
            throw new NullPointerException("Mod version hasn't been populated yet");
        }
        return MOD_VERSION;
    }

    private static void updateFingerprint() {
        FingerprintMeasure current = FingerprintMeasure.create();
        if (current == null) {
            return;
        }
        HashedFingerprint saved = null;
        try {
            saved = HashedFingerprint.loadFromDisk();
        }
        catch (Throwable t) {
            LOGGER.error("Failed to load existing fingerprint", t);
        }
        if (saved == null || !current.looselyMatches(saved)) {
            HashedFingerprint.writeToDisk(current.hashed());
            SodiumClientMod.CONFIG.notifications.hasSeenDonationPrompt = false;
            SodiumClientMod.CONFIG.notifications.hasClearedDonationButton = false;
            try {
                SodiumGameOptions.writeToDisk(CONFIG);
            }
            catch (IOException e) {
                LOGGER.error("Failed to update config file", (Throwable)e);
            }
        }
    }
}

