/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.integration.vanish;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import java.util.function.BiConsumer;
import me.drex.vanish.api.VanishAPI;
import me.drex.vanish.api.VanishEvents;
import net.minecraft.class_3222;

public class VanishIntegration {
    private static Boolean loaded;

    public static boolean isLoaded() {
        if (loaded == null) {
            loaded = VanishIntegration.checkLoaded();
        }
        return loaded;
    }

    private static boolean checkLoaded() {
        if (CommonCompatibilityManager.INSTANCE.isModLoaded("melius-vanish") || CommonCompatibilityManager.INSTANCE.isModLoaded("vanish")) {
            try {
                Class.forName("me.drex.vanish.api.VanishAPI");
                Voicechat.LOGGER.info("Enabling vanish compatibility", new Object[0]);
                return true;
            }
            catch (Throwable t) {
                Voicechat.LOGGER.warn("Failed to load vanish compatibility", t);
            }
        }
        return false;
    }

    public static void init() {
        if (!VanishIntegration.isLoaded()) {
            return;
        }
        try {
            VanishEvents.VANISH_EVENT.register((vanishPlayer, vanish) -> {
                for (class_3222 player : vanishPlayer.method_5682().method_3760().method_14571()) {
                    if (vanish) {
                        if (CommonCompatibilityManager.INSTANCE.canSee(player, vanishPlayer)) continue;
                        ((BiConsumer)de.maxhenkel.voicechat.events.VanishEvents.ON_VANISH.invoker()).accept(vanishPlayer, player);
                        continue;
                    }
                    if (!CommonCompatibilityManager.INSTANCE.canSee(player, vanishPlayer)) continue;
                    ((BiConsumer)de.maxhenkel.voicechat.events.VanishEvents.ON_UNVANISH.invoker()).accept(vanishPlayer, player);
                }
            });
        }
        catch (Throwable t) {
            Voicechat.LOGGER.warn("Failed to use vanish compatibility", t);
            loaded = false;
        }
    }

    public static boolean canSee(class_3222 player, class_3222 other) {
        if (VanishIntegration.isLoaded()) {
            try {
                return VanishAPI.canSeePlayer((class_3222)other, (class_3222)player);
            }
            catch (Throwable t) {
                Voicechat.LOGGER.warn("Failed to use vanish compatibility", t);
                loaded = false;
            }
        }
        return true;
    }
}

