/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set.leaves;

import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.leaves.VanillaLeavesTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.class_2248;
import net.minecraft.class_2397;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class LeavesTypeRegistry
extends BlockTypeRegistry<LeavesType> {
    public static final LeavesTypeRegistry INSTANCE = new LeavesTypeRegistry();
    @Deprecated(forRemoval=true)
    public static LeavesType OAK_TYPE = VanillaLeavesTypes.OAK;
    private final Map<class_2960, class_2960> specialLeavesToWood = new HashMap<class_2960, class_2960>();
    private final Map<LeavesType, WoodType> leavesToWood = new IdentityHashMap<LeavesType, WoodType>();

    @Deprecated(forRemoval=true)
    public static Collection<LeavesType> getTypes() {
        return INSTANCE.getValues();
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static LeavesType getValue(class_2960 leavesTypeId) {
        return (LeavesType)INSTANCE.get(leavesTypeId);
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static LeavesType getValue(String leavesTypeId) {
        return (LeavesType)INSTANCE.get(new class_2960(leavesTypeId));
    }

    @Deprecated(forRemoval=true)
    public static LeavesType fromNBT(String name) {
        return (LeavesType)INSTANCE.getFromNBT(name);
    }

    public LeavesTypeRegistry() {
        super(LeavesType.class, "leaves_type");
    }

    @Override
    protected LeavesType register(LeavesType vanillaType) {
        return super.register(vanillaType);
    }

    @Override
    public LeavesType getDefaultType() {
        return VanillaLeavesTypes.OAK;
    }

    @Nullable
    public WoodType getEquivalentWoodType(LeavesType leavesType) {
        return this.leavesToWood.get(leavesType);
    }

    @Override
    public Optional<LeavesType> detectTypeFromBlock(class_2248 baseBlock, class_2960 blockId) {
        class_2960 id;
        String name = null;
        String path = blockId.method_12832();
        if (path.endsWith("_leaves")) {
            name = path.substring(0, path.length() - "_leaves".length());
        } else if (path.startsWith("leaves_")) {
            name = path.substring("leaves_".length());
        }
        String namespace = blockId.method_12836();
        if (name != null && !LeavesTypeRegistry.isBlacklisted(namespace, path) && baseBlock instanceof class_2397 && !this.valuesReg.containsKey(id = new class_2960(namespace, name))) {
            return Optional.of(new LeavesType(id, baseBlock));
        }
        return Optional.empty();
    }

    private static boolean isBlacklisted(String namespace, String path) {
        return namespace.equals("securitycraft") || namespace.equals("dynamic_trees") || namespace.matches("dynamictrees|dt\\w+") || path.contains("hanging");
    }

    @Override
    public void finalizeAndFreeze() {
        super.finalizeAndFreeze();
        for (LeavesType l : this.getValues()) {
            class_2960 leavesId = l.id;
            class_2960 id = this.specialLeavesToWood.getOrDefault(leavesId, leavesId);
            WoodType woodType = (WoodType)WoodTypeRegistry.INSTANCE.get(id);
            String path = id.method_12832();
            String namespace = id.method_12836();
            if (woodType == null) {
                for (WoodType w : WoodTypeRegistry.INSTANCE.getValues()) {
                    if (!w.id.method_12832().equals(path)) continue;
                    woodType = w;
                    break;
                }
            }
            if (woodType == null) {
                for (WoodType w : WoodTypeRegistry.INSTANCE.getValues()) {
                    if (!w.isVanilla() && !w.id.method_12836().equals(namespace) || !path.endsWith(w.id.method_12832())) continue;
                    woodType = w;
                }
            }
            if (woodType == null) continue;
            this.leavesToWood.put(l, woodType);
            l.addChild("log", woodType.log);
        }
    }

    public void addLeavesToWoodMapping(class_2960 leavesTypeId, class_2960 woodTypeId) {
        this.specialLeavesToWood.put(leavesTypeId, woodTypeId);
    }

    public void addLeavesToWoodMapping(String leavedId, String woodId) {
        this.addLeavesToWoodMapping(new class_2960(leavedId), new class_2960(woodId));
    }

    public void addLeavesToWoodMapping(String modId, String leavesTypeName, String woodTypeName) {
        this.addLeavesToWoodMapping(new class_2960(modId, leavesTypeName), new class_2960(modId, woodTypeName));
    }

    @Override
    public int priority() {
        return 99;
    }

    public LeavesType.Finder addSimpleFinder(class_2960 typeId) {
        LeavesType.Finder finder = new LeavesType.Finder(typeId);
        this.addFinder(finder);
        return finder;
    }

    public LeavesType.Finder addSimpleFinder(String typeId) {
        return this.addSimpleFinder(new class_2960(typeId));
    }

    public LeavesType.Finder addSimpleFinder(String namespace, String name) {
        return this.addSimpleFinder(new class_2960(namespace, name));
    }
}

