/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedSourceBlock;
import com.jaquadro.minecraft.storagedrawers.block.BlockFramingTable;
import com.jaquadro.minecraft.storagedrawers.block.EnumFramingTablePart;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityFramingTable;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import net.minecraft.class_1087;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_918;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class BlockEntityFramingRenderer
implements class_827<BlockEntityFramingTable> {
    private final class_5614.class_5615 context;

    public BlockEntityFramingRenderer(class_5614.class_5615 context) {
        this.context = context;
    }

    public void render(@NotNull BlockEntityFramingTable blockEntityTable, float partialTickTime, @NotNull class_4587 matrix, @NotNull class_4597 buffer, int combinedLight, int combinedOverlay) {
        class_1747 blockItem;
        class_2248 targetBlock;
        class_1937 level = blockEntityTable.method_10997();
        if (level == null) {
            return;
        }
        class_2680 state = blockEntityTable.method_11010();
        if (!(state.method_26204() instanceof BlockFramingTable)) {
            return;
        }
        if (state.method_11654(BlockFramingTable.PART) != EnumFramingTablePart.RIGHT) {
            return;
        }
        MaterialData matData = blockEntityTable.material();
        if (matData == null) {
            return;
        }
        this.renderSlot(blockEntityTable, matData.getSide(), matrix, buffer, combinedLight, combinedOverlay, 1.0f, 1.15f, 0.15f, -0.275f);
        this.renderSlot(blockEntityTable, matData.getTrim(), matrix, buffer, combinedLight, combinedOverlay, 1.0f, -0.14999998f, 0.15f, -0.275f);
        this.renderSlot(blockEntityTable, matData.getFront(), matrix, buffer, combinedLight, combinedOverlay, 1.0f, 1.15f, 0.15f, -0.725f);
        if (matData.getEffectiveSide().method_7960()) {
            return;
        }
        class_1799 target = blockEntityTable.inventory().method_5438(0);
        if (target == null || target.method_7960()) {
            return;
        }
        class_1792 class_17922 = target.method_7909();
        if (class_17922 instanceof class_1747 && (targetBlock = (blockItem = (class_1747)class_17922).method_7711()) instanceof IFramedSourceBlock) {
            IFramedSourceBlock fsb = (IFramedSourceBlock)targetBlock;
            class_1799 result = fsb.makeFramedItem(target, matData.getEffectiveSide(), matData.getEffectiveTrim(), matData.getEffectiveFront());
            this.renderSlot(blockEntityTable, result, matrix, buffer, combinedLight, combinedOverlay, 1.6f, 0.5f, 0.1f, -0.5f);
        }
    }

    private void renderSlot(BlockEntityFramingTable blockEntityTable, class_1799 item, class_4587 matrix, @NotNull class_4597 buffer, int combinedLight, int combinedOverlay, float scale, float tx, float ty, float tz) {
        if (item == null) {
            return;
        }
        class_2248 itemBlock = class_2248.method_9503((class_1792)item.method_7909());
        if (itemBlock == class_2246.field_10124) {
            return;
        }
        class_2350 facing = (class_2350)blockEntityTable.method_11010().method_11654((class_2769)BlockFramingTable.field_11177);
        matrix.method_22903();
        switch (facing) {
            case field_11043: {
                matrix.method_34425(new Matrix4f().rotateY((float)Math.toRadians(180.0)));
                break;
            }
            case field_11034: {
                matrix.method_34425(new Matrix4f().rotateY((float)Math.toRadians(90.0)));
                break;
            }
            case field_11039: {
                matrix.method_34425(new Matrix4f().rotateY((float)Math.toRadians(270.0)));
                break;
            }
            case field_11035: {
                matrix.method_34425(new Matrix4f().rotateY((float)Math.toRadians(0.0)));
            }
        }
        switch (facing) {
            case field_11043: {
                matrix.method_46416(-0.5f, 0.8f, 0.0f);
                break;
            }
            case field_11034: {
                matrix.method_46416(-0.5f, 0.8f, 1.0f);
                break;
            }
            case field_11039: {
                matrix.method_46416(0.5f, 0.8f, 0.0f);
                break;
            }
            case field_11035: {
                matrix.method_46416(0.5f, 0.8f, 1.0f);
            }
        }
        matrix.method_46416(tx, ty, tz);
        matrix.method_34425(new Matrix4f().scale(scale, scale, scale));
        class_918 renderer = class_310.method_1551().method_1480();
        class_1087 model = renderer.method_4019(item, null, null, 0);
        try {
            renderer.method_23179(item, class_811.field_4318, false, matrix, buffer, combinedLight, combinedOverlay, model);
        }
        catch (Exception exception) {
            // empty catch block
        }
        matrix.method_22909();
    }
}

