/*
 * Decompiled with CFR 0.152.
 */
package com.texelsaurus.minecraft.chameleon.service;

import com.texelsaurus.minecraft.chameleon.ChameleonServices;
import com.texelsaurus.minecraft.chameleon.client.FabricClient;
import com.texelsaurus.minecraft.chameleon.network.ChameleonPacket;
import com.texelsaurus.minecraft.chameleon.network.ChameleonPacketHandler;
import com.texelsaurus.minecraft.chameleon.service.ChameleonNetworking;
import io.netty.buffer.Unpooled;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class FabricNetworking
implements ChameleonNetworking {
    @Override
    public <P extends ChameleonPacket<P>> void registerPacketInternal(class_2960 id, ChameleonPacketHandler<P> payloadType, boolean clientBound) {
        if (clientBound) {
            if (ChameleonServices.PLATFORM.isPhysicalClient()) {
                FabricClient.registerPacket(id, payloadType);
            }
        } else {
            ServerPlayNetworking.registerGlobalReceiver((class_2960)id, (server, player, handler, buf, responseSender) -> {
                Object decode = payloadType.decode(buf);
                payloadType.handle(decode, (class_1657)player, arg_0 -> ((MinecraftServer)server).execute(arg_0));
            });
        }
    }

    @Override
    public <P extends ChameleonPacket<P>> void sendToPlayer(P packet, class_3222 player) {
        ChameleonPacketHandler<P> type = packet.getHandler();
        class_2540 buf = new class_2540(Unpooled.buffer());
        type.encode(packet, buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)packet.getId(), (class_2540)buf);
    }

    @Override
    public <P extends ChameleonPacket<P>> void sendToPlayersNear(P packet, class_3218 level, double x, double y, double z, double radius) {
        for (class_3222 player : level.method_18456()) {
            class_2338 class_23382 = new class_2338((int)x, (int)y, (int)z);
            if (!(player.method_24515().method_10262((class_2382)class_23382) <= radius)) continue;
            this.sendToPlayer(packet, player);
        }
    }

    @Override
    public <P extends ChameleonPacket<P>> void sendToServer(P packet) {
        FabricClient.sendToServer(packet);
    }
}

