/*
 * Decompiled with CFR 0.152.
 */
package net.zlt.create_vibrant_vaults.block.entity;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryWrapper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.zlt.create_vibrant_vaults.block.AbstractItemVaultBlock;

public abstract class AbstractItemVaultBlockEntity<BE extends AbstractItemVaultBlockEntity<BE>>
extends SmartBlockEntity
implements IMultiBlockEntityContainer.Inventory,
SidedStorageBlockEntity {
    protected Storage<ItemVariant> itemCapability;
    public ItemStackHandler inventory;
    protected class_2338 controller;
    protected class_2338 lastKnownPos;
    protected boolean updateConnectivity;
    public int radius;
    public int length;
    protected class_2350.class_2351 axis;
    protected boolean recalculateComparatorsNextTick = false;

    public AbstractItemVaultBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.inventory = new ItemStackHandler((Integer)AllConfigs.server().logistics.vaultCapacity.get()){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                AbstractItemVaultBlockEntity.this.recalculateComparatorsNextTick = true;
            }
        };
        this.itemCapability = null;
        this.radius = 1;
        this.length = 1;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.field_11863 != null && !this.field_11863.method_8608() && this.isController()) {
            ConnectivityHandler.formMulti((class_2586)this);
        }
    }

    protected void updateComparators() {
        this.recalculateComparatorsNextTick = false;
        if (this.field_11863 == null) {
            return;
        }
        BE controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return;
        }
        this.field_11863.method_8524(((AbstractItemVaultBlockEntity)((Object)controllerBE)).field_11867);
        class_2338 pos = controllerBE.method_11016();
        for (int y = 0; y < ((AbstractItemVaultBlockEntity)((Object)controllerBE)).radius; ++y) {
            for (int z = 0; z < (((AbstractItemVaultBlockEntity)((Object)controllerBE)).axis == class_2350.class_2351.field_11048 ? ((AbstractItemVaultBlockEntity)((Object)controllerBE)).radius : ((AbstractItemVaultBlockEntity)((Object)controllerBE)).length); ++z) {
                for (int x = 0; x < (((AbstractItemVaultBlockEntity)((Object)controllerBE)).axis == class_2350.class_2351.field_11051 ? ((AbstractItemVaultBlockEntity)((Object)controllerBE)).radius : ((AbstractItemVaultBlockEntity)((Object)controllerBE)).length); ++x) {
                    this.field_11863.method_8455(pos.method_10069(x, y, z), this.method_11010().method_26204());
                }
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.method_11016();
        } else if (!this.lastKnownPos.equals((Object)this.field_11867)) {
            this.onPositionChanged();
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        if (this.recalculateComparatorsNextTick) {
            this.updateComparators();
        }
    }

    public class_2338 getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.field_11867.method_10263() == this.controller.method_10263() && this.field_11867.method_10264() == this.controller.method_10264() && this.field_11867.method_10260() == this.controller.method_10260();
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.field_11867;
    }

    protected abstract BE getAsBE(class_2586 var1);

    public BE getControllerBE() {
        if (this.isController()) {
            return (BE)((Object)this);
        }
        if (this.field_11863 == null) {
            return null;
        }
        return this.getAsBE(this.field_11863.method_8321(this.controller));
    }

    protected abstract boolean isVault(class_2680 var1);

    public void removeController(boolean keepContents) {
        if (this.field_11863 == null || this.field_11863.method_8608()) {
            return;
        }
        this.updateConnectivity = true;
        this.controller = null;
        this.radius = 1;
        this.length = 1;
        class_2680 state = this.method_11010();
        if (this.isVault(state)) {
            state = (class_2680)state.method_11657((class_2769)AbstractItemVaultBlock.LARGE, (Comparable)Boolean.valueOf(false));
            this.field_11863.method_8652(this.field_11867, state, 22);
        }
        this.itemCapability = null;
        this.method_5431();
        this.sendData();
    }

    public void setController(class_2338 controller) {
        if (this.field_11863 == null || this.field_11863.field_9236 && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.itemCapability = null;
        this.method_5431();
        this.sendData();
    }

    public class_2338 getController() {
        return this.isController() ? this.field_11867 : this.controller;
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, clientPacket);
        class_2338 controllerBefore = this.controller;
        int prevSize = this.radius;
        int prevLength = this.length;
        this.updateConnectivity = compound.method_10545("Uninitialized");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.method_10545("LastKnownPos")) {
            this.lastKnownPos = class_2512.method_10691((class_2487)compound.method_10562("LastKnownPos"));
        }
        if (compound.method_10545("Controller")) {
            this.controller = class_2512.method_10691((class_2487)compound.method_10562("Controller"));
        }
        if (this.isController()) {
            this.radius = compound.method_10550("Size");
            this.length = compound.method_10550("Length");
        }
        if (!clientPacket) {
            this.inventory.deserializeNBT(compound.method_10562("Inventory"));
            return;
        }
        boolean bl = controllerBefore == null ? this.controller != null : (changeOfController = !controllerBefore.equals((Object)this.controller));
        if (this.field_11863 != null && (changeOfController || prevSize != this.radius || prevLength != this.length)) {
            this.field_11863.method_16109(this.method_11016(), class_2246.field_10124.method_9564(), this.method_11010());
        }
    }

    protected void write(class_2487 compound, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.method_10556("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.method_10566("LastKnownPos", (class_2520)class_2512.method_10692((class_2338)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.method_10566("Controller", (class_2520)class_2512.method_10692((class_2338)this.controller));
        }
        if (this.isController()) {
            compound.method_10569("Size", this.radius);
            compound.method_10569("Length", this.length);
        }
        super.write(compound, clientPacket);
        if (!clientPacket) {
            compound.method_10582("StorageType", "CombinedInv");
            compound.method_10566("Inventory", (class_2520)this.inventory.serializeNBT());
        }
    }

    public ItemStackHandler getInventoryOfBlock() {
        return this.inventory;
    }

    public void applyInventoryToBlock(ItemStackHandler handler) {
        for (int i = 0; i < this.inventory.getSlotCount(); ++i) {
            this.inventory.setStackInSlot(i, i < handler.getSlotCount() ? handler.getStackInSlot(i) : class_1799.field_8037);
        }
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 face) {
        this.initCapability();
        return this.itemCapability;
    }

    protected abstract class_2350.class_2351 getVaultBlockAxis(class_2680 var1);

    protected abstract class_2591<BE> getBlockEntityType();

    protected void initCapability() {
        VersionedInventoryWrapper combinedInvWrapper;
        if (this.itemCapability != null) {
            return;
        }
        if (!this.isController()) {
            BE controllerBE = this.getControllerBE();
            if (controllerBE == null) {
                return;
            }
            ((AbstractItemVaultBlockEntity)((Object)controllerBE)).initCapability();
            this.itemCapability = ((AbstractItemVaultBlockEntity)((Object)controllerBE)).itemCapability;
            return;
        }
        if (this.field_11863 == null) {
            return;
        }
        boolean alongZ = this.getVaultBlockAxis(this.method_11010()) == class_2350.class_2351.field_11051;
        ItemStackHandler[] invs = new ItemStackHandler[this.length * this.radius * this.radius];
        for (int yOffset = 0; yOffset < this.length; ++yOffset) {
            for (int xOffset = 0; xOffset < this.radius; ++xOffset) {
                for (int zOffset = 0; zOffset < this.radius; ++zOffset) {
                    AbstractItemVaultBlockEntity vaultAt = (AbstractItemVaultBlockEntity)ConnectivityHandler.partAt(this.getBlockEntityType(), (class_1922)this.field_11863, (class_2338)(alongZ ? this.field_11867.method_10069(xOffset, zOffset, yOffset) : this.field_11867.method_10069(yOffset, xOffset, zOffset)));
                    invs[yOffset * this.radius * this.radius + xOffset * this.radius + zOffset] = vaultAt != null ? vaultAt.inventory : new ItemStackHandler();
                }
            }
        }
        this.itemCapability = combinedInvWrapper = new VersionedInventoryWrapper((Storage)new CombinedStorage(List.of(invs)));
    }

    public static int getMaxLength(int radius) {
        return radius * 3;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void queueConnectivityUpdate() {
        this.updateConnectivity = true;
    }

    public void notifyMultiUpdated() {
        class_2680 state = this.method_11010();
        if (this.field_11863 != null && this.isVault(state)) {
            this.field_11863.method_8652(this.method_11016(), (class_2680)state.method_11657((class_2769)AbstractItemVaultBlock.LARGE, (Comparable)Boolean.valueOf(this.radius > 2)), 6);
        }
        this.itemCapability = null;
        this.method_5431();
    }

    public class_2350.class_2351 getMainConnectionAxis() {
        return this.getMainAxisOf((class_2586)this);
    }

    public int getMaxLength(class_2350.class_2351 longAxis, int width) {
        return longAxis == class_2350.class_2351.field_11052 ? this.getMaxWidth() : AbstractItemVaultBlockEntity.getMaxLength(width);
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.length;
    }

    public int getWidth() {
        return this.radius;
    }

    public void setHeight(int height) {
        this.length = height;
    }

    public void setWidth(int width) {
        this.radius = width;
    }

    public boolean hasInventory() {
        return true;
    }
}

