/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.items;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.ordana.spelunkery.configs.ClientConfigs;
import com.ordana.spelunkery.configs.CommonConfigs;
import com.ordana.spelunkery.reg.ModGameEvents;
import com.ordana.spelunkery.utils.TranslationUtils;
import dev.architectury.injectables.annotations.PlatformOnly;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.item.IFirstPersonAnimationProvider;
import net.mehvahdjukaar.moonlight.api.item.IThirdPersonAnimationProvider;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_4208;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import net.minecraft.class_572;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AmethystTuningForkItem
extends class_1792
implements IFirstPersonAnimationProvider,
IThirdPersonAnimationProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String TAG_LODESTONE_POS = "LodestonePos";
    public static final String TAG_LODESTONE_DIMENSION = "LodestoneDimension";
    public static final String TAG_LODESTONE_TRACKED = "LodestoneTracked";
    public static boolean tolling;
    private int tickCounter = 0;
    private final CompassWobble wobble = new CompassWobble();

    public AmethystTuningForkItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 level, @NotNull List<class_2561> tooltip, @NotNull class_1836 context) {
        if (ClientConfigs.ENABLE_TOOLTIPS.get().booleanValue()) {
            if (class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)class_310.method_1551().field_1690.field_1832.field_1655.method_1444())) {
                tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.spelunkery.tuning_fork_1", (Object[])new Object[]{this.getTollRange()}).method_10862(class_2583.field_24360.method_27706(class_124.field_1080)));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.spelunkery.tuning_fork_2").method_10862(class_2583.field_24360.method_27706(class_124.field_1080)));
            } else {
                tooltip.add((class_2561)TranslationUtils.CROUCH.component());
            }
        }
    }

    public class_1271<class_1799> method_7836(@NotNull class_1937 level, @NotNull class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        class_2487 compoundTag = stack.method_7948();
        boolean hasTag = compoundTag.method_10545("amethystPos");
        if (level.method_27983() != class_1937.field_25179) {
            return new class_1271(class_1269.field_5811, (Object)stack);
        }
        if (player.method_21823()) {
            if (hasTag) {
                compoundTag.method_10551("amethystPos");
                compoundTag.method_10551("amethystDimension");
            }
            tolling = false;
        } else if (!hasTag) {
            level.method_33596((class_1297)player, ModGameEvents.FORK_TONE_EVENT.get(), player.method_24515());
            player.method_7357().method_7906((class_1792)this, 20);
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            class_174.field_33872.method_37262(serverPlayer, stack);
        }
        return new class_1271(class_1269.field_5812, (Object)stack);
    }

    public int getTollRange() {
        return CommonConfigs.TUNING_FORK_RANGE.get();
    }

    public void setPlayerX(class_1799 stack, int amount) {
        stack.method_7948().method_10569("ex", amount);
    }

    public int getPlayerX(class_1799 stack) {
        return stack.method_7948().method_10550("ex");
    }

    public void setPlayerZ(class_1799 stack, int amount) {
        stack.method_7948().method_10569("zed", amount);
    }

    public int getPlayerZ(class_1799 stack) {
        return stack.method_7948().method_10550("zed");
    }

    @PlatformOnly(value={"fabric"})
    public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 originalStack, class_1799 updatedStack) {
        return false;
    }

    private static Optional<class_5321<class_1937>> getDimension(class_2487 compoundTag) {
        return class_1937.field_25178.parse((DynamicOps)class_2509.field_11560, (Object)compoundTag.method_10580("amethystDimension")).result();
    }

    public int setTickCounter(int tick) {
        this.tickCounter = tick;
        return this.tickCounter;
    }

    public static void addAmethystTags(class_5321<class_1937> lodestoneDimension, class_2338 pos, class_2487 compoundTag) {
        if (!compoundTag.method_10545("amethystPos")) {
            compoundTag.method_10566("amethystPos", (class_2520)class_2512.method_10692((class_2338)pos));
        }
        tolling = true;
        DataResult var10000 = class_1937.field_25178.encodeStart((DynamicOps)class_2509.field_11560, lodestoneDimension);
        Logger var10001 = LOGGER;
        Objects.requireNonNull(var10001);
        var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0)).ifPresent(tag -> compoundTag.method_10566("amethystDimension", tag));
    }

    public static boolean isAmethystNearby(class_1799 stack) {
        class_2487 compoundTag = stack.method_7969();
        return compoundTag != null && compoundTag.method_10545("amethystPos");
    }

    public static double distanceToAmethyst(class_2382 playerPos, class_2338 amethystPos) {
        return amethystPos.method_10262(playerPos);
    }

    @Nullable
    public static class_4208 getAmethystPos(class_2487 compoundTag) {
        Optional<class_5321<class_1937>> optional;
        boolean bl = compoundTag.method_10545("amethystPos");
        boolean bl2 = compoundTag.method_10545("amethystDimension");
        if (bl && bl2 && (optional = AmethystTuningForkItem.getDimension(compoundTag)).isPresent()) {
            class_2338 blockPos = class_2512.method_10691((class_2487)compoundTag.method_10562("amethystPos"));
            return class_4208.method_19443(optional.get(), (class_2338)blockPos);
        }
        return null;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8952;
    }

    public <T extends class_1309> boolean poseLeftArm(class_1799 itemStack, class_572<T> model, T entity, class_1306 humanoidArm) {
        if (entity.method_6014() > 0 && entity.method_6030().method_7909() == this && entity.method_6048() < 50) {
            model.field_27433.field_3675 = MthUtils.wrapRad((float)(0.1f + model.field_3398.field_3675));
            model.field_27433.field_3654 = MthUtils.wrapRad((float)(-1.5707964f + model.field_3398.field_3654));
            return true;
        }
        return false;
    }

    public <T extends class_1309> boolean poseRightArm(class_1799 itemStack, class_572<T> model, T entity, class_1306 humanoidArm) {
        if (entity.method_6014() > 0 && entity.method_6030().method_7909() == this && entity.method_6048() < 50) {
            model.field_3401.field_3675 = MthUtils.wrapRad((float)(-0.1f + model.field_3398.field_3675));
            model.field_3401.field_3654 = MthUtils.wrapRad((float)(-1.5707964f + model.field_3398.field_3654));
            return true;
        }
        return false;
    }

    public void animateItemFirstPerson(class_1309 entity, class_1799 stack, class_1268 hand, class_4587 poseStack, float partialTicks, float pitch, float attackAnim, float handHeight) {
        class_1937 class_19372;
        if (tolling && entity.method_6058() == hand && (class_19372 = entity.method_37908()) instanceof class_638) {
            class_638 level = (class_638)class_19372;
            class_2338 blockPos = class_2512.method_10691((class_2487)stack.method_7948().method_10562("amethystPos"));
            long time = level.method_8510();
            float value = (float)Math.cos((float)time + partialTicks) * 100.0f;
            float modifier = this.getModifierAngle((class_1297)entity, time, blockPos) * 360.0f;
            double distance = StrictMath.cbrt(AmethystTuningForkItem.distanceToAmethyst((class_2382)entity.method_24515(), blockPos));
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(-80.0f));
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(0.0f));
            poseStack.method_22907(class_7833.field_40714.rotationDegrees((float)((double)value / distance) + modifier));
        }
    }

    public float getModifierAngle(class_1297 entity, long l, class_2338 blockPos) {
        double d = this.getAngleFromEntityToPos(entity, blockPos);
        double e = this.getWrappedVisualRotationY(entity);
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (this.wobble.shouldUpdate(l)) {
                this.wobble.update(l, 0.5 - (e - 0.25));
            }
            double f = d + this.wobble.rotation;
            return class_3532.method_15341((float)((float)f), (float)1.0f);
        }
        double f = 0.5 - (e - 0.25 - d);
        return class_3532.method_15341((float)((float)f), (float)1.0f);
    }

    private float getAngleFromEntityToPos(class_1297 entity, class_2338 blockPos) {
        class_243 vec3 = class_243.method_24953((class_2382)blockPos);
        return (float)Math.atan2(vec3.method_10215() - entity.method_23321(), vec3.method_10216() - entity.method_23317()) / ((float)Math.PI * 2);
    }

    private double getWrappedVisualRotationY(class_1297 entity) {
        return class_3532.method_15367((double)(entity.method_43078() / 360.0f), (double)1.0);
    }

    static class CompassWobble {
        double rotation;
        private double deltaRotation;
        private long lastUpdateTick;

        CompassWobble() {
        }

        boolean shouldUpdate(long l) {
            return this.lastUpdateTick != l;
        }

        void update(long l, double d) {
            this.lastUpdateTick = l;
            double e = d - this.rotation;
            e = class_3532.method_15367((double)(e + 0.5), (double)1.0) - 0.5;
            this.deltaRotation += e * 0.1;
            this.deltaRotation *= 0.8;
            this.rotation = class_3532.method_15367((double)(this.rotation + this.deltaRotation), (double)1.0);
        }
    }
}

