/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.stats;

import aztech.modern_industrialization.compat.ftbquests.FTBQuestsFacade;
import aztech.modern_industrialization.compat.ftbteams.FTBTeamsFacade;
import aztech.modern_industrialization.proxy.CommonProxy;
import aztech.modern_industrialization.stats.PlayerStatisticsData;
import aztech.modern_industrialization.stats.StatisticValue;
import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class PlayerStatistics {
    public static final PlayerStatistics DUMMY = new PlayerStatistics(null, null);
    private final PlayerStatisticsData data;
    @Nullable
    private final UUID uuid;
    private final Map<class_1792, StatisticValue> usedItems = new IdentityHashMap<class_1792, StatisticValue>();
    private final Map<class_1792, StatisticValue> producedItems = new IdentityHashMap<class_1792, StatisticValue>();
    private final Map<class_3611, StatisticValue> usedFluids = new IdentityHashMap<class_3611, StatisticValue>();
    private final Map<class_3611, StatisticValue> producedFluids = new IdentityHashMap<class_3611, StatisticValue>();
    private final Reference2LongMap<class_1792> pendingCraftedStats = new Reference2LongOpenHashMap();

    PlayerStatistics(PlayerStatisticsData data, UUID uuid) {
        this.data = data;
        this.uuid = uuid;
    }

    PlayerStatistics(PlayerStatisticsData data, UUID uuid, class_2487 nbt) {
        this(data, uuid);
        PlayerStatistics.readNbt(class_7923.field_41178, this.usedItems, nbt.method_10562("usedItems"));
        PlayerStatistics.readNbt(class_7923.field_41178, this.producedItems, nbt.method_10562("producedItems"));
        PlayerStatistics.readNbt(class_7923.field_41173, this.usedFluids, nbt.method_10562("usedFluids"));
        PlayerStatistics.readNbt(class_7923.field_41173, this.producedFluids, nbt.method_10562("producedFluids"));
        PlayerStatistics.pendingReadNbt(this.pendingCraftedStats, nbt.method_10562("pendingCraftedStats"));
    }

    public class_2487 toTag() {
        class_2487 nbt = new class_2487();
        nbt.method_10566("usedItems", (class_2520)PlayerStatistics.toNbt(class_7923.field_41178, this.usedItems));
        nbt.method_10566("producedItems", (class_2520)PlayerStatistics.toNbt(class_7923.field_41178, this.producedItems));
        nbt.method_10566("usedFluids", (class_2520)PlayerStatistics.toNbt(class_7923.field_41173, this.usedFluids));
        nbt.method_10566("producedFluids", (class_2520)PlayerStatistics.toNbt(class_7923.field_41173, this.producedFluids));
        nbt.method_10566("pendingCraftedStats", (class_2520)PlayerStatistics.pendingToNbt(this.pendingCraftedStats));
        return nbt;
    }

    public void addUsedItems(class_1935 what, long amount) {
        this.usedItems.computeIfAbsent(what.method_8389(), i -> new StatisticValue()).add(amount);
    }

    public void addProducedItems(class_1935 what, long amount) {
        class_1792 item = what.method_8389();
        this.producedItems.computeIfAbsent(item, i -> new StatisticValue()).add(amount);
        if (this.uuid != null) {
            FTBQuestsFacade.INSTANCE.addCompleted(this.uuid, item, amount);
            this.awardStat(what, amount);
            for (UUID otherTeamMember : FTBTeamsFacade.INSTANCE.getOtherPlayersInTeam(this.uuid)) {
                this.data.get(otherTeamMember).awardStat(what, amount);
            }
        }
    }

    public void addUsedFluids(class_3611 what, long amount) {
        this.usedFluids.computeIfAbsent(what, i -> new StatisticValue()).add(amount);
    }

    public void addProducedFluids(class_3611 what, long amount) {
        this.producedFluids.computeIfAbsent(what, i -> new StatisticValue()).add(amount);
    }

    private void awardStat(class_1935 what, long amount) {
        Objects.requireNonNull(this.uuid);
        class_3222 player = CommonProxy.getCurrentServer().method_3760().method_14602(this.uuid);
        if (player != null) {
            player.method_7342(class_3468.field_15370.method_14956((Object)what.method_8389()), Ints.saturatedCast((long)amount));
        } else {
            this.pendingCraftedStats.mergeLong((Object)what.method_8389(), amount, Long::sum);
        }
    }

    public void onPlayerJoin(class_3222 player) {
        if (!this.pendingCraftedStats.isEmpty()) {
            for (Reference2LongMap.Entry entry : this.pendingCraftedStats.reference2LongEntrySet()) {
                player.method_7342(class_3468.field_15370.method_14956((Object)((class_1792)entry.getKey())), Ints.saturatedCast((long)entry.getLongValue()));
            }
            this.pendingCraftedStats.clear();
        }
    }

    private static <T> void readNbt(class_2378<T> registry, Map<T, StatisticValue> map, class_2487 tag) {
        for (String key : tag.method_10541()) {
            try {
                Object val = registry.method_10223(new class_2960(key));
                if (val == class_1802.field_8162 || val == class_3612.field_15906) continue;
                map.put(val, new StatisticValue(tag.method_10562(key)));
            }
            catch (Exception exception) {}
        }
    }

    private static <T> class_2487 toNbt(class_2378<T> registry, Map<T, StatisticValue> map) {
        class_2487 tag = new class_2487();
        for (Map.Entry<T, StatisticValue> entry : map.entrySet()) {
            tag.method_10566(registry.method_10221(entry.getKey()).toString(), (class_2520)entry.getValue().toNbt());
        }
        return tag;
    }

    private static void pendingReadNbt(Reference2LongMap<class_1792> map, class_2487 tag) {
        for (String key : tag.method_10541()) {
            try {
                class_1792 val = (class_1792)class_7923.field_41178.method_10223(new class_2960(key));
                if (val == class_1802.field_8162) continue;
                map.put((Object)val, tag.method_10537(key));
            }
            catch (Exception exception) {}
        }
    }

    private static class_2487 pendingToNbt(Reference2LongMap<class_1792> map) {
        class_2487 tag = new class_2487();
        for (Reference2LongMap.Entry entry : map.reference2LongEntrySet()) {
            tag.method_10544(class_7923.field_41178.method_10221((Object)((class_1792)entry.getKey())).toString(), entry.getLongValue());
        }
        return tag;
    }
}

