/*
 * Decompiled with CFR 0.152.
 */
package net.xanthian.variantcraftingtables.datagen;

import java.util.Map;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.DefaultResourceConditions;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.xanthian.variantcraftingtables.block.Vanilla;
import net.xanthian.variantcraftingtables.block.compatability.AdAstra;
import net.xanthian.variantcraftingtables.block.compatability.BeachParty;
import net.xanthian.variantcraftingtables.block.compatability.BetterArcheology;
import net.xanthian.variantcraftingtables.block.compatability.Bewitchment;
import net.xanthian.variantcraftingtables.block.compatability.BiomeMakeover;
import net.xanthian.variantcraftingtables.block.compatability.Blockus;
import net.xanthian.variantcraftingtables.block.compatability.Botania;
import net.xanthian.variantcraftingtables.block.compatability.Cinderscapes;
import net.xanthian.variantcraftingtables.block.compatability.DeeperAndDarker;
import net.xanthian.variantcraftingtables.block.compatability.Desolation;
import net.xanthian.variantcraftingtables.block.compatability.Ecologics;
import net.xanthian.variantcraftingtables.block.compatability.EldritchEnd;
import net.xanthian.variantcraftingtables.block.compatability.Meadow;
import net.xanthian.variantcraftingtables.block.compatability.MineCells;
import net.xanthian.variantcraftingtables.block.compatability.NaturesSpirit;
import net.xanthian.variantcraftingtables.block.compatability.Promenade;
import net.xanthian.variantcraftingtables.block.compatability.RegionsUnexplored;
import net.xanthian.variantcraftingtables.block.compatability.SnifferPlus;
import net.xanthian.variantcraftingtables.block.compatability.TechReborn;
import net.xanthian.variantcraftingtables.block.compatability.Vinery;

public class LootTableGenerator
extends FabricBlockLootTableProvider {
    public LootTableGenerator(FabricDataOutput dataOutput) {
        super(dataOutput);
    }

    private void registerLootTables(Map<class_2960, class_2248> blockMap, String modId) {
        for (class_2248 block : blockMap.values()) {
            this.withConditions(new ConditionJsonProvider[]{DefaultResourceConditions.allModsLoaded((String[])new String[]{modId})}).method_46025(block);
        }
    }

    public void method_10379() {
        for (class_2248 block : Vanilla.VANILLA_CRAFTING_TABLES.values()) {
            this.method_46025(block);
        }
        this.registerLootTables(AdAstra.AA_TABLES, "ad_astra");
        this.registerLootTables(BeachParty.LDBP_TABLES, "beachparty");
        this.registerLootTables(BetterArcheology.BA_TABLES, "betterarcheology");
        this.registerLootTables(Bewitchment.BW_TABLES, "bewitchment");
        this.registerLootTables(BiomeMakeover.BM_TABLES, "biomemakeover");
        this.registerLootTables(Blockus.BLS_TABLES, "blockus");
        this.registerLootTables(Botania.BOT_TABLES, "botania");
        this.registerLootTables(Cinderscapes.CS_TABLES, "cinderscape");
        this.registerLootTables(DeeperAndDarker.DAD_TABLES, "deeperdarker");
        this.registerLootTables(Desolation.DS_TABLES, "desolation");
        this.registerLootTables(Ecologics.ECO_TABLES, "ecologics");
        this.registerLootTables(EldritchEnd.EE_TABLES, "eldritch_end");
        this.registerLootTables(Meadow.LDM_TABLES, "meadow");
        this.registerLootTables(MineCells.MC_TABLES, "minecells");
        this.registerSpecialLootTable(NaturesSpirit.NS_TABLES, "natures_spirit");
        this.registerLootTables(Promenade.PROM_TABLES, "promenade");
        this.registerSpecialLootTable(RegionsUnexplored.RU_TABLES, "regions_unexplored");
        this.registerLootTables(SnifferPlus.SP_TABLES, "snifferplus");
        this.registerLootTables(TechReborn.TR_TABLES, "techreborn");
        this.registerLootTables(Vinery.LDV_TABLES, "vinery");
    }

    public void registerSpecialLootTable(Map<class_2960, class_2248> tables, String modId) {
        for (Map.Entry<class_2960, class_2248> entry : tables.entrySet()) {
            class_2960 tableId = entry.getKey();
            class_2248 table = entry.getValue();
            String path = tableId.method_12832();
            String name = path.replace("variantcraftingtables:", "").replace("_crafting_table", "").replaceFirst("^[^_]+_", "");
            this.withConditions(new ConditionJsonProvider[]{DefaultResourceConditions.and((ConditionJsonProvider[])new ConditionJsonProvider[]{DefaultResourceConditions.allModsLoaded((String[])new String[]{modId}), DefaultResourceConditions.registryContains((class_5321[])new class_5321[]{class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)new class_2960(modId + ":" + name + "_planks"))})})}).method_46025(table);
        }
    }
}

