/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutter.entity.custom.goal;

import net.emilsg.clutter.entity.custom.EmberTortoiseEntity;
import net.minecraft.class_11;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1366;

public class EmberTortoiseMeleeGoal
extends class_1366 {
    private final EmberTortoiseEntity entity;
    private final double speed;
    private int attackDelay = 10;
    private class_11 path;
    private int updateCountdownTicks;
    private int cooldown;
    private long lastUpdateTime;
    private int ticksUntilNextAttack = 10;
    private boolean shouldCountTillNextAttack = false;

    public EmberTortoiseMeleeGoal(class_1314 mob, double speed, boolean pauseWhenMobIdle) {
        super(mob, speed, pauseWhenMobIdle);
        this.entity = (EmberTortoiseEntity)mob;
        this.speed = speed;
    }

    public boolean method_6264() {
        return !this.entity.isShielding() && this.startAttack();
    }

    private boolean startAttack() {
        long l = this.field_6503.method_37908().method_8510();
        if (l - this.lastUpdateTime < 20L) {
            return false;
        }
        this.lastUpdateTime = l;
        class_1309 livingEntity = this.field_6503.method_5968();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.method_5805()) {
            return false;
        }
        this.path = this.field_6503.method_5942().method_6349((class_1297)livingEntity, 1);
        if (this.path != null) {
            return true;
        }
        return this.method_6289(livingEntity) >= this.field_6503.method_5649(livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321());
    }

    public void method_6269() {
        this.field_6503.method_5942().method_6334(this.path, this.speed);
        this.field_6503.method_19540(true);
        this.updateCountdownTicks = 0;
        this.cooldown = 0;
        this.attackDelay = 10;
        this.ticksUntilNextAttack = 10;
    }

    protected void method_6288(class_1309 target, double squaredDistance) {
        if (this.entity.isShielding()) {
            this.entity.method_5942().method_6340();
            this.resetAttackCooldown();
            this.entity.method_19540(false);
            return;
        }
        if (this.isEnemyWithinAttackDistance(target)) {
            this.shouldCountTillNextAttack = true;
            if (this.isTimeToStartAttackAnimation()) {
                this.entity.method_19540(true);
            }
            if (this.isTimeToAttack()) {
                this.field_6503.method_5988().method_20248(target.method_23317(), target.method_23320(), target.method_23321());
                this.performAttack(target);
            }
        } else {
            this.resetAttackCooldown();
            this.shouldCountTillNextAttack = false;
            this.entity.method_19540(false);
            this.entity.attackAnimationTimeout = 0;
        }
    }

    private boolean isEnemyWithinAttackDistance(class_1309 pEnemy) {
        return this.field_6503.method_5858((class_1297)pEnemy) < 5.0;
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.method_38847(this.attackDelay * 2);
    }

    protected boolean isTimeToStartAttackAnimation() {
        return this.ticksUntilNextAttack <= this.attackDelay;
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected void performAttack(class_1309 pEnemy) {
        this.resetAttackCooldown();
        this.field_6503.method_6104(class_1268.field_5808);
        this.field_6503.method_6121((class_1297)pEnemy);
    }

    public void method_6268() {
        if (this.entity.isShielding()) {
            this.resetAttackCooldown();
            this.entity.method_19540(false);
            this.method_6270();
            return;
        }
        super.method_6268();
        if (this.shouldCountTillNextAttack) {
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        }
    }

    public void method_6270() {
        this.entity.method_19540(false);
        super.method_6270();
    }
}

