/*
 * Decompiled with CFR 0.152.
 */
package pyzpre.createbicyclesbitterballen.block.mechanicalfryer;

import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import pyzpre.createbicyclesbitterballen.block.mechanicalfryer.MechanicalFryerEntity;
import pyzpre.createbicyclesbitterballen.index.RecipeRegistry;

public class DeepFryingRecipe
extends BasinRecipe {
    public static boolean match(BasinBlockEntity basin, MechanicalFryerEntity fryer, class_1860<?> recipe) {
        BasinRecipe basinRecipe;
        FilteringBehaviour filter = basin.getFilter();
        if (filter == null) {
            return false;
        }
        boolean filterTest = filter.test(recipe.method_8110(basin.method_10997().method_30349()));
        if (recipe instanceof BasinRecipe && (basinRecipe = (BasinRecipe)recipe).getRollableResults().isEmpty() && !basinRecipe.getFluidResults().isEmpty()) {
            filterTest = filter.test((FluidStack)basinRecipe.getFluidResults().get(0));
        }
        if (!filterTest) {
            return false;
        }
        return DeepFryingRecipe.apply(basin, fryer, recipe, true);
    }

    public static boolean apply(ItemStackHandlerContainer inputInv, BasinBlockEntity basin, MechanicalFryerEntity fryer, class_1860<?> recipe) {
        return DeepFryingRecipe.apply(basin, fryer, recipe, false);
    }

    private static boolean apply(BasinBlockEntity basin, MechanicalFryerEntity fryer, class_1860<?> recipe, boolean test) {
        boolean isDeepFryingRecipe = recipe instanceof DeepFryingRecipe;
        SmartInventory availableItems = fryer.inputInv;
        Storage availableFluids = basin.getFluidStorage(null);
        if (availableItems == null || availableFluids == null) {
            return false;
        }
        BlazeBurnerBlock.HeatLevel heat = BasinBlockEntity.getHeatLevelOf((class_2680)basin.method_10997().method_8320(basin.method_11016().method_10087(1)));
        if (isDeepFryingRecipe && !((DeepFryingRecipe)recipe).getRequiredHeat().testBlazeBurner(heat)) {
            return false;
        }
        class_1799 inputStack = availableItems.getStackInSlot(0);
        int itemCount = inputStack.method_7947();
        if (itemCount <= 0) {
            return false;
        }
        class_2371 fluidIngredients = isDeepFryingRecipe ? ((DeepFryingRecipe)recipe).getFluidIngredients() : Collections.emptyList();
        boolean simulate = false;
        do {
            for (int i = 0; i < itemCount; ++i) {
                if (!test && !simulate) {
                    for (FluidIngredient fluidIngredient : fluidIngredients) {
                        if (DeepFryingRecipe.consumeFluids(fluidIngredient, (Storage<FluidVariant>)availableFluids, false)) continue;
                        return false;
                    }
                }
                if (simulate) continue;
                inputStack.method_7934(1);
                List<class_1799> recipeOutputItems = DeepFryingRecipe.generateOutputs(recipe, basin, 1);
                for (class_1799 itemStack : recipeOutputItems) {
                    if (DeepFryingRecipe.insertItemStacked((Storage<ItemVariant>)fryer.outputInv, itemStack)) continue;
                    return false;
                }
            }
            boolean bl = simulate = !simulate;
        } while (!test && simulate);
        return true;
    }

    private static boolean insertItemStacked(Storage<ItemVariant> storage, class_1799 stack) {
        try (Transaction transaction = Transaction.openOuter();){
            long inserted = storage.insert((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)transaction);
            if (inserted == (long)stack.method_7947()) {
                transaction.commit();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private static List<class_1799> generateOutputs(class_1860<?> recipe, BasinBlockEntity basin, int quantity) {
        ArrayList<class_1799> outputs = new ArrayList<class_1799>();
        if (recipe instanceof BasinRecipe) {
            for (class_1799 result : ((BasinRecipe)recipe).rollResults()) {
                class_1799 stack = result.method_7972();
                stack.method_7939(result.method_7947() * quantity);
                outputs.add(stack);
            }
            class_2371 fluidResults = ((BasinRecipe)recipe).getFluidResults();
            for (FluidStack fluidResult : fluidResults) {
                FluidStack outputFluidStack = fluidResult.copy();
                outputFluidStack.setAmount(outputFluidStack.getAmount() * (long)quantity);
                DeepFryingRecipe.inputFluidsToBasin(basin, outputFluidStack, false);
            }
        } else {
            class_1799 result = recipe.method_8110(basin.method_10997().method_30349()).method_7972();
            result.method_7939(result.method_7947() * quantity);
            outputs.add(result);
        }
        return outputs;
    }

    private static boolean consumeFluids(FluidIngredient fluidIngredient, Storage<FluidVariant> fluidStorage, boolean simulate) {
        long amountRequired = fluidIngredient.getRequiredAmount();
        AtomicBoolean success = new AtomicBoolean(false);
        try (Transaction transaction = Transaction.openOuter();){
            fluidStorage.forEach(view -> {
                long extracted;
                FluidVariant variant = (FluidVariant)view.getResource();
                long currentAmount = view.getAmount();
                if (fluidIngredient.test(new FluidStack(variant.getFluid(), (long)((int)(currentAmount / 81L)))) && (extracted = view.extract((Object)variant, amountRequired, (TransactionContext)transaction)) == amountRequired) {
                    success.set(true);
                }
            });
            if (success.get() && !simulate) {
                transaction.commit();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private static boolean inputFluidsToBasin(BasinBlockEntity basin, FluidStack fluidStack, boolean simulate) {
        Storage basinFluidStorage = basin.getFluidStorage(null);
        if (basinFluidStorage == null) {
            return false;
        }
        try (Transaction transaction = Transaction.openOuter();){
            long filled = basinFluidStorage.insert((Object)FluidVariant.of((class_3611)fluidStack.getFluid()), fluidStack.getAmount(), (TransactionContext)transaction);
            if (filled == fluidStack.getAmount()) {
                if (!simulate) {
                    transaction.commit();
                }
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    protected DeepFryingRecipe(IRecipeTypeInfo type, ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super(type, params);
    }

    public DeepFryingRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        this(RecipeRegistry.DEEP_FRYING, params);
    }

    protected int getMaxInputCount() {
        return 1;
    }

    protected int getMaxOutputCount() {
        return 1;
    }

    protected int getMaxFluidInputCount() {
        return 2;
    }

    protected int getMaxFluidOutputCount() {
        return 2;
    }

    protected boolean canRequireHeat() {
        return true;
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    public boolean matches(ItemStackHandlerContainer inv, @Nonnull class_1937 worldIn) {
        if (inv.method_5442()) {
            return false;
        }
        return ((class_1856)this.ingredients.get(0)).method_8093(inv.method_5438(0));
    }

    public boolean matches(SmartInventory inv, @Nonnull class_1937 worldIn) {
        if (inv.method_5442()) {
            return false;
        }
        return ((class_1856)this.ingredients.get(0)).method_8093(inv.method_5438(0));
    }
}

