/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.mehvahdjukaar.amendments.AmendmentsClient;
import net.mehvahdjukaar.amendments.common.FlowerPotHandler;
import net.mehvahdjukaar.amendments.common.entity.MediumDragonFireball;
import net.mehvahdjukaar.amendments.common.entity.MediumFireball;
import net.mehvahdjukaar.amendments.common.network.ModNetwork;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.events.behaviors.InteractEvents;
import net.mehvahdjukaar.amendments.events.dispenser.CauldronDispenserBehavior;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.integration.SuppCompat;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.util.DispenserHelper;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_2374;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_2965;
import net.minecraft.class_4538;
import net.minecraft.class_5431;
import net.minecraft.class_5455;
import net.minecraft.class_7706;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Amendments {
    public static final String MOD_ID = "amendments";
    public static final Logger LOGGER = LogManager.getLogger((String)"Amendments");
    public static final List<String> OLD_MODS = List.of("supplementaries", "carpeted", "betterlily", "betterjukebox");

    public static class_2960 res(String name) {
        return new class_2960(MOD_ID, name);
    }

    public static void init() {
        CommonConfigs.init();
        ModRegistry.init();
        ModNetwork.init();
        if (PlatHelper.getPhysicalSide().isClient()) {
            ClientConfigs.init();
            AmendmentsClient.init();
        }
        PlatHelper.addCommonSetupAsync(Amendments::setupAsync);
        PlatHelper.addCommonSetup(Amendments::setup);
        PlatHelper.addReloadableCommonSetup(Amendments::onReload);
        RegHelper.addDynamicDispenserBehaviorRegistration(Amendments::registerDispenserBehavior);
        RegHelper.registerSimpleRecipeCondition((class_2960)Amendments.res("flag"), CommonConfigs::isFlagOn);
        RegHelper.addItemsToTabsRegistration(Amendments::addItemsToTabs);
    }

    private static void addItemsToTabs(RegHelper.ItemToTabEvent itemToTabEvent) {
        if (CommonConfigs.THROWABLE_FIRE_CHARGES.get().booleanValue()) {
            itemToTabEvent.addBefore(class_7706.field_40202, i -> i.method_31574(class_1802.field_8543), new class_1935[]{class_1802.field_8814});
            if (CommonConfigs.DRAGON_CHARGE.get().booleanValue()) {
                itemToTabEvent.addBefore(class_7706.field_40202, i -> i.method_31574(class_1802.field_8543), new class_1935[]{(class_1935)ModRegistry.DRAGON_CHARGE.get()});
            }
        }
    }

    private static void setup() {
        if (CommonConfigs.INVERSE_POTIONS.get() == null) {
            throw new IllegalStateException("Inverse potions config is null. How??");
        }
        if (CompatHandler.SUPPLEMENTARIES) {
            SuppCompat.setup();
        }
        class_1299.field_6049.field_18981 = true;
        class_1299.field_6066.field_18981 = true;
        class_1299.field_6129.field_18981 = true;
    }

    private static void setupAsync() {
        FlowerPotHandler.setup();
    }

    public static void onReload(class_5455 registryAccess, boolean client) {
        InteractEvents.setupOverrides();
        if (client) {
            AmendmentsClient.afterTagSetup();
        }
    }

    private static void registerDispenserBehavior(DispenserHelper.Event event) {
        for (SoftFluid f : SoftFluidRegistry.getRegistry((class_5455)event.getRegistryAccess())) {
            Amendments.registerFluidBehavior(f, event);
        }
        if (CommonConfigs.FIRE_CHARGE_DISPENSER.get().booleanValue() && CommonConfigs.THROWABLE_FIRE_CHARGES.get().booleanValue()) {
            event.register(class_1802.field_8814, (class_2357)new class_2965(){

                protected MediumFireball getProjectile(class_1937 level, class_2374 position, class_1799 stack) {
                    return (MediumFireball)class_156.method_654((Object)new MediumFireball(level, position.method_10216(), position.method_10214(), position.method_10215()), snowball -> snowball.method_16940(stack));
                }

                protected void method_10136(class_2342 source) {
                    source.method_10207().method_20290(1018, source.method_10122(), 0);
                }
            });
        }
        if (CommonConfigs.DRAGON_CHARGE.get().booleanValue()) {
            event.register(ModRegistry.DRAGON_CHARGE.get(), (class_2357)new class_2965(){

                protected MediumDragonFireball getProjectile(class_1937 level, class_2374 position, class_1799 stack) {
                    return (MediumDragonFireball)class_156.method_654((Object)new MediumDragonFireball(level, position.method_10216(), position.method_10214(), position.method_10215()), snowball -> snowball.method_16940(stack));
                }

                protected void method_10136(class_2342 source) {
                    source.method_10207().method_20290(1018, source.method_10122(), 0);
                }
            });
        }
    }

    public static void registerFluidBehavior(SoftFluid f, DispenserHelper.Event event) {
        HashSet<class_1792> itemSet = new HashSet<class_1792>();
        Collection categories = f.getContainerList().getCategories();
        for (FluidContainerList.Category c : categories) {
            for (class_1792 full : c.getFilledItems()) {
                if (full == class_1802.field_8162 || itemSet.contains(full)) continue;
                event.register((DispenserHelper.AdditionalDispenserBehavior)new CauldronDispenserBehavior(full));
                itemSet.add(full);
            }
        }
    }

    public static boolean isSupportingCeiling(class_2338 pos, class_4538 world) {
        return Amendments.isSupportingCeiling(world.method_8320(pos), pos, world);
    }

    public static boolean isSupportingCeiling(class_2680 upState, class_2338 pos, class_4538 world) {
        if (CompatHandler.SUPPLEMENTARIES) {
            return SuppCompat.isSupportingCeiling(upState, pos, world);
        }
        return class_2248.method_20044((class_4538)world, (class_2338)pos, (class_2350)class_2350.field_11033);
    }

    public static boolean canConnectDown(class_2680 neighborState, class_1936 level, class_2338 pos) {
        if (CompatHandler.SUPPLEMENTARIES) {
            return SuppCompat.canConnectDown(neighborState);
        }
        return neighborState.method_30368((class_1922)level, pos, class_2350.field_11036, class_5431.field_25823);
    }
}

