/*
 * Decompiled with CFR 0.152.
 */
package net.lunade.copper.gametest;

import java.util.List;
import net.fabricmc.fabric.api.gametest.v1.FabricGameTest;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.frozenblock.lib.gametest.api.TrackedPosition;
import net.frozenblock.lib.storage.api.MoveDirection;
import net.lunade.copper.blocks.block_entity.CopperPipeEntity;
import net.lunade.copper.registry.RegisterBlocks;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4516;
import net.minecraft.class_6302;

public class SimpleCopperPipesGameTest
implements FabricGameTest {
    private static final String AXE_INTERACTION = "simple_copper_pipes:axe_interaction";
    private static final String COMPOSTER_TRANSFER = "simple_copper_pipes:composter_transfer";
    private static final String DIRECT_PIPE_TRANSFER = "simple_copper_pipes:direct_pipe_transfer";
    private static final String STORAGE_UNIFICATION = "simple_copper_pipes:storage_unification";

    private static long moveResources(class_4516 helper, TrackedPosition<class_2338> inventoryPos, ItemVariant resource, long maxAmount, MoveDirection direction, boolean simulate) {
        Storage<ItemVariant> inventory = CopperPipeEntity.getStorageAt((class_1937)helper.method_35943(), (class_2338)inventoryPos.absolute(), null);
        helper.method_46226(inventory != null, "Inventory not found at " + String.valueOf(inventoryPos.relative()));
        Transaction transaction = Transaction.openOuter();
        long amountMoved = simulate ? direction.simulateMoveResources(inventory, (Object)resource, maxAmount, (TransactionContext)transaction) : direction.moveResources(inventory, (Object)resource, maxAmount, (TransactionContext)transaction);
        transaction.commit();
        return amountMoved;
    }

    @class_6302(method_35936="simple_copper_pipes:axe_interaction")
    public void axeInteraction(class_4516 helper) {
        class_3222 player = helper.method_51891();
        player.method_33574(helper.method_35978(new class_243(9.5, 3.0, 0.5)));
        class_1799 stack = new class_1799((class_1935)class_1802.field_8556);
        TrackedPosition copperPipe = TrackedPosition.createRelative((class_4516)helper, (class_2248)RegisterBlocks.EXPOSED_COPPER_PIPE, (class_243)new class_243(9.5, 2.5, 0.5));
        TrackedPosition exposedPipe = TrackedPosition.createRelative((class_4516)helper, (class_2248)RegisterBlocks.WEATHERED_COPPER_PIPE, (class_243)new class_243(9.5, 2.5, 1.5));
        TrackedPosition weatheredPipe = TrackedPosition.createRelative((class_4516)helper, (class_2248)RegisterBlocks.OXIDIZED_COPPER_PIPE, (class_243)new class_243(9.5, 2.5, 2.5));
        TrackedPosition copperPipe2 = TrackedPosition.createRelative((class_4516)helper, (class_2248)RegisterBlocks.WAXED_COPPER_PIPE, (class_243)new class_243(8.5, 2.5, 0.5));
        TrackedPosition exposedPipe2 = TrackedPosition.createRelative((class_4516)helper, (class_2248)RegisterBlocks.WAXED_EXPOSED_COPPER_PIPE, (class_243)new class_243(8.5, 2.5, 1.5));
        TrackedPosition weatheredPipe2 = TrackedPosition.createRelative((class_4516)helper, (class_2248)RegisterBlocks.WAXED_WEATHERED_COPPER_PIPE, (class_243)new class_243(8.5, 2.5, 2.5));
        TrackedPosition oxidizedPipe = TrackedPosition.createRelative((class_4516)helper, (class_2248)RegisterBlocks.WAXED_OXIDIZED_COPPER_PIPE, (class_243)new class_243(8.5, 2.5, 3.5));
        TrackedPosition copperFitting = TrackedPosition.createRelative((class_4516)helper, (class_2248)RegisterBlocks.EXPOSED_COPPER_FITTING, (class_243)new class_243(9.5, 2.5, 7.5));
        TrackedPosition exposedFitting = TrackedPosition.createRelative((class_4516)helper, (class_2248)RegisterBlocks.WEATHERED_COPPER_FITTING, (class_243)new class_243(9.5, 2.5, 8.5));
        TrackedPosition weatheredFitting = TrackedPosition.createRelative((class_4516)helper, (class_2248)RegisterBlocks.OXIDIZED_COPPER_FITTING, (class_243)new class_243(9.5, 2.5, 9.5));
        TrackedPosition copperFitting2 = TrackedPosition.createRelative((class_4516)helper, (class_2248)RegisterBlocks.WAXED_COPPER_FITTING, (class_243)new class_243(8.5, 2.5, 6.5));
        TrackedPosition exposedFitting2 = TrackedPosition.createRelative((class_4516)helper, (class_2248)RegisterBlocks.WAXED_EXPOSED_COPPER_FITTING, (class_243)new class_243(8.5, 2.5, 7.5));
        TrackedPosition weatheredFitting2 = TrackedPosition.createRelative((class_4516)helper, (class_2248)RegisterBlocks.WAXED_WEATHERED_COPPER_FITTING, (class_243)new class_243(8.5, 2.5, 8.5));
        TrackedPosition oxidizedFitting = TrackedPosition.createRelative((class_4516)helper, (class_2248)RegisterBlocks.WAXED_OXIDIZED_COPPER_FITTING, (class_243)new class_243(8.5, 2.5, 9.5));
        List<TrackedPosition> copperLocations = List.of(copperPipe, exposedPipe, weatheredPipe, copperPipe2, exposedPipe2, weatheredPipe2, oxidizedPipe, copperFitting, exposedFitting, weatheredFitting, copperFitting2, exposedFitting2, weatheredFitting2, oxidizedFitting);
        helper.method_36003(1L, () -> {
            for (TrackedPosition location : copperLocations) {
                class_243 absolute = (class_243)location.absolute();
                player.method_33574(absolute.method_1031(0.0, 0.5, 0.0));
                player.method_5702(class_2183.class_2184.field_9851, absolute);
                class_3965 hitResult = (class_3965)player.method_5745(2.0, 1.0f, false);
                class_1838 context = new class_1838((class_1657)player, class_1268.field_5808, hitResult);
                stack.method_7981(context);
            }
        });
        helper.method_36003(2L, () -> {
            helper.method_35943().method_8503().method_3760().method_14611(player);
            player.method_5650(class_1297.class_5529.field_26999);
            copperPipe.assertBlockPresent(helper, RegisterBlocks.COPPER_PIPE);
            exposedPipe.assertBlockPresent(helper, RegisterBlocks.EXPOSED_COPPER_PIPE);
            weatheredPipe.assertBlockPresent(helper, RegisterBlocks.WEATHERED_COPPER_PIPE);
            copperPipe2.assertBlockPresent(helper, RegisterBlocks.COPPER_PIPE);
            exposedPipe2.assertBlockPresent(helper, RegisterBlocks.EXPOSED_COPPER_PIPE);
            weatheredPipe2.assertBlockPresent(helper, RegisterBlocks.WEATHERED_COPPER_PIPE);
            oxidizedPipe.assertBlockPresent(helper, RegisterBlocks.OXIDIZED_COPPER_PIPE);
            copperFitting.assertBlockPresent(helper, RegisterBlocks.COPPER_FITTING);
            exposedFitting.assertBlockPresent(helper, RegisterBlocks.EXPOSED_COPPER_FITTING);
            weatheredFitting.assertBlockPresent(helper, RegisterBlocks.WEATHERED_COPPER_FITTING);
            copperFitting2.assertBlockPresent(helper, RegisterBlocks.COPPER_FITTING);
            exposedFitting2.assertBlockPresent(helper, RegisterBlocks.EXPOSED_COPPER_FITTING);
            weatheredFitting2.assertBlockPresent(helper, RegisterBlocks.WEATHERED_COPPER_FITTING);
            oxidizedFitting.assertBlockPresent(helper, RegisterBlocks.OXIDIZED_COPPER_FITTING);
            helper.method_36036();
        });
    }

    @class_6302(method_35936="simple_copper_pipes:composter_transfer")
    public void composterTransfer(class_4516 helper) {
        ItemVariant inputResource = ItemVariant.of((class_1935)class_1802.field_17513);
        ItemVariant outputResource = ItemVariant.of((class_1935)class_1802.field_8324);
        TrackedPosition source = TrackedPosition.createRelative((class_4516)helper, (class_2248)RegisterBlocks.WAXED_COPPER_PIPE, (class_2338)new class_2338(9, 4, 4));
        TrackedPosition output = TrackedPosition.createRelative((class_4516)helper, (class_2248)class_2246.field_10034, (class_2338)new class_2338(7, 2, 4));
        SimpleCopperPipesGameTest.moveResources(helper, (TrackedPosition<class_2338>)source, inputResource, 32L, MoveDirection.IN, false);
        helper.method_36003(75L, () -> {
            long amountInChest = SimpleCopperPipesGameTest.moveResources(helper, (TrackedPosition<class_2338>)output, outputResource, 32L, MoveDirection.OUT, true);
            if (amountInChest > 0L) {
                helper.method_36036();
            } else {
                helper.method_35995("No items in chest");
            }
        });
    }

    @class_6302(method_35936="simple_copper_pipes:direct_pipe_transfer")
    public void directPipeTransfer(class_4516 helper) {
        ItemVariant resource = ItemVariant.of((class_1935)class_2246.field_37545);
        TrackedPosition sourceChest = TrackedPosition.createRelative((class_4516)helper, (class_2248)class_2246.field_10034, (class_2338)new class_2338(9, 2, 4));
        TrackedPosition targetChest = TrackedPosition.createRelative((class_4516)helper, (class_2248)class_2246.field_10034, (class_2338)new class_2338(0, 2, 4));
        SimpleCopperPipesGameTest.moveResources(helper, (TrackedPosition<class_2338>)sourceChest, resource, 32L, MoveDirection.IN, false);
        helper.method_36040(() -> {
            long amountInChest = SimpleCopperPipesGameTest.moveResources(helper, (TrackedPosition<class_2338>)targetChest, resource, 32L, MoveDirection.OUT, true);
            if (amountInChest == 32L) {
                helper.method_36036();
            }
        });
    }

    @class_6302(method_35936="simple_copper_pipes:storage_unification", method_35932=700)
    public void storageUnification(class_4516 helper) {
        ItemVariant resource = ItemVariant.of((class_1935)class_2246.field_37545);
        for (int z = 0; z < 10; z += 2) {
            TrackedPosition chestPos = TrackedPosition.createRelative((class_4516)helper, (class_2248)class_2246.field_10034, (class_2338)new class_2338(9, 2, z));
            SimpleCopperPipesGameTest.moveResources(helper, (TrackedPosition<class_2338>)chestPos, resource, 128L, MoveDirection.IN, false);
        }
        TrackedPosition chestPos = TrackedPosition.createRelative((class_4516)helper, (class_2248)class_2246.field_10034, (class_2338)new class_2338(9, 4, 4));
        helper.method_36040(() -> {
            long amountInChest = SimpleCopperPipesGameTest.moveResources(helper, (TrackedPosition<class_2338>)chestPos, resource, 640L, MoveDirection.OUT, true);
            if (amountInChest == 640L) {
                helper.method_36036();
            }
        });
    }
}

