/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.commands;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.command.Command;
import com.majruszlibrary.command.CommandData;
import com.majruszlibrary.command.IParameter;
import com.majruszlibrary.events.OnGameInitialized;
import com.majruszlibrary.item.ItemHelper;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.registry.Registries;
import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.config.Config;
import com.majruszsaccessories.items.AccessoryItem;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

@AutoInstance
public class SpawnAccessoryCommand {
    static final List<class_2960> ID_SUGGESTIONS = new ArrayList<class_2960>();
    static final IParameter<List<? extends class_1297>> ENTITIES = Command.entities().named("entity");
    static final IParameter<class_2960> ID = Command.resource().named("id").suggests(() -> ID_SUGGESTIONS);
    static final IParameter<Float> BONUS = Command.number().named("bonus");
    static final IParameter<Integer> COUNT = Command.integer((Range)Range.of((Number)1, (Number)10)).named("count");

    public SpawnAccessoryCommand() {
        Command.create().literal(new String[]{"accessory"}).hasPermission(4).literal(new String[]{"create"}).parameter(ENTITIES).parameter(ID).execute(this::giveAccessory).parameter(COUNT).execute(this::giveAccessory).parameter(BONUS).execute(this::giveAccessory).register();
        OnGameInitialized.listen(this::createSuggestions);
    }

    private int giveAccessory(CommandData data) throws CommandSyntaxException {
        List entities = (List)data.get(ENTITIES);
        class_1792 item = (class_1792)Registries.ITEMS.get((class_2960)data.get(ID));
        Optional bonus = data.getOptional(BONUS);
        int count = data.getOptional(COUNT).orElse(1);
        for (class_1297 entity : entities) {
            if (!(entity instanceof class_1657)) continue;
            class_1657 player = (class_1657)entity;
            for (int i = 0; i < count; ++i) {
                AccessoryHolder holder = AccessoryHolder.create(item);
                holder.setBonus(bonus.orElseGet(Config.Efficiency::getRandom).floatValue());
                ItemHelper.giveToPlayer((class_1799)holder.getItemStack(), (class_1657)player);
            }
        }
        return 0;
    }

    private void createSuggestions(OnGameInitialized data) {
        for (class_1792 item : Registries.ITEMS) {
            if (!(item instanceof AccessoryItem)) continue;
            ID_SUGGESTIONS.add(Registries.ITEMS.getId((Object)item));
        }
    }
}

