/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.convenientdecor.mixin.compat.origins;

import com.github.mim1q.convenientdecor.ConvenientDecor;
import com.github.mim1q.convenientdecor.item.ModItemTags;
import com.github.mim1q.convenientdecor.item.RaincoatItem;
import com.github.mim1q.convenientdecor.item.UmbrellaItem;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(targets={"io.github.apace100.apoli.power.factory.condition.ConditionFactory"})
public class ApoliConditionFactoryMixin {
    @Mutable
    @Shadow
    @Final
    private BiFunction condition;
    @Unique
    private BiFunction oldCondition;
    @Unique
    private static final Set<class_2960> CONDITIONS_NEGATED_BY_UMBRELLA = Set.of(ApoliConditionFactoryMixin.apoliId("exposed_to_sky"), ApoliConditionFactoryMixin.apoliId("exposed_to_sun"), ApoliConditionFactoryMixin.apoliId("in_rain"));
    @Unique
    private static final Set<class_2960> CONDITIONS_NEGATED_BY_RAIN_CLOTHES = Set.of(ApoliConditionFactoryMixin.apoliId("in_rain"));

    @Unique
    private static class_2960 apoliId(String name) {
        return new class_2960("apoli", name);
    }

    @Inject(method={"<init>(Lnet/minecraft/util/Identifier;Lio/github/apace100/calio/data/SerializableData;Ljava/util/function/BiFunction;)V"}, at={@At(value="TAIL")})
    private void init(class_2960 identifier, @Coerce Object data, BiFunction condition, CallbackInfo ci) {
        this.oldCondition = condition;
        if (ConvenientDecor.CONFIG.features.umbrellaOriginsIntegration && CONDITIONS_NEGATED_BY_UMBRELLA.contains(identifier)) {
            ConvenientDecor.LOGGER.info("Patching condition: " + identifier + " to negate with umbrellas");
            this.condition = (a, b) -> (Boolean)this.oldCondition.apply(a, b) != false && !ApoliConditionFactoryMixin.holdingUmbrella((class_1309)b);
        }
        if (ConvenientDecor.CONFIG.features.rainclothesOriginsIntegration && CONDITIONS_NEGATED_BY_RAIN_CLOTHES.contains(identifier)) {
            ConvenientDecor.LOGGER.info("Patching condition: " + identifier + " to negate with rain clothes");
            this.condition = (a, b) -> (Boolean)this.oldCondition.apply(a, b) != false && !ApoliConditionFactoryMixin.hasRainClothes((class_1309)b);
        }
    }

    @Unique
    private static boolean holdingUmbrella(class_1309 entity) {
        return ApoliConditionFactoryMixin.holdingUmbrellaInHand(entity, class_1268.field_5808) || ApoliConditionFactoryMixin.holdingUmbrellaInHand(entity, class_1268.field_5810);
    }

    @Unique
    private static boolean holdingUmbrellaInHand(class_1309 entity, class_1268 hand) {
        class_1799 stack = entity.method_5998(hand);
        return stack.method_31573(ModItemTags.UMBRELLAS) && !UmbrellaItem.isFolded(stack);
    }

    @Unique
    private static boolean hasRainClothes(class_1309 entity) {
        boolean hasRainHat = entity.method_6118(class_1304.field_6169).method_31573(ModItemTags.RAIN_HATS);
        class_1799 rainCoat = entity.method_6118(class_1304.field_6174);
        boolean hasRainCoatWithHood = rainCoat.method_31573(ModItemTags.RAINCOATS) && RaincoatItem.isHooded(rainCoat);
        return hasRainHat || hasRainCoatWithHood;
    }
}

