/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_4538;
import rbasamoyai.escalated.walkways.WalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayBlockEntity;
import rbasamoyai.escalated.walkways.WalkwayRenderer;
import rbasamoyai.escalated.walkways.WalkwaySlope;

public class WalkwayInstance
extends KineticBlockEntityInstance<WalkwayBlockEntity>
implements DynamicInstance {
    private RotatingData leftShaft;
    private RotatingData rightShaft;
    private RotatingData bottomShaft;
    private OrientedData backStep;
    private OrientedData frontStep;
    private class_1767 color;

    public WalkwayInstance(MaterialManager materialManager, WalkwayBlockEntity blockEntity) {
        super(materialManager, (KineticBlockEntity)blockEntity);
    }

    public void init() {
        super.init();
        KineticBlock kinetic = (KineticBlock)this.blockState.method_26204();
        WalkwayBlock walkway = (WalkwayBlock)this.blockState.method_26204();
        class_1937 level = ((WalkwayBlockEntity)this.blockEntity).method_10997();
        class_2350 left = class_2350.method_10169((class_2350.class_2351)kinetic.getRotationAxis(this.blockState), (class_2350.class_2352)class_2350.class_2352.field_11056);
        class_2350 right = left.method_10153();
        this.leftShaft = kinetic.hasShaftTowards((class_4538)level, this.pos, this.blockState, left) ? this.setup((RotatingData)this.getRotatingMaterial().getModel(AllPartialModels.SHAFT_HALF, this.blockState, left).createInstance(), left.method_10166()) : null;
        this.rightShaft = kinetic.hasShaftTowards((class_4538)level, this.pos, this.blockState, right) ? this.setup((RotatingData)this.getRotatingMaterial().getModel(AllPartialModels.SHAFT_HALF, this.blockState, right).createInstance(), right.method_10166()) : null;
        this.bottomShaft = kinetic.hasShaftTowards((class_4538)level, this.pos, this.blockState, class_2350.field_11033) ? this.setup((RotatingData)this.getRotatingMaterial().getModel(AllPartialModels.SHAFT_HALF, this.blockState, class_2350.field_11033).createInstance(), class_2350.class_2351.field_11052) : null;
        boolean isTerminal = walkway.getWalkwaySlope(this.blockState) == WalkwaySlope.TERMINAL;
        boolean isController = ((WalkwayBlockEntity)this.blockEntity).isController();
        class_2350 facing = this.getFacing();
        class_2338 pos1 = this.getInstancePosition();
        this.color = ((WalkwayBlockEntity)this.blockEntity).getColor();
        PartialModel model = this.getStepModel();
        if (isTerminal) {
            boolean flag = facing == class_2350.field_11043 || facing == class_2350.field_11034;
            class_2350 class_23502 = facing = isController ? facing.method_10153() : facing;
            if (flag) {
                this.backStep = ((OrientedData)this.getOrientedMaterial().getModel(model, this.blockState, facing).createInstance()).setPosition(WalkwayRenderer.getStepOffset((WalkwayBlockEntity)this.blockEntity, facing, pos1, false));
            } else {
                this.frontStep = ((OrientedData)this.getOrientedMaterial().getModel(model, this.blockState, facing).createInstance()).setPosition(WalkwayRenderer.getStepOffset((WalkwayBlockEntity)this.blockEntity, facing, pos1, true));
            }
        } else {
            this.frontStep = ((OrientedData)this.getOrientedMaterial().getModel(model, this.blockState, facing).createInstance()).setPosition(WalkwayRenderer.getStepOffset((WalkwayBlockEntity)this.blockEntity, facing, pos1, true));
            this.backStep = ((OrientedData)this.getOrientedMaterial().getModel(model, this.blockState, facing).createInstance()).setPosition(WalkwayRenderer.getStepOffset((WalkwayBlockEntity)this.blockEntity, facing, pos1, false));
        }
    }

    public void remove() {
        if (this.leftShaft != null) {
            this.leftShaft.delete();
        }
        this.leftShaft = null;
        if (this.rightShaft != null) {
            this.rightShaft.delete();
        }
        this.rightShaft = null;
        if (this.bottomShaft != null) {
            this.bottomShaft.delete();
        }
        this.bottomShaft = null;
        if (this.backStep != null) {
            this.backStep.delete();
        }
        this.backStep = null;
        if (this.frontStep != null) {
            this.frontStep.delete();
        }
        this.frontStep = null;
    }

    protected class_2350 getFacing() {
        return ((WalkwayBlock)this.blockState.method_26204()).getFacing(this.blockState);
    }

    public void beginFrame() {
        class_2350 facing = this.getFacing();
        class_2338 pos = this.getInstancePosition();
        if (this.frontStep != null) {
            this.frontStep.setPosition(WalkwayRenderer.getStepOffset((WalkwayBlockEntity)this.blockEntity, facing, pos, true));
        }
        if (this.backStep != null) {
            this.backStep.setPosition(WalkwayRenderer.getStepOffset((WalkwayBlockEntity)this.blockEntity, facing, pos, false));
        }
    }

    public void update() {
        super.update();
        if (this.leftShaft != null) {
            this.updateRotation(this.leftShaft);
        }
        if (this.rightShaft != null) {
            this.updateRotation(this.rightShaft);
        }
        if (this.bottomShaft != null) {
            this.updateRotation(this.bottomShaft, class_2350.class_2351.field_11052);
        }
    }

    public boolean shouldReset() {
        if (super.shouldReset()) {
            return true;
        }
        if (((WalkwayBlockEntity)this.blockEntity).getColor() != this.color) {
            return true;
        }
        if (((WalkwayBlockEntity)this.blockEntity).resetClientRender) {
            ((WalkwayBlockEntity)this.blockEntity).resetClientRender = false;
            return true;
        }
        return false;
    }

    public void updateLight() {
        super.updateLight();
        if (this.leftShaft != null) {
            this.relight(this.pos, new FlatLit[]{this.leftShaft});
        }
        if (this.rightShaft != null) {
            this.relight(this.pos, new FlatLit[]{this.rightShaft});
        }
        if (this.bottomShaft != null) {
            this.relight(this.pos, new FlatLit[]{this.bottomShaft});
        }
        if (this.backStep != null) {
            this.relight(this.pos, new FlatLit[]{this.backStep});
        }
        if (this.frontStep != null) {
            this.relight(this.pos, new FlatLit[]{this.frontStep});
        }
    }

    protected PartialModel getStepModel() {
        return WalkwayRenderer.baseGetStepModel((WalkwayBlockEntity)this.blockEntity);
    }
}

