/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7699;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import snownee.kiwi.Kiwi;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.item.ItemCategoryFiller;

public class GroupSetting {
    private final String[] groups;
    private final String[] after;
    private final List<ItemCategoryFiller> fillers = Lists.newArrayList();

    public static GroupSetting of(KiwiModule.Category category, GroupSetting preset) {
        if (preset != null) {
            if (category.value().length == 0 && category.after().length == 0) {
                return preset;
            }
            if (category.value().length == 0) {
                return new GroupSetting(preset.groups, category.after());
            }
        }
        return new GroupSetting(category.value(), category.after());
    }

    public GroupSetting(String[] groups, String[] after) {
        this.groups = groups;
        this.after = after;
    }

    public void apply(ItemCategoryFiller filler) {
        this.fillers.add(filler);
    }

    public void postApply() {
        List<class_5321> tabKeys = Stream.of(this.groups).map($ -> {
            class_1761 tab = Kiwi.getGroup($);
            if (tab != null) {
                return class_7923.field_44687.method_29113((Object)tab).orElse(null);
            }
            return class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)new class_2960($));
        }).filter(Objects::nonNull).toList();
        for (class_5321 tabKey : tabKeys) {
            ItemGroupEvents.modifyEntriesEvent((class_5321)tabKey).register(entries -> {
                Set<class_1792> afterItems = Stream.of(this.after).map(class_2960::method_12829).filter(Objects::nonNull).map(arg_0 -> ((class_7922)class_7923.field_41178).method_10223(arg_0)).filter(Predicate.not(class_1802.field_8162::equals)).collect(Collectors.toSet());
                List<Object> items = Lists.newArrayList();
                for (ItemCategoryFiller filler : this.fillers) {
                    class_1761 tab = (class_1761)class_7923.field_44687.method_29107(tabKey);
                    filler.fillItemCategory(tab, entries.getEnabledFeatures(), entries.shouldShowOpRestrictedItems(), items);
                }
                items = GroupSetting.getEnabledStacks(items, entries.getEnabledFeatures());
                GroupSetting.addAfter(items, entries.getDisplayStacks(), afterItems);
                GroupSetting.addAfter(items, entries.getSearchTabStacks(), afterItems);
            });
        }
    }

    private static void addAfter(List<class_1799> toAdd, List<class_1799> destination, Collection<class_1792> afterItems) {
        int lastFound = -1;
        if (!afterItems.isEmpty()) {
            for (int i = 0; i < destination.size(); ++i) {
                class_1799 stack = destination.get(i);
                if (!afterItems.contains(stack.method_7909())) continue;
                lastFound = i;
            }
        }
        if (lastFound >= 0) {
            destination.addAll(lastFound + 1, toAdd);
        } else {
            destination.addAll(toAdd);
        }
    }

    private static List<class_1799> getEnabledStacks(List<class_1799> newStacks, class_7699 enabledFeatures) {
        if (newStacks.stream().allMatch($ -> GroupSetting.isEnabled($, enabledFeatures))) {
            return newStacks;
        }
        return newStacks.stream().filter($ -> GroupSetting.isEnabled($, enabledFeatures)).toList();
    }

    private static boolean isEnabled(class_1799 stack, class_7699 enabledFeatures) {
        return stack.method_7909().method_45382(enabledFeatures);
    }
}

