/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.builder;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_5481;
import net.minecraft.class_746;
import net.minecraft.class_768;
import net.minecraft.class_7842;
import net.minecraft.class_7999;
import net.minecraft.class_8000;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.lwjgl.glfw.GLFW;
import snownee.kiwi.customization.builder.ItemButton;
import snownee.kiwi.customization.builder.PanelLayout;
import snownee.kiwi.customization.network.CConvertItemPacket;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.util.KHolder;
import snownee.kiwi.util.LerpedFloat;
import snownee.kiwi.util.MultilineTooltip;
import snownee.kiwi.util.NotNullByDefault;

@NotNullByDefault
public class ConvertScreen
extends class_437 {
    private static ConvertScreen lingeringScreen;
    private final boolean inContainer;
    private final boolean inCreativeContainer;
    @Nullable
    private final class_1735 slot;
    private final int slotIndex;
    private final Collection<CConvertItemPacket.Group> groups;
    private final LerpedFloat openProgress = LerpedFloat.linear();
    private PanelLayout layout;
    private final Vector2i originalMousePos;
    private final class_1799 sourceItem;

    private static Vector2i getMousePos() {
        class_310 mc = class_310.method_1551();
        class_312 mouseHandler = mc.field_1729;
        return new Vector2i((int)mouseHandler.method_1603(), (int)mouseHandler.method_1604());
    }

    public ConvertScreen(@Nullable class_437 parent, @Nullable class_1735 slot, int slotIndex, List<CConvertItemPacket.Group> groups) {
        super((class_2561)class_2561.method_43471((String)"gui.kiwi.builder.convert"));
        this.slot = slot;
        this.slotIndex = slotIndex;
        this.groups = groups;
        this.inContainer = parent instanceof class_465;
        this.inCreativeContainer = parent instanceof class_481;
        this.originalMousePos = ConvertScreen.getMousePos();
        this.openProgress.setValue(0.2f);
        this.openProgress.chase(1.0, 0.8, LerpedFloat.Chaser.EXP);
        this.sourceItem = this.getSourceItem();
    }

    private class_1799 getSourceItem() {
        if (this.slot != null) {
            return this.slot.method_7677();
        }
        class_1661 inventory = Objects.requireNonNull(class_310.method_1551().field_1724).method_31548();
        return inventory.method_5438(this.slotIndex);
    }

    protected void method_25426() {
        Vector2f anchor;
        int y;
        int x;
        this.layout = new PanelLayout(2);
        int step = this.inContainer ? 19 : 21;
        int xStart = 0;
        int yStart = 0;
        int curX = xStart;
        int curY = yStart;
        HashSet accepted = Sets.newHashSet();
        class_746 player = Objects.requireNonNull(this.mc().field_1724);
        for (CConvertItemPacket.Group group : this.groups) {
            accepted.addAll(group.entries());
        }
        int itemsPerLine = accepted.size() > 30 ? 11 : 4;
        class_4185 cursorOn = null;
        for (CConvertItemPacket.Group group : this.groups) {
            for (CConvertItemPacket.Entry entry : group.entries()) {
                List<class_2561> tooltip;
                if (!accepted.contains(entry)) continue;
                class_1799 itemStack = new class_1799((class_1935)entry.item());
                class_4185 button = ItemButton.builder(itemStack, this.inContainer, btn -> {
                    class_1792 to;
                    class_1792 from = this.sourceItem.method_7909();
                    if (from == (to = ((ItemButton)btn).getItem().method_7909())) {
                        this.method_25419();
                        return;
                    }
                    boolean convertOne = ConvertScreen.method_25441();
                    class_746 player0 = Objects.requireNonNull(this.mc().field_1724);
                    if (this.inCreativeContainer && convertOne) {
                        CConvertItemPacket.send(false, -500, entry, from, true);
                    } else if (this.inCreativeContainer) {
                        Objects.requireNonNull(this.slot);
                        class_1799 newItem = to.method_7854();
                        newItem.method_7939(this.slot.method_7677().method_7947());
                        newItem.method_7912(5);
                        this.slot.method_48931(newItem);
                        class_2371 slots = player0.field_7498.field_7761;
                        for (int i = 0; i < slots.size(); ++i) {
                            if (((class_1735)slots.get(i)).method_7677() != newItem) continue;
                            Objects.requireNonNull(this.mc().field_1761).method_2909(newItem, i);
                            CConvertItemPacket.playPickupSound((class_1657)player0);
                            break;
                        }
                    } else {
                        CConvertItemPacket.send(this.inContainer, this.slotIndex, entry, from, convertOne);
                    }
                    if (convertOne && (player0.method_7337() || this.sourceItem.method_7947() > 1)) {
                        return;
                    }
                    if (this.inContainer) {
                        GLFW.glfwSetCursorPos((long)this.mc().method_22683().method_4490(), (double)this.originalMousePos.x, (double)this.originalMousePos.y);
                    }
                    this.method_25419();
                }).method_46434(curX, curY, 21, 21).method_46431();
                button.method_25350(this.inContainer ? 0.2f : 0.8f);
                if (Platform.isProduction()) {
                    tooltip = List.of(itemStack.method_7964());
                } else {
                    String steps = String.join((CharSequence)" -> ", entry.steps().stream().map(Pair::getFirst).map(KHolder::key).map(Objects::toString).toList());
                    tooltip = List.of(itemStack.method_7964(), class_2561.method_43470((String)steps).method_27692(class_124.field_1080));
                }
                button.method_47400(MultilineTooltip.create(tooltip));
                if (cursorOn == null && itemStack.method_31574(this.sourceItem.method_7909())) {
                    cursorOn = button;
                }
                this.layout.addWidget((class_339)button);
                if ((curX += step) < xStart + itemsPerLine * step) continue;
                curX = xStart;
                curY += step;
            }
        }
        if (this.inContainer) {
            x = this.field_22789 / 2;
            y = this.field_22790 / 2;
            anchor = new Vector2f(0.5f, 0.5f);
        } else {
            class_1306 humanoidarm;
            x = this.slotIndex == 40 ? ((humanoidarm = player.method_6068().method_5928()) == class_1306.field_6182 ? this.field_22789 / 2 - 91 - 29 + 11 : this.field_22789 / 2 + 91 + 17) : this.field_22789 / 2 - 91 + 11 + player.method_31548().field_7545 * 20;
            y = this.field_22790 - 24;
            anchor = new Vector2f(0.5f, 1.0f);
        }
        this.layout.bind(this, new Vector2i(x, y), anchor);
        if (cursorOn != null) {
            class_1041 window = this.mc().method_22683();
            double scale = window.method_4495();
            GLFW.glfwSetCursorPos((long)window.method_4490(), (double)((double)(cursorOn.method_46426() + 15) * scale), (double)((double)(cursorOn.method_46427() + 15) * scale));
        }
        class_768 bounds = this.layout.bounds();
        class_7842 dummySpacer = new class_7842(bounds.method_3321() - 2, bounds.method_3322() - 2, 10000, 10000, (class_2561)class_2561.method_43473(), this.mc().field_1772);
        class_7999 tooltipPositioner = new class_7999((class_339)dummySpacer);
        for (class_339 widget : this.layout.widgets()) {
            if (!(widget instanceof ItemButton)) continue;
            ItemButton button = (ItemButton)widget;
            button.setTooltipPositioner((class_8000)tooltipPositioner);
        }
    }

    public void method_25393() {
        this.openProgress.tickChaser();
        if (!this.isClosing() && !class_1799.method_31577((class_1799)this.sourceItem, (class_1799)this.getSourceItem())) {
            this.method_25419();
        }
    }

    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        class_768 bounds;
        class_768 tolerance;
        if (super.method_25402(pMouseX, pMouseY, pButton)) {
            return true;
        }
        if (pButton == 0 && !(tolerance = new class_768((bounds = this.layout.bounds()).method_3321() - 10, bounds.method_3322() - 10, bounds.method_3319() + 20, bounds.method_3320() + 20)).method_3318((int)pMouseX, (int)pMouseY)) {
            this.method_25419();
            return true;
        }
        return false;
    }

    public void method_25394(class_332 pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        class_4587 pose = pGuiGraphics.method_51448();
        this.layout.update();
        Vector2i pos = this.layout.getAnchoredPos();
        float openValue = this.openProgress.getValue(this.mc().method_1488());
        pose.method_22903();
        pose.method_46416((float)pos.x, (float)pos.y, 0.0f);
        pose.method_22905(openValue, openValue, openValue);
        pose.method_46416((float)(-pos.x), (float)(-pos.y), 0.0f);
        if (this.inContainer) {
            class_768 bounds = this.layout.bounds();
            pGuiGraphics.method_49697(new class_2960("textures/gui/demo_background.png"), bounds.method_3321() - 2, bounds.method_3322() - 2, bounds.method_3319() + 4, bounds.method_3320() + 4, 4, 4, 248, 166, 0, 0);
        }
        super.method_25394(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        pose.method_22909();
    }

    public void method_47942(List<class_5481> list, class_8000 tooltipPositioner, boolean force) {
        float openValue = this.openProgress.getValue(this.mc().method_1488());
        if (openValue > 0.95f) {
            super.method_47942(list, tooltipPositioner, force);
        }
    }

    public void method_25419() {
        this.openProgress.chase(0.0, 0.8, LerpedFloat.Chaser.EXP);
        lingeringScreen = this;
        super.method_25419();
    }

    public boolean isClosing() {
        return this.openProgress.getChaseTarget() == 0.0f;
    }

    public boolean method_25421() {
        return false;
    }

    public static void renderLingering(class_332 pGuiGraphics) {
        if (lingeringScreen == null) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1755 != null || mc.method_18506() != null || ConvertScreen.lingeringScreen.openProgress.settled()) {
            lingeringScreen = null;
            return;
        }
        lingeringScreen.method_25394(pGuiGraphics, Integer.MAX_VALUE, Integer.MAX_VALUE, mc.method_1534());
    }

    public static void tickLingering() {
        if (lingeringScreen != null) {
            lingeringScreen.method_25393();
        }
    }

    private class_310 mc() {
        return Objects.requireNonNull(this.field_22787);
    }
}

