/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.widget.value;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import mcp.mobius.waila.gui.widget.ConfigListWidget;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigValue<T>
extends ConfigListWidget.Entry {
    protected final Consumer<T> save;
    protected final String translationKey;
    @Nullable
    protected final T defaultValue;
    protected final T initialValue;
    private final class_5250 title;
    private final String description;
    private final class_4185 resetButton;
    @Nullable
    private String disabledReason = null;
    private boolean disabled = false;
    @Nullable
    private String id;
    private T value;
    private int x;

    public ConfigValue(String translationKey, T value, @Nullable T defaultValue, Consumer<T> save) {
        this.translationKey = translationKey;
        this.title = class_2561.method_43471((String)translationKey);
        this.description = translationKey + "_desc";
        this.initialValue = value;
        this.value = value;
        this.save = save;
        this.defaultValue = defaultValue;
        this.resetButton = defaultValue == null ? null : DisplayUtil.createButton(0, 0, 40, 20, (class_2561)class_2561.method_43471((String)"controls.reset"), button -> this.resetValue());
    }

    @Override
    protected void drawEntry(class_332 ctx, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
        class_5250 title = this.getTitle();
        if (this.isDisabled()) {
            title.method_27695(new class_124[]{class_124.field_1055, class_124.field_1080});
        } else if (!this.isValueValid()) {
            title.method_27695(new class_124[]{class_124.field_1056, class_124.field_1061});
        } else if (!this.value.equals(this.initialValue)) {
            title.method_27695(new class_124[]{class_124.field_1056, class_124.field_1054});
        } else {
            title.method_27692(class_124.field_1070);
        }
        class_327 class_3272 = this.client.field_1772;
        class_5250 class_52502 = title.method_27661();
        Objects.requireNonNull(this.client.field_1772);
        ctx.method_27535(class_3272, (class_2561)class_52502, rowLeft, rowTop + (height - 9) / 2, 0xFFFFFF);
        int w = width;
        if (this.resetButton != null) {
            w -= this.resetButton.method_25368() + 2;
            this.resetButton.method_46421(rowLeft + width - this.resetButton.method_25368());
            this.resetButton.method_46419(rowTop + (height - this.resetButton.method_25364()) / 2);
            this.resetButton.field_22763 = !this.isValueValid() || !this.isDisabled() && !this.getValue().equals(this.defaultValue);
            this.resetButton.method_25394(ctx, mouseX, mouseY, deltaTime);
        }
        this.drawValue(ctx, w, height, rowLeft, rowTop, mouseX, mouseY, hovered, deltaTime);
        this.x = rowLeft;
    }

    public void renderTooltip(class_332 ctx, int mouseX, int mouseY) {
        for (class_364 class_3642 : this.method_25396()) {
            if (!(class_3642 instanceof class_339)) continue;
            class_339 widget = (class_339)class_3642;
            int x1 = widget.method_46426() - 2;
            int y1 = widget.method_46427();
            int x2 = widget.method_46426() + widget.method_25368() + 4;
            int y2 = widget.method_46427() + widget.method_25364() + 4;
            if (x1 > mouseX || mouseX > x2 || y1 > mouseY || mouseY > y2) continue;
            return;
        }
        class_2561 desc = this.getDescription();
        if (this.id != null || desc != null || this.isDisabled() && this.disabledReason != null) {
            String string = this.getTitle().getString();
            ArrayList tooltip = Lists.newArrayList((Object[])new class_5481[]{class_2561.method_43470((String)string).method_30937()});
            if (desc != null) {
                tooltip.addAll(this.client.field_1772.method_1728((class_5348)desc, 250));
            }
            if (this.isDisabled() && this.disabledReason != null) {
                tooltip.addAll(this.client.field_1772.method_1728((class_5348)class_2561.method_43471((String)this.disabledReason).method_27692(class_124.field_1061), 250));
            }
            if (this.id != null) {
                tooltip.add(class_2561.method_43470((String)this.id).method_27692(class_124.field_1063).method_30937());
            }
            ctx.method_51447(this.client.field_1772, (List)tooltip, mouseX, mouseY);
        }
    }

    public boolean isValueValid() {
        return true;
    }

    @Override
    protected void buildSearchKey(StringBuilder sb) {
        sb.append(this.getTitle().getString());
        class_2561 desc = this.getDescription();
        if (desc != null) {
            sb.append(" ").append(desc.getString());
        }
    }

    @Override
    protected void gatherChildren(ImmutableList.Builder<class_364> children) {
        class_4185 resetButton;
        class_364 element = this.getListener();
        if (element != null) {
            children.add((Object)element);
        }
        if ((resetButton = this.getResetButton()) != null) {
            children.add((Object)resetButton);
        }
    }

    public void save() {
        if (!this.isDisabled()) {
            this.save.accept(this.getValue());
        }
    }

    @Nullable
    public class_364 getListener() {
        return null;
    }

    @Nullable
    public class_4185 getResetButton() {
        return this.resetButton;
    }

    public class_5250 getTitle() {
        return this.title;
    }

    @Nullable
    public class_2561 getDescription() {
        return class_1074.method_4663((String)this.description) ? class_2561.method_43471((String)this.description).method_27692(class_124.field_1080) : null;
    }

    public int getX() {
        return this.x;
    }

    @NotNull
    public final T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    protected void resetValue() {
        this.setValue(this.defaultValue);
    }

    public void enable() {
        this.disabledReason = null;
        this.disabled = false;
    }

    public void disable(@Nullable String reason) {
        this.disabledReason = reason;
        this.disabled = true;
    }

    public final boolean isDisabled() {
        return this.disabled;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    protected abstract void drawValue(class_332 var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);
}

