/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen.tooltip;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.tooltip.EmiTooltip;
import dev.emi.emi.screen.tooltip.EmiTooltipComponent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class RemainderTooltipComponent
implements EmiTooltipComponent {
    public List<Remainder> remainders = Lists.newArrayList();

    public RemainderTooltipComponent(EmiIngredient ingredient) {
        HashMap tools = Maps.newHashMap();
        block0: for (EmiStack emiStack : ingredient.getEmiStacks()) {
            int damage = this.getDamageDelta(emiStack, emiStack.getRemainder());
            if (damage != 0) {
                tools.computeIfAbsent(damage, i -> Lists.newArrayList()).add(emiStack);
                continue;
            }
            for (Remainder remainder : this.remainders) {
                if (!remainder.remainder.isEqual(emiStack.getRemainder())) continue;
                remainder.inputs.add(emiStack);
                continue block0;
            }
            if (emiStack.getRemainder().isEmpty()) continue;
            this.remainders.add(new Remainder(emiStack, emiStack.getRemainder()));
        }
        for (Map.Entry entry : tools.entrySet()) {
            this.remainders.add(new Remainder((List)entry.getValue(), (Integer)entry.getKey()));
        }
    }

    public int method_32661() {
        return 18 * this.remainders.size();
    }

    public int method_32664(class_327 var1) {
        return 54;
    }

    @Override
    public void drawTooltip(EmiDrawContext context, EmiTooltipComponent.TooltipRenderData render) {
        for (int i = 0; i < this.remainders.size(); ++i) {
            Remainder remainder = this.remainders.get(i);
            EmiIngredient input = EmiIngredient.of(remainder.inputs);
            context.drawStack(input, 0, 18 * i, -11);
            if (remainder.damage == 0) {
                context.drawStack(remainder.remainder, 36, 18 * i, -9);
                continue;
            }
            context.drawStack(input, 36, 18 * i, 3);
            class_1799 is = input.getEmiStacks().get(0).getItemStack().method_7972();
            is.method_7974(is.method_7919() - remainder.damage);
            context.raw().method_51432(render.text, is, 36, 18 * i, "");
            context.drawStack(input, 36, 18 * i, -12);
            class_5250 t = remainder.damage > 0 ? EmiPort.literal("+" + remainder.damage, class_124.field_1060) : EmiPort.literal("" + remainder.damage, class_124.field_1061);
            int width = render.text.method_27525((class_5348)t);
            context.push();
            context.matrices().method_46416(0.0f, 0.0f, 200.0f);
            context.drawText((class_2561)t, 42 - width, i * 18);
            context.pop();
        }
    }

    @Override
    public void drawTooltipText(EmiTooltipComponent.TextRenderData text) {
        for (int i = 0; i < this.remainders.size(); ++i) {
            Remainder remainder = this.remainders.get(i);
            boolean chanced = remainder.chance != 1.0f;
            text.draw((class_2561)EmiPort.literal("->"), 20, 5 + i * 18 - (chanced ? 4 : 0), 0xFFFFFF, true);
            if (!chanced) continue;
            class_5250 t = EmiPort.literal(EmiTooltip.TEXT_FORMAT.format(remainder.chance * 100.0f) + "%");
            int tx = text.renderer.method_27525((class_5348)t);
            text.draw((class_2561)t, 27 - tx / 2, 9 + i * 18, (int)class_124.field_1065.method_532(), false);
        }
    }

    private int getDamageDelta(EmiStack stack, EmiStack remainder) {
        if (remainder.isEqual(stack)) {
            return stack.getItemStack().method_7919() - remainder.getItemStack().method_7919();
        }
        return 0;
    }

    private static class Remainder {
        public final List<EmiStack> inputs = Lists.newArrayList();
        public final EmiStack remainder;
        public int damage = 0;
        public float chance = 1.0f;

        public Remainder(EmiStack input, EmiStack remainder) {
            this.inputs.add(input);
            this.remainder = remainder;
            this.chance = remainder.getChance();
        }

        public Remainder(List<EmiStack> inputs, int damage) {
            this.inputs.addAll(inputs);
            this.remainder = EmiStack.EMPTY;
            this.damage = damage;
        }
    }
}

