/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.crafting;

import appeng.api.networking.crafting.CraftingSubmitErrorCode;
import appeng.api.networking.crafting.UnsuitableCpus;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.AESubScreen;
import appeng.client.gui.me.common.ClientDisplaySlot;
import appeng.client.gui.me.crafting.CraftConfirmScreen;
import appeng.core.localization.GuiText;
import appeng.menu.SlotSemantics;
import appeng.menu.me.crafting.CraftConfirmMenu;
import java.util.ArrayList;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class CraftErrorScreen
extends AESubScreen<CraftConfirmMenu, CraftConfirmScreen> {
    public CraftErrorScreen(CraftConfirmScreen parent, CraftingSubmitErrorCode errorCode, Object details) {
        super(parent, "/screens/craft_error.json");
        class_5250 errorText = switch (errorCode) {
            default -> throw new IncompatibleClassChangeError();
            case CraftingSubmitErrorCode.INCOMPLETE_PLAN -> GuiText.CraftErrorIncompletePlan.text();
            case CraftingSubmitErrorCode.NO_CPU_FOUND -> GuiText.CraftErrorNoCpuFound.text();
            case CraftingSubmitErrorCode.NO_SUITABLE_CPU_FOUND -> {
                class_5250 text = GuiText.CraftErrorNoSuitableCpu.text();
                if (details instanceof UnsuitableCpus) {
                    UnsuitableCpus unsuitableCpus = (UnsuitableCpus)details;
                    ArrayList<class_5250> stats = new ArrayList<class_5250>();
                    if (unsuitableCpus.offline() > 0) {
                        stats.add(GuiText.CraftErrorNoSuitableCpuOffline.text(unsuitableCpus.offline()));
                    }
                    if (unsuitableCpus.busy() > 0) {
                        stats.add(GuiText.CraftErrorNoSuitableCpuBusy.text(unsuitableCpus.busy()));
                    }
                    if (unsuitableCpus.tooSmall() > 0) {
                        stats.add(GuiText.CraftErrorNoSuitableCpuTooSmall.text(unsuitableCpus.tooSmall()));
                    }
                    if (unsuitableCpus.excluded() > 0) {
                        stats.add(GuiText.CraftErrorNoSuitableCpuExcluded.text(unsuitableCpus.excluded()));
                    }
                    class_5250 suffix = class_2561.method_43470((String)"(");
                    for (int i = 0; i < stats.size(); ++i) {
                        class_2561 stat = (class_2561)stats.get(i);
                        if (i != 0) {
                            suffix = suffix.method_27693(", ");
                        }
                        suffix = suffix.method_10852(stat);
                    }
                    suffix = suffix.method_27693(")");
                    text = text.method_27693(" ").method_10852((class_2561)suffix);
                }
                yield text;
            }
            case CraftingSubmitErrorCode.CPU_BUSY -> GuiText.CraftErrorCpuBusy.text();
            case CraftingSubmitErrorCode.CPU_OFFLINE -> GuiText.CraftErrorCpuOffline.text();
            case CraftingSubmitErrorCode.CPU_TOO_SMALL -> GuiText.CraftErrorCpuTooSmall.text();
            case CraftingSubmitErrorCode.MISSING_INGREDIENT -> {
                if (details instanceof GenericStack) {
                    GenericStack genericStack = (GenericStack)details;
                    this.addClientSideSlot(new ClientDisplaySlot(genericStack), SlotSemantics.MISSING_INGREDIENT);
                }
                yield GuiText.CraftErrorMissingIngredient.text();
            }
        };
        this.setTextContent("errorText", (class_2561)errorText);
        this.widgets.addButton("replan", (class_2561)GuiText.CraftErrorReplan.text(), () -> {
            this.returnToParent();
            ((CraftConfirmMenu)this.field_2797).replan();
        });
        this.widgets.addButton("retry", (class_2561)GuiText.CraftErrorRetry.text(), () -> {
            this.returnToParent();
            ((CraftConfirmMenu)this.field_2797).startJob();
        });
        this.widgets.addButton("cancel", (class_2561)GuiText.Cancel.text(), () -> {
            this.returnToParent();
            ((CraftConfirmMenu)this.field_2797).goBack();
        });
    }

    @Override
    protected void onReturnToParent() {
        ((CraftConfirmMenu)this.field_2797).clearError();
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
    }
}

