/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.scene;

import appeng.client.guidebook.document.LytSize;
import appeng.client.guidebook.scene.PerspectivePreset;
import appeng.client.guidebook.scene.SavedCameraSettings;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class CameraSettings {
    private float zoom = 1.0f;
    private final Vector4f viewport = new Vector4f();
    private Mode mode = Mode.ORTOGRAPHIC;
    private float rotationX;
    private float rotationY;
    private float rotationZ;
    private final Vector3f rotationCenter = new Vector3f();
    private float offsetX;
    private float offsetY;
    private LytSize viewportSize = LytSize.empty();

    public void setViewportSize(LytSize size) {
        this.viewportSize = size;
        float halfWidth = (float)size.width() / 2.0f;
        float halfHeight = (float)size.height() / 2.0f;
        Vector4f renderViewport = new Vector4f(-halfWidth, -halfHeight, halfWidth, halfHeight);
        this.viewport.set((Vector4fc)renderViewport);
    }

    public LytSize getViewportSize() {
        return this.viewportSize;
    }

    public CameraSettings() {
        this.setPerspectivePreset(PerspectivePreset.ISOMETRIC_NORTH_EAST);
    }

    public void setPerspectivePreset(PerspectivePreset preset) {
        switch (preset) {
            case ISOMETRIC_NORTH_EAST: {
                this.setIsometricYawPitchRoll(225.0f, 30.0f, 0.0f);
                break;
            }
            case ISOMETRIC_NORTH_WEST: {
                this.setIsometricYawPitchRoll(135.0f, 30.0f, 0.0f);
                break;
            }
            case UP: {
                this.setIsometricYawPitchRoll(120.0f, 0.0f, 45.0f);
            }
        }
    }

    public void setIsometricYawPitchRoll(float yawDeg, float pitchDeg, float rollDeg) {
        this.mode = Mode.ORTOGRAPHIC;
        this.rotationY = yawDeg;
        this.rotationX = pitchDeg;
        this.rotationZ = rollDeg;
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
    }

    public float getZoom() {
        return this.zoom;
    }

    public Matrix4f getViewMatrix() {
        Matrix4f result = new Matrix4f();
        result.translate(this.offsetX, this.offsetY, 0.0f);
        result.scale(10.0f * this.zoom, 10.0f * this.zoom, 10.0f * this.zoom);
        if (this.mode == Mode.ORTOGRAPHIC) {
            result.translate(this.rotationCenter.x, this.rotationCenter.y, this.rotationCenter.z);
            result.rotateZ((float)Math.PI / 180 * this.rotationZ);
            result.rotateX((float)Math.PI / 180 * this.rotationX);
            result.rotateY((float)Math.PI / 180 * this.rotationY);
            result.translate(-this.rotationCenter.x, -this.rotationCenter.y, -this.rotationCenter.z);
        }
        return result;
    }

    public Matrix4f getProjectionMatrix() {
        Matrix4f projectionMatrix = new Matrix4f();
        projectionMatrix.setOrtho(this.viewport.x(), this.viewport.z(), this.viewport.y(), this.viewport.w(), -1000.0f, 3000.0f);
        return projectionMatrix;
    }

    public float getRotationX() {
        return this.rotationX;
    }

    public void setRotationX(float rotationX) {
        this.rotationX = rotationX;
    }

    public float getRotationY() {
        return this.rotationY;
    }

    public void setRotationY(float rotationY) {
        this.rotationY = rotationY;
    }

    public float getRotationZ() {
        return this.rotationZ;
    }

    public void setRotationZ(float rotationZ) {
        this.rotationZ = rotationZ;
    }

    public void setRotationCenter(Vector3fc rotationCenter) {
        this.rotationCenter.set(rotationCenter);
    }

    public float getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(float offsetX) {
        this.offsetX = offsetX;
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(float offsetY) {
        this.offsetY = offsetY;
    }

    public SavedCameraSettings save() {
        return new SavedCameraSettings(this.rotationX, this.rotationY, this.rotationZ, this.offsetX, this.offsetY, this.zoom);
    }

    public void restore(SavedCameraSettings settings) {
        this.rotationX = settings.rotationX();
        this.rotationY = settings.rotationY();
        this.rotationZ = settings.rotationZ();
        this.offsetX = settings.offsetX();
        this.offsetY = settings.offsetY();
        this.zoom = settings.zoom();
    }

    private static enum Mode {
        ORTOGRAPHIC,
        PERSPECTIVE;

    }
}

