/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.localization.ItemModText;
import appeng.integration.modules.jei.FluidBlockRenderer;
import appeng.integration.modules.jei.JEIPlugin;
import appeng.integration.modules.jei.ViewBasedCategory;
import appeng.integration.modules.jei.widgets.View;
import appeng.integration.modules.jei.widgets.Widget;
import appeng.integration.modules.jei.widgets.WidgetFactory;
import appeng.recipes.transform.TransformRecipe;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.fabric.constants.FabricTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import net.minecraft.class_5250;

public class TransformCategory
extends ViewBasedCategory<TransformRecipe> {
    public static final RecipeType<TransformRecipe> RECIPE_TYPE = RecipeType.create((String)"ae2", (String)"item_transformation", TransformRecipe.class);
    private final IDrawable icon;
    private final IDrawable background;
    private final IDrawable arrow;
    private final IDrawable slotBackground;
    private final IPlatformFluidHelper<?> fluidHelper;
    private final FluidBlockRenderer fluidRenderer;

    public TransformCategory(IJeiHelpers helpers) {
        super(helpers);
        IGuiHelper guiHelper = helpers.getGuiHelper();
        this.background = guiHelper.createBlankDrawable(130, 62);
        this.slotBackground = guiHelper.createDrawable(JEIPlugin.TEXTURE, 0, 34, 18, 18);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)AEItems.CERTUS_QUARTZ_CRYSTAL_CHARGED.stack());
        this.arrow = guiHelper.createDrawable(JEIPlugin.TEXTURE, 0, 17, 24, 17);
        this.fluidHelper = helpers.getPlatformFluidHelper();
        this.fluidRenderer = new FluidBlockRenderer();
    }

    public RecipeType<TransformRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    protected View getView(final TransformRecipe recipe) {
        final int yOffset = 23;
        return new View(){

            @Override
            public void createWidgets(WidgetFactory factory, List<Widget> widgets) {
                widgets.add(factory.unfilledArrow(25, yOffset));
                widgets.add(factory.unfilledArrow(76, yOffset));
                class_5250 circumstance = recipe.circumstance.isExplosion() ? ItemModText.EXPLOSION.text() : ItemModText.SUBMERGE_IN.text();
                widgets.add(factory.label((float)TransformCategory.this.background.getWidth() / 2.0f, 10.0f, (class_2561)circumstance).bodyText());
            }

            @Override
            public void buildSlots(IRecipeLayoutBuilder builder) {
                int slotIndex = 0;
                int y = 5;
                int x = 5;
                if (recipe.method_8117().size() < 3) {
                    y += (3 - recipe.method_8117().size()) * 18 / 2;
                }
                for (class_1856 input : recipe.method_8117()) {
                    builder.addSlot(RecipeIngredientRole.INPUT, x + 1, y + 1).setSlotName("input" + slotIndex++).setBackground(TransformCategory.this.slotBackground, -1, -1).addIngredients(input);
                    if ((y += 18) < 54) continue;
                    y -= 54;
                    x += 18;
                }
                if (recipe.circumstance.isFluid()) {
                    IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.CATALYST, 56, yOffset + 1).setSlotName("fluid");
                    for (class_3611 fluid : recipe.circumstance.getFluidsForRendering()) {
                        if (!fluid.method_15793(fluid.method_15785())) continue;
                        slot.addFluidStack(fluid, TransformCategory.this.fluidHelper.bucketVolume());
                    }
                    slot.setCustomRenderer((IIngredientType)FabricTypes.FLUID_STACK, (IIngredientRenderer)TransformCategory.this.fluidRenderer);
                } else if (recipe.circumstance.isExplosion()) {
                    ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 56, yOffset + 1).setSlotName("explosion").addItemStack(new class_1799((class_1935)class_2246.field_10375))).addItemStack(AEBlocks.TINY_TNT.stack());
                }
                builder.addSlot(RecipeIngredientRole.OUTPUT, 106, yOffset + 1).setSlotName("output").setBackground(TransformCategory.this.slotBackground, -1, -1).addItemStack(recipe.getResultItem());
            }
        };
    }

    public class_2561 getTitle() {
        return ItemModText.TRANSFORM_CATEGORY.text();
    }
}

