/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.util.AEColor;
import appeng.core.AELog;
import appeng.me.GridConnection;
import appeng.me.GridNode;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_3218;

public class InWorldGridNode
extends GridNode {
    private final class_2338 location;
    private final EnumSet<class_2350> exposedOnSides = EnumSet.noneOf(class_2350.class);

    public <T> InWorldGridNode(class_3218 level, class_2338 location, T owner, IGridNodeListener<T> listener, Set<GridFlags> flags) {
        super(level, owner, listener, flags);
        this.location = location;
    }

    @Override
    protected void findInWorldConnections() {
        this.cleanupConnections();
        class_2338.class_2339 pos = new class_2338.class_2339();
        block0: for (class_2350 direction : this.exposedOnSides) {
            pos.method_25505((class_2382)this.location, direction);
            GridNode adjacentNode = (GridNode)GridHelper.getExposedNode((class_1937)this.getLevel(), (class_2338)pos, direction.method_10153());
            if (adjacentNode == null || !this.hasCompatibleColor(adjacentNode)) continue;
            for (GridConnection c : this.connections) {
                if (!c.isInWorld() || c.getDirection(this) != direction) continue;
                IGridNode os = c.getOtherSide(this);
                if (os == adjacentNode) continue block0;
                AELog.warn("Grid node %s did not disconnect properly and is now replaced with %s", os, adjacentNode);
                c.destroy();
                break;
            }
            GridConnection.create(this, adjacentNode, direction);
        }
    }

    @Override
    public String toString() {
        return super.toString() + " @ " + this.location.method_10263() + "," + this.location.method_10264() + "," + this.location.method_10260();
    }

    private void cleanupConnections() {
        for (IGridConnection connection : this.getConnections()) {
            InWorldGridNode otherInWorldNode;
            if (!connection.isInWorld()) continue;
            class_2350 ourSide = connection.getDirection(this);
            if (!this.isExposedOnSide(ourSide)) {
                connection.destroy();
                continue;
            }
            class_2350 theirSide = ourSide.method_10153();
            IGridNode otherNode = connection.getOtherSide(this);
            if (otherNode instanceof InWorldGridNode && (otherInWorldNode = (InWorldGridNode)otherNode).isExposedOnSide(theirSide) && this.hasCompatibleColor(otherNode)) continue;
            connection.destroy();
        }
    }

    private boolean hasCompatibleColor(IGridNode otherNode) {
        AEColor ourColor = this.getGridColor();
        AEColor theirColor = otherNode.getGridColor();
        return ourColor == AEColor.TRANSPARENT || theirColor == AEColor.TRANSPARENT || ourColor == theirColor;
    }

    public class_2338 getLocation() {
        return this.location;
    }

    public void setExposedOnSides(Set<class_2350> directions) {
        if (!this.exposedOnSides.equals(directions)) {
            this.exposedOnSides.clear();
            this.exposedOnSides.addAll(directions);
            this.updateState();
        }
    }

    public boolean isExposedOnSide(class_2350 side) {
        return this.getMyGrid() != null && this.exposedOnSides.contains(side);
    }
}

