/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cells;

import appeng.api.config.IncludeExclude;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.ISaveProvider;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.items.storage.StorageCellTooltipComponent;
import appeng.me.cells.BasicCellInventory;
import appeng.util.ConfigInventory;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5632;

public class BasicCellHandler
implements ICellHandler {
    public static final BasicCellHandler INSTANCE = new BasicCellHandler();

    @Override
    public boolean isCell(class_1799 is) {
        return BasicCellInventory.isCell(is);
    }

    @Override
    public BasicCellInventory getCellInventory(class_1799 is, ISaveProvider container) {
        return BasicCellInventory.createInventory(is, container);
    }

    public void addCellInformationToTooltip(class_1799 is, List<class_2561> lines) {
        BasicCellInventory handler = this.getCellInventory(is, null);
        if (handler == null) {
            return;
        }
        lines.add(Tooltips.bytesUsed(handler.getUsedBytes(), handler.getTotalBytes()));
        lines.add(Tooltips.typesUsed(handler.getStoredItemTypes(), handler.getTotalItemTypes()));
        if (handler.isPreformatted()) {
            class_5250 list = (handler.getPartitionListMode() == IncludeExclude.WHITELIST ? GuiText.Included : GuiText.Excluded).text();
            if (handler.isFuzzy()) {
                lines.add((class_2561)GuiText.Partitioned.withSuffix(" - ").method_10852((class_2561)list).method_27693(" ").method_10852((class_2561)GuiText.Fuzzy.text()));
            } else {
                lines.add((class_2561)GuiText.Partitioned.withSuffix(" - ").method_10852((class_2561)list).method_27693(" ").method_10852((class_2561)GuiText.Precise.text()));
            }
        }
    }

    public Optional<class_5632> getTooltipImage(class_1799 is) {
        boolean hasMoreContent;
        ArrayList<GenericStack> content;
        BasicCellInventory handler = this.getCellInventory(is, null);
        if (handler == null) {
            return Optional.empty();
        }
        ArrayList<class_1799> upgradeStacks = new ArrayList<class_1799>();
        if (AEConfig.instance().isTooltipShowCellUpgrades()) {
            for (class_1799 upgrade : handler.getUpgradesInventory()) {
                upgradeStacks.add(upgrade);
            }
        }
        if (AEConfig.instance().isTooltipShowCellContent()) {
            content = new ArrayList();
            int maxCountShown = AEConfig.instance().getTooltipMaxCellContentShown();
            KeyCounter availableStacks = handler.getAvailableStacks();
            for (Object2LongMap.Entry<AEKey> entry : availableStacks) {
                content.add(new GenericStack((AEKey)entry.getKey(), entry.getLongValue()));
            }
            if (content.size() < maxCountShown && handler.getPartitionListMode() == IncludeExclude.WHITELIST) {
                ConfigInventory config = handler.getConfigInventory();
                for (int i = 0; i < config.size(); ++i) {
                    AEKey what = config.getKey(i);
                    if (what != null && availableStacks.get(what) <= 0L) {
                        content.add(new GenericStack(what, 0L));
                    }
                    if (content.size() > maxCountShown) break;
                }
            }
            content.sort(Comparator.comparingLong(GenericStack::amount).reversed());
            boolean bl = hasMoreContent = content.size() > maxCountShown;
            if (content.size() > maxCountShown) {
                content.subList(maxCountShown, content.size()).clear();
            }
        } else {
            hasMoreContent = false;
            content = Collections.emptyList();
        }
        return Optional.of(new StorageCellTooltipComponent(upgradeStacks, content, hasMoreContent, true));
    }
}

