/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testplots;

import appeng.api.config.Actionable;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import appeng.blockentity.crafting.PatternProviderBlockEntity;
import appeng.blockentity.misc.InscriberBlockEntity;
import appeng.blockentity.storage.SkyChestBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.items.storage.CreativeCellItem;
import appeng.me.helpers.BaseActionSource;
import appeng.menu.AutoCraftingMenu;
import appeng.server.testplots.TestPlot;
import appeng.server.testworld.DriveBuilder;
import appeng.server.testworld.PlotBuilder;
import appeng.server.testworld.PlotTestHelper;
import appeng.server.testworld.TestCraftingJob;
import appeng.util.inv.AppEngInternalInventory;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3955;
import net.minecraft.class_3956;

public final class AutoCraftingTestPlots {
    private AutoCraftingTestPlots() {
    }

    @TestPlot(value="autocrafting_testplot")
    public static void create(PlotBuilder plot) {
        plot.creativeEnergyCell("4 -1 4");
        plot.cable("4 0 [1,5]");
        plot.cable("[3,6] 0 1");
        plot.block("[4,5] [0,1] [4,5]", AEBlocks.CONTROLLER);
        AutoCraftingTestPlots.craftingCube(plot.offset(1, 0, 1));
        plot.cable("[6,8] 0 5");
        PlotBuilder assemblerStack = plot.offset(8, 1, 5);
        for (int i = 0; i < 8; ++i) {
            AutoCraftingTestPlots.assemblerFlower(assemblerStack.offset(0, i * 3, 0));
        }
        plot.blockEntity("7 0 1", AEBlocks.DRIVE, drive -> {
            drive.getInternalInventory().addItems(AEItems.ITEM_CELL_64K.stack());
            drive.getInternalInventory().addItems(AEItems.ITEM_CELL_64K.stack());
            drive.getInternalInventory().addItems(AEItems.FLUID_CELL_64K.stack());
            drive.getInternalInventory().addItems(AEItems.FLUID_CELL_64K.stack());
            drive.getInternalInventory().addItems(CreativeCellItem.ofItems(new class_1935[]{class_1802.field_8725}));
            drive.getInternalInventory().addItems(CreativeCellItem.ofFluids(new class_3611[]{class_3612.field_15908}));
        });
        plot.part("6 0 1", class_2350.field_11043, AEParts.PATTERN_ENCODING_TERMINAL, term -> {
            InternalInventory inv = term.getLogic().getBlankPatternInv();
            inv.addItems(AEItems.BLANK_PATTERN.stack(64));
        });
        plot.part("5 0 1", class_2350.field_11043, AEParts.PATTERN_ACCESS_TERMINAL);
        plot.part("4 0 1", class_2350.field_11043, AEParts.TERMINAL);
        plot.part("3 0 1", class_2350.field_11043, AEParts.CRAFTING_TERMINAL);
        AutoCraftingTestPlots.buildObsidianCrafting(plot.offset(3, 0, 5));
        AutoCraftingTestPlots.buildChestCraftingExport(plot.offset(5, 0, 7));
        AutoCraftingTestPlots.buildWaterEmittingSource(plot.offset(5, 0, 9));
        plot.cable("4 0 [6,9]", AEParts.SMART_DENSE_CABLE);
        plot.afterGridInitAt("4 0 4", (grid, gridNode) -> {
            class_3218 level = gridNode.getLevel();
            ArrayList<class_1799> patterns = new ArrayList<class_1799>();
            patterns.add(AutoCraftingTestPlots.encodeCraftingPattern(level, new Object[]{class_1802.field_8118, class_1802.field_8118, null, class_1802.field_8118, class_1802.field_22031, null, null, null, null}, true, false));
            patterns.add(AutoCraftingTestPlots.encodeCraftingPattern(level, new Object[]{class_1802.field_8118, class_1802.field_8118, class_1802.field_8118, class_1802.field_8118, null, class_1802.field_8118, class_1802.field_22031, class_1802.field_8118, class_1802.field_8118}, true, false));
            patterns.add(PatternDetailsHelper.encodeProcessingPattern(new GenericStack[]{new GenericStack(AEFluidKey.of((class_3611)class_3612.field_15910), 81000L), GenericStack.fromItemStack(new class_1799((class_1935)class_1802.field_8725))}, new GenericStack[]{new GenericStack(AEFluidKey.of((class_3611)class_3612.field_15910), 81000L)}));
            MEStorage networkInv = grid.getStorageService().getInventory();
            networkInv.insert(AEItemKey.of((class_1935)class_1802.field_8118), 83L, Actionable.MODULATE, new BaseActionSource());
            block0: for (PatternProviderBlockEntity provider : grid.getMachines(PatternProviderBlockEntity.class)) {
                while (!patterns.isEmpty()) {
                    class_1799 pattern = (class_1799)patterns.get(0);
                    if (!provider.getLogic().getPatternInv().addItems(pattern).method_7960()) continue block0;
                    patterns.remove(0);
                }
            }
        });
    }

    private static void buildChestCraftingExport(PlotBuilder plot) {
        plot.cable("0 0 0").part(class_2350.field_11035, AEParts.EXPORT_BUS, eb -> {
            eb.getUpgrades().addItems(new class_1799(AEItems.CRAFTING_CARD));
            eb.getConfig().insert(0, AEItemKey.of((class_1935)class_1802.field_8106), 1L, Actionable.MODULATE);
        });
        plot.block("0 0 1", class_2246.field_10034);
    }

    private static void buildWaterEmittingSource(PlotBuilder plot) {
        plot.cable("0 0 0").part(class_2350.field_11035, AEParts.QUARTZ_FIBER);
        plot.cable("0 0 1").part(class_2350.field_11043, AEParts.TOGGLE_BUS);
        plot.cable("0 1 0");
        plot.cable("0 1 1").craftingEmitter(class_2350.field_11033, (class_3611)class_3612.field_15910).part(class_2350.field_11035, AEParts.INTERFACE);
        plot.cable("0 1 2").part(class_2350.field_11043, AEParts.STORAGE_BUS, storageBus -> storageBus.getConfig().insert(0, AEFluidKey.of((class_3611)class_3612.field_15910), 1L, Actionable.MODULATE));
        plot.cable("0 0 2").part(class_2350.field_11033, AEParts.ANNIHILATION_PLANE);
        plot.block("[-1,1] -1 2", class_2246.field_10382);
    }

    private static void buildObsidianCrafting(PlotBuilder plot) {
        plot.blockEntity("0 0 0", AEBlocks.PATTERN_PROVIDER, provider -> {
            class_1799 pattern = PatternDetailsHelper.encodeProcessingPattern(new GenericStack[]{new GenericStack(AEFluidKey.of((class_3611)class_3612.field_15908), 81000L)}, new GenericStack[]{new GenericStack(AEItemKey.of((class_1935)class_1802.field_8281), 1L)});
            provider.getLogic().getPatternInv().addItems(pattern);
        });
        plot.cable("-1 0 0").part(class_2350.field_11034, AEParts.INTERFACE).part(class_2350.field_11039, AEParts.FORMATION_PLANE, plane -> plane.getConfig().insert(0, AEFluidKey.of((class_3611)class_3612.field_15908), 1L, Actionable.MODULATE));
        plot.cable("-2 1 0").part(class_2350.field_11033, AEParts.ANNIHILATION_PLANE);
        plot.cable("-1 1 0").part(class_2350.field_11033, AEParts.QUARTZ_FIBER);
        plot.cable("0 1 0").part(class_2350.field_11033, AEParts.STORAGE_BUS, part -> part.getConfig().insert(0, AEItemKey.of((class_1935)class_1802.field_8281), 1L, Actionable.MODULATE)).part(class_2350.field_11034, AEParts.QUARTZ_FIBER);
        plot.block("-3 0 [-2,0]", class_2246.field_10445);
        plot.block("-1 0 [-2,-1]", class_2246.field_10445);
        plot.block("-2 0 1", class_2246.field_10445);
        plot.block("-2 0 -2", class_2246.field_10382);
    }

    private static class_1799 encodeCraftingPattern(class_3218 level, Object[] ingredients, boolean allowSubstitutions, boolean allowFluidSubstitutions) {
        class_1799[] stacks = (class_1799[])Arrays.stream(ingredients).map(in -> {
            if (in instanceof class_1935) {
                class_1935 itemLike = (class_1935)in;
                return new class_1799(itemLike);
            }
            if (in instanceof class_1799) {
                class_1799 itemStack = (class_1799)in;
                return itemStack;
            }
            if (in == null) {
                return class_1799.field_8037;
            }
            throw new IllegalArgumentException("Unsupported argument: " + in);
        }).toArray(class_1799[]::new);
        class_1715 c = new class_1715((class_1703)new AutoCraftingMenu(), 3, 3);
        for (int i = 0; i < stacks.length; ++i) {
            c.method_5447(i, stacks[i]);
        }
        class_3955 recipe = (class_3955)level.method_8433().method_8132(class_3956.field_17545, (class_1263)c, (class_1937)level).orElseThrow();
        class_1799 result = recipe.method_8116((class_1263)c, level.method_30349());
        return PatternDetailsHelper.encodeCraftingPattern(recipe, stacks, result, allowSubstitutions, allowFluidSubstitutions);
    }

    private static void craftingCube(PlotBuilder plot) {
        plot.block("[-1,1] [0,2] [-1,1]", AEBlocks.CRAFTING_STORAGE_64K);
        plot.block("-1 2 -1", AEBlocks.CRAFTING_STORAGE_16K);
        plot.block("1 2 -1", AEBlocks.CRAFTING_STORAGE_4K);
        plot.block("-1 2 1", AEBlocks.CRAFTING_STORAGE_1K);
        plot.block("[-1,1] 0 [-1,1]", AEBlocks.CRAFTING_ACCELERATOR);
        plot.block("0 1 -1", AEBlocks.CRAFTING_MONITOR);
    }

    private static void assemblerFlower(PlotBuilder plot) {
        plot.block("0 0 0", AEBlocks.PATTERN_PROVIDER);
        plot.block("-1 0 0", AEBlocks.MOLECULAR_ASSEMBLER);
        plot.block("1 0 0", AEBlocks.MOLECULAR_ASSEMBLER);
        plot.block("0 0 1", AEBlocks.MOLECULAR_ASSEMBLER);
        plot.block("0 0 -1", AEBlocks.MOLECULAR_ASSEMBLER);
        plot.block("0 -1 0", AEBlocks.MOLECULAR_ASSEMBLER);
        plot.block("0 1 0", AEBlocks.MOLECULAR_ASSEMBLER);
    }

    @TestPlot(value="pattern_provider_faces_round_robin")
    public static void patternProviderFacesRoundRobin(PlotBuilder plot) {
        class_2338[] inscriberPos = new class_2338[]{new class_2338(-1, 0, -3), new class_2338(1, 0, -3)};
        AutoCraftingTestPlots.craftingCube(plot);
        plot.cable("0 0 -2");
        plot.blockEntity("0 0 -3", AEBlocks.PATTERN_PROVIDER, provider -> {
            class_1799 pattern = PatternDetailsHelper.encodeProcessingPattern(new GenericStack[]{GenericStack.fromItemStack(AEItems.CERTUS_QUARTZ_CRYSTAL.stack())}, new GenericStack[]{GenericStack.fromItemStack(AEItems.CERTUS_QUARTZ_DUST.stack())});
            provider.getLogic().getPatternInv().addItems(pattern);
        });
        for (class_2338 pos : inscriberPos) {
            plot.blockEntity(pos, AEBlocks.INSCRIBER, inscriber -> inscriber.getConfigManager().putSetting(Settings.AUTO_EXPORT, YesNo.YES));
        }
        plot.cable("0 0 -4");
        DriveBuilder db = plot.drive(new class_2338(0, 0, -5));
        db.addCreativeCell().add(AEItems.CERTUS_QUARTZ_CRYSTAL);
        db.addItemCell64k();
        plot.cable("0 1 -5").part(class_2350.field_11043, AEParts.CRAFTING_TERMINAL);
        plot.creativeEnergyCell("0 -1 -5");
        plot.test(helper -> {
            TestCraftingJob craftingJob = new TestCraftingJob((PlotTestHelper)((Object)helper), class_2338.field_10980, AEItemKey.of(AEItems.CERTUS_QUARTZ_DUST), 10L);
            helper.method_36041().method_36079(craftingJob::tickUntilStarted).method_36076(1).method_36085(() -> {
                for (class_2338 pos : inscriberPos) {
                    InscriberBlockEntity inscriber = (InscriberBlockEntity)helper.method_36014(pos);
                    helper.check(inscriber.getInternalInventory().getStackInSlot(2).method_7947() == 5, "Inscriber should have 5 = 10/2 items", pos);
                }
            }).method_36075();
        });
    }

    @TestPlot(value="processing_pattern_inputs_unstacking")
    public static void processingPatternInputsUnstacking(PlotBuilder plot) {
        class_2338 chestPos = new class_2338(1, 0, -3);
        AutoCraftingTestPlots.craftingCube(plot);
        plot.cable("0 0 -2");
        plot.blockEntity("0 0 -3", AEBlocks.PATTERN_PROVIDER, provider -> {
            class_1799 pattern = PatternDetailsHelper.encodeProcessingPattern(new GenericStack[]{GenericStack.fromItemStack(new class_1799((class_1935)class_1802.field_20391)), GenericStack.fromItemStack(new class_1799((class_1935)class_1802.field_20391)), GenericStack.fromItemStack(new class_1799((class_1935)class_1802.field_8477)), GenericStack.fromItemStack(new class_1799((class_1935)class_1802.field_20391))}, new GenericStack[]{GenericStack.fromItemStack(AEItems.CERTUS_QUARTZ_DUST.stack())});
            provider.getLogic().getPatternInv().addItems(pattern);
        });
        plot.blockEntity(chestPos, AEBlocks.SKY_STONE_CHEST, skyChest -> {
            AppEngInternalInventory inv = (AppEngInternalInventory)skyChest.getInternalInventory();
            for (int i = 0; i < inv.size(); ++i) {
                inv.setMaxStackSize(i, 1);
            }
        });
        plot.cable("0 0 -4");
        DriveBuilder db = plot.drive(new class_2338(0, 0, -5));
        db.addCreativeCell().add((class_1935)class_1802.field_20391).add((class_1935)class_1802.field_8477);
        db.addItemCell64k();
        plot.cable("0 1 -5").part(class_2350.field_11043, AEParts.CRAFTING_TERMINAL);
        plot.creativeEnergyCell("0 -1 -5");
        plot.test(helper -> {
            TestCraftingJob craftingJob = new TestCraftingJob((PlotTestHelper)((Object)helper), class_2338.field_10980, AEItemKey.of(AEItems.CERTUS_QUARTZ_DUST), 1L);
            helper.method_36041().method_36079(craftingJob::tickUntilStarted).method_36076(1).method_36085(() -> {
                SkyChestBlockEntity chest = (SkyChestBlockEntity)helper.method_36014(chestPos);
                InternalInventory inv = chest.getInternalInventory();
                for (int i = 0; i < 4; ++i) {
                    helper.check(inv.getStackInSlot(i).method_7947() == 1, "Chest should have 1 item in slot " + i, chestPos);
                }
                helper.check(inv.getStackInSlot(0).method_31574(class_1802.field_20391), "Chest should have stone in slot 0", chestPos);
                helper.check(inv.getStackInSlot(1).method_31574(class_1802.field_20391), "Chest should have stone in slot 1", chestPos);
                helper.check(inv.getStackInSlot(2).method_31574(class_1802.field_8477), "Chest should have diamond in slot 2", chestPos);
                helper.check(inv.getStackInSlot(3).method_31574(class_1802.field_20391), "Chest should have stone in slot 3", chestPos);
            }).method_36075();
        });
    }

    @TestPlot(value="regression_7288")
    public static void testCraftingCpuDupe(PlotBuilder plot) {
        AutoCraftingTestPlots.craftingCube(plot);
        plot.cable("0 0 -2");
        plot.blockEntity("0 0 -3", AEBlocks.PATTERN_PROVIDER, provider -> {
            class_1799 pattern = PatternDetailsHelper.encodeProcessingPattern(new GenericStack[]{GenericStack.fromItemStack(new class_1799((class_1935)class_1802.field_8477))}, new GenericStack[]{GenericStack.fromItemStack(new class_1799((class_1935)class_1802.field_8600))});
            provider.getLogic().getPatternInv().addItems(pattern);
        });
        plot.cable("0 0 -4");
        DriveBuilder db = plot.drive(new class_2338(0, 0, -5));
        db.addItemCell64k().add((class_1935)class_1802.field_8477, 1L);
        plot.cable("0 1 -5").part(class_2350.field_11043, AEParts.CRAFTING_TERMINAL);
        plot.creativeEnergyCell("0 -1 -5");
        plot.test(helper -> {
            TestCraftingJob craftingJob = new TestCraftingJob((PlotTestHelper)((Object)helper), class_2338.field_10980, AEItemKey.of((class_1935)class_1802.field_8600), 1L);
            helper.method_36041().method_36079(craftingJob::tickUntilStarted).method_36076(1).method_36085(() -> {
                helper.method_36044(new class_2338(0, 0, -2));
                helper.method_36044(new class_2338(0, 0, -1));
                helper.method_35970(class_1802.field_8477, new class_2338(0, 0, 0), 3.0, 1);
            }).method_36075();
        });
    }
}

