/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.entity;

import com.ninni.spawn.SpawnTags;
import com.ninni.spawn.entity.HamsterOpenContainer;
import com.ninni.spawn.entity.variant.HamsterVariant;
import com.ninni.spawn.registry.SpawnCriteriaTriggers;
import com.ninni.spawn.registry.SpawnEntityType;
import com.ninni.spawn.registry.SpawnSoundEvents;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1335;
import net.minecraft.class_1338;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1451;
import net.minecraft.class_1493;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1890;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6067;
import net.minecraft.class_7248;
import org.jetbrains.annotations.Nullable;

public class Hamster
extends class_1321
implements class_6067,
class_1265,
class_7248 {
    public static final class_2940<Integer> VARIANT = class_2945.method_12791(Hamster.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> PUFF_TICKS = class_2945.method_12791(Hamster.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Byte> DATA_FLAGS_ID = class_2945.method_12791(Hamster.class, (class_2941)class_2943.field_13319);
    static final Predicate<class_1542> ALLOWED_ITEMS = itemEntity -> !itemEntity.method_6977() && itemEntity.method_5805();
    public final class_1277 inventory = new class_1277(12);

    public Hamster(class_1299<? extends class_1321> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6207 = new HamsterMoveControl();
        this.method_5952(true);
    }

    public class_1315 method_5943(class_5425 serverLevelAccessor, class_1266 difficultyInstance, class_3730 mobSpawnType, @Nullable class_1315 spawnGroupData, @Nullable class_2487 compoundTag) {
        HamsterVariant[] variants = HamsterVariant.values();
        HamsterVariant variant = (HamsterVariant)((Object)class_156.method_27173((Object[])variants, (class_5819)serverLevelAccessor.method_8409()));
        this.setVariant(variant);
        return super.method_5943(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    protected void method_5959() {
        this.field_6185.method_6277(0, (class_1352)new class_1400((class_1308)this, Hamster.class, false, this::getTerritorialTarget));
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(2, (class_1352)new class_1374((class_1314)this, 1.2));
        this.field_6201.method_6277(3, (class_1352)new class_1338((class_1314)this, class_1493.class, 24.0f, 1.1, 1.3));
        this.field_6201.method_6277(3, (class_1352)new class_1338((class_1314)this, class_1451.class, 24.0f, 1.1, 1.3));
        this.field_6201.method_6277(4, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new class_1366((class_1314)this, 1.0, true));
        this.field_6201.method_6277(6, (class_1352)new class_1350((class_1321)this, 1.0, 7.0f, 2.0f, false));
        this.field_6201.method_6277(7, (class_1352)new class_1391((class_1314)this, 1.2, class_1856.method_8106(SpawnTags.HAMSTER_TEMPTS), false));
        this.field_6201.method_6277(9, (class_1352)new HamsterSearchForItemsGoal());
        this.field_6201.method_6277(10, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(11, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(12, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(13, (class_1352)new StandGoal());
    }

    private boolean getTerritorialTarget(class_1309 livingEntity) {
        Hamster hamster;
        return livingEntity instanceof Hamster && (hamster = (Hamster)livingEntity).method_6181() && !hamster.method_6172() && !this.method_6172() && this.method_6181() && hamster.method_6139() == this.method_6139();
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23721, 1.0).method_26868(class_5134.field_23716, 6.0);
    }

    public boolean method_6481(class_1799 itemStack) {
        return itemStack.method_31573(SpawnTags.HAMSTER_TEMPTS);
    }

    public class_1269 method_5992(class_1657 player, class_1268 interactionHand) {
        class_1799 itemStack = player.method_5998(interactionHand);
        if (!this.method_37908().field_9236 && player.method_21823() && player instanceof HamsterOpenContainer && this.method_6171((class_1309)player) && !this.method_6109()) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                SpawnCriteriaTriggers.OPEN_HAMSTER_INVENTORY.trigger(serverPlayer);
            }
            this.method_6722(player);
            return class_1269.field_5812;
        }
        if (this.method_37908().field_9236) {
            boolean bl = this.method_6171((class_1309)player) || this.method_6181() || itemStack.method_31573(SpawnTags.HAMSTER_FEEDS) && !this.method_6181();
            return bl ? class_1269.field_21466 : class_1269.field_5811;
        }
        if (this.method_6181()) {
            if (this.method_6481(itemStack) && this.method_6032() < this.method_6063()) {
                if (!player.method_31549().field_7477) {
                    itemStack.method_7934(1);
                }
                this.method_6025(4.0f);
                return class_1269.field_5812;
            }
            class_1269 interactionResult = super.method_5992(player, interactionHand);
            if (interactionResult.method_23665() && !this.method_6109() || !this.method_6171((class_1309)player)) {
                return interactionResult;
            }
            this.method_24346(!this.method_24345());
            this.field_6282 = false;
            this.field_6189.method_6340();
            this.method_5980(null);
            return class_1269.field_5812;
        }
        if (!itemStack.method_31573(SpawnTags.HAMSTER_FEEDS)) {
            return super.method_5992(player, interactionHand);
        }
        if (!player.method_31549().field_7477) {
            this.method_5783(SpawnSoundEvents.HAMSTER_EAT, 1.0f, 1.0f);
            itemStack.method_7934(1);
        }
        if (this.field_5974.method_43048(3) == 0) {
            this.method_5783(SpawnSoundEvents.HAMSTER_EAT, 1.0f, 1.0f);
            this.method_6170(player);
            this.field_6189.method_6340();
            this.method_5980(null);
            this.method_24346(true);
            this.method_37908().method_8421((class_1297)this, (byte)7);
            return class_1269.field_5812;
        }
        this.method_37908().method_8421((class_1297)this, (byte)6);
        return class_1269.field_5812;
    }

    public float getPuffTicks() {
        return ((Float)this.field_6011.method_12789(PUFF_TICKS)).floatValue();
    }

    public void method_5773() {
        if (!this.method_37908().field_9236) {
            float amount = 0.0f;
            for (class_1799 itemStack : this.method_35199().field_5828) {
                if (itemStack.method_7960()) {
                    amount -= 0.1f;
                }
                amount += 0.1f;
            }
            if (amount > 0.8f) {
                amount = 0.8f;
            }
            this.field_6011.method_12778(PUFF_TICKS, (Object)Float.valueOf(amount));
        }
        super.method_5773();
    }

    public class_1277 method_35199() {
        return this.inventory;
    }

    protected void method_5949(class_1542 itemEntity) {
        if (this.method_35199().method_27070(itemEntity.method_6983())) {
            this.method_5783(SpawnSoundEvents.HAMSTER_EAT, 1.0f, 1.0f);
        }
        class_6067.method_43544((class_1308)this, (class_6067)this, (class_1542)itemEntity);
    }

    protected void method_16078() {
        super.method_16078();
        this.inventory.method_24514().forEach(arg_0 -> ((Hamster)this).method_5775(arg_0));
        class_1799 itemStack = this.method_6118(class_1304.field_6173);
        if (!itemStack.method_7960() && !class_1890.method_8221((class_1799)itemStack)) {
            this.method_5775(itemStack);
            this.method_5673(class_1304.field_6173, class_1799.field_8037);
        }
    }

    protected int method_23329(float f, float g) {
        return super.method_23329(f, g) - 10;
    }

    boolean canMove() {
        return !this.isStanding() && !this.method_6172() && !this.method_6062();
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, (Object)HamsterVariant.RUSSIAN.id());
        this.field_6011.method_12784(DATA_FLAGS_ID, (Object)0);
        this.field_6011.method_12784(PUFF_TICKS, (Object)Float.valueOf(0.0f));
    }

    public void method_6173(boolean bl) {
        super.method_6173(bl);
        if (bl) {
            this.method_5996(class_5134.field_23716).method_6192(12.0);
            this.method_6033(20.0f);
        } else {
            this.method_5996(class_5134.field_23716).method_6192(6.0);
        }
    }

    public boolean isStanding() {
        return this.getFlag(1);
    }

    public void setStanding(boolean bl) {
        this.setFlag(1, bl);
    }

    private void setFlag(int i, boolean bl) {
        if (bl) {
            this.field_6011.method_12778(DATA_FLAGS_ID, (Object)((byte)((Byte)this.field_6011.method_12789(DATA_FLAGS_ID) | i)));
        } else {
            this.field_6011.method_12778(DATA_FLAGS_ID, (Object)((byte)((Byte)this.field_6011.method_12789(DATA_FLAGS_ID) & ~i)));
        }
    }

    private boolean getFlag(int i) {
        return ((Byte)this.field_6011.method_12789(DATA_FLAGS_ID) & i) != 0;
    }

    public HamsterVariant getVariant() {
        return HamsterVariant.byId((Integer)this.field_6011.method_12789(VARIANT));
    }

    public void setVariant(HamsterVariant variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.id());
    }

    public void method_5453(class_1263 container) {
    }

    public void method_6722(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            ((HamsterOpenContainer)serverPlayer).openHamsterInventory(this, (class_1263)this.method_35199());
        }
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return SpawnSoundEvents.HAMSTER_HURT;
    }

    @Nullable
    protected class_3414 method_5994() {
        return this.isStanding() ? SpawnSoundEvents.HAMSTER_AMBIENT_CALL : SpawnSoundEvents.HAMSTER_AMBIENT;
    }

    @Nullable
    protected class_3414 method_6002() {
        return SpawnSoundEvents.HAMSTER_DEATH;
    }

    protected void method_5712(class_2338 blockPos, class_2680 blockState) {
        this.method_5783(SpawnSoundEvents.HAMSTER_STEP, 0.15f, 1.0f);
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        this.method_46399(compoundTag);
        compoundTag.method_10569("Variant", this.getVariant().id());
        compoundTag.method_10556("Standing", this.isStanding());
        class_2499 listTag = new class_2499();
        for (int i = 2; i < this.inventory.method_5439(); ++i) {
            class_1799 itemStack = this.inventory.method_5438(i);
            if (itemStack.method_7960()) continue;
            class_2487 compoundTag2 = new class_2487();
            compoundTag2.method_10567("Slot", (byte)i);
            itemStack.method_7953(compoundTag2);
            listTag.add((Object)compoundTag2);
        }
        compoundTag.method_10566("Items", (class_2520)listTag);
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.method_46400(compoundTag);
        this.setVariant(HamsterVariant.byId(compoundTag.method_10550("Variant")));
        this.setStanding(compoundTag.method_10577("Standing"));
        class_2499 listTag = compoundTag.method_10554("Items", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            class_2487 compoundTag2 = listTag.method_10602(i);
            int j = compoundTag2.method_10571("Slot") & 0xFF;
            if (j < 2 || j >= this.inventory.method_5439()) continue;
            this.inventory.method_5447(j, class_1799.method_7915((class_2487)compoundTag2));
        }
    }

    public static boolean canSpawn(class_1299<Hamster> hamsterEntityType, class_5425 world, class_3730 mobSpawnType, class_2338 pos, class_5819 randomSource) {
        return world.method_8320(pos.method_10074()).method_26164(class_3481.field_35567) && class_1429.method_39448((class_1920)world, (class_2338)pos);
    }

    @Nullable
    public Hamster getBreedOffspring(class_3218 serverLevel, class_1296 ageableMob) {
        Hamster hamster = (Hamster)SpawnEntityType.HAMSTER.method_5883((class_1937)serverLevel);
        if (hamster != null && ageableMob instanceof Hamster) {
            Hamster hamster2 = (Hamster)ageableMob;
            if (this.field_5974.method_43056()) {
                hamster.setVariant(this.getVariant());
            } else {
                hamster.setVariant(hamster2.getVariant());
            }
            if (this.method_6181()) {
                hamster.method_6174(this.method_6139());
                hamster.method_6173(true);
            }
        }
        return hamster;
    }

    class HamsterMoveControl
    extends class_1335 {
        public HamsterMoveControl() {
            super((class_1308)Hamster.this);
        }

        public void method_6240() {
            if (Hamster.this.canMove()) {
                super.method_6240();
            }
        }
    }

    class HamsterSearchForItemsGoal
    extends class_1352 {
        public HamsterSearchForItemsGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (!Hamster.this.method_6118(class_1304.field_6173).method_7960()) {
                return false;
            }
            if (Hamster.this.method_5968() != null || Hamster.this.method_6065() != null) {
                return false;
            }
            if (!Hamster.this.canMove()) {
                return false;
            }
            if (Hamster.this.method_6051().method_43048(HamsterSearchForItemsGoal.method_38848((int)10)) != 0) {
                return false;
            }
            List list = Hamster.this.method_37908().method_8390(class_1542.class, Hamster.this.method_5829().method_1009(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            return !list.isEmpty() && Hamster.this.method_6118(class_1304.field_6173).method_7960();
        }

        public void method_6268() {
            List list = Hamster.this.method_37908().method_8390(class_1542.class, Hamster.this.method_5829().method_1009(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            class_1799 itemStack = Hamster.this.method_6118(class_1304.field_6173);
            if (itemStack.method_7960() && !list.isEmpty()) {
                Hamster.this.method_5942().method_6335((class_1297)list.get(0), 1.0);
            }
        }

        public void method_6269() {
            List list = Hamster.this.method_37908().method_8390(class_1542.class, Hamster.this.method_5829().method_1009(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            if (!list.isEmpty()) {
                Hamster.this.method_5942().method_6335((class_1297)list.get(0), (double)1.2f);
            }
        }
    }

    class StandGoal
    extends class_1352 {
        private double relX;
        private double relZ;
        private int lookTime;
        private int looksRemaining;

        public StandGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return Hamster.this.method_6065() == null && Hamster.this.method_6051().method_43057() < 0.02f && Hamster.this.method_5968() == null && Hamster.this.method_5942().method_6357();
        }

        public boolean method_6266() {
            return this.looksRemaining > 0;
        }

        public void method_6269() {
            this.resetLook();
            this.looksRemaining = 2 + Hamster.this.method_6051().method_43048(3);
            Hamster.this.setStanding(true);
            Hamster.this.method_5942().method_6340();
        }

        public void method_6270() {
            Hamster.this.setStanding(false);
        }

        public void method_6268() {
            --this.lookTime;
            if (this.lookTime <= 0) {
                --this.looksRemaining;
                this.resetLook();
            }
            Hamster.this.method_5988().method_6230(Hamster.this.method_23317() + this.relX, Hamster.this.method_23320(), Hamster.this.method_23321() + this.relZ, (float)Hamster.this.method_5986(), (float)Hamster.this.method_5978());
        }

        private void resetLook() {
            double d = Math.PI * 2 * Hamster.this.method_6051().method_43058();
            this.relX = Math.cos(d);
            this.relZ = Math.sin(d);
            this.lookTime = this.method_38847(80 + Hamster.this.method_6051().method_43048(20));
        }
    }
}

