/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.registry;

import com.google.common.reflect.Reflection;
import com.ninni.spawn.SpawnTags;
import com.ninni.spawn.client.inventory.HamsterInventoryMenu;
import com.ninni.spawn.client.inventory.HamsterInventoryScreen;
import com.ninni.spawn.client.particles.TunaEggParticle;
import com.ninni.spawn.client.renderer.entity.AnglerFishRenderer;
import com.ninni.spawn.client.renderer.entity.AntRenderer;
import com.ninni.spawn.client.renderer.entity.HamsterRenderer;
import com.ninni.spawn.client.renderer.entity.SeahorseRenderer;
import com.ninni.spawn.client.renderer.entity.SnailRenderer;
import com.ninni.spawn.client.renderer.entity.TunaEggRenderer;
import com.ninni.spawn.client.renderer.entity.TunaRenderer;
import com.ninni.spawn.entity.Hamster;
import com.ninni.spawn.registry.SpawnBlocks;
import com.ninni.spawn.registry.SpawnEntityModelLayers;
import com.ninni.spawn.registry.SpawnEntityType;
import com.ninni.spawn.registry.SpawnItems;
import com.ninni.spawn.registry.SpawnParticles;
import com.ninni.spawn.registry.SpawnPlacedFeatures;
import java.util.Optional;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.biome.v1.BiomeModificationContext;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.registry.CompostingChanceRegistry;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2396;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_5786;
import net.minecraft.class_638;
import net.minecraft.class_6819;
import net.minecraft.class_746;

public class SpawnVanillaIntegration {
    public static final class_2960 OPEN_HAMSTER_SCREEN = new class_2960("spawn", "open_hamster_screen");

    public static void serverInit() {
        SpawnVanillaIntegration.registerBiomeModifications();
        SpawnVanillaIntegration.registerStrippables();
        SpawnVanillaIntegration.registerFlammables();
        SpawnVanillaIntegration.registerCompostables();
    }

    private static void registerBiomeModifications() {
        BiomeModifications.create((class_2960)new class_2960("spawn", "replace_sunflower_patch")).add(ModificationPhase.REPLACEMENTS, biomeSelectionContext -> biomeSelectionContext.hasPlacedFeature(class_6819.field_36163), biomeModificationContext -> {
            BiomeModificationContext.GenerationSettingsContext generationSettings = biomeModificationContext.getGenerationSettings();
            if (generationSettings.removeFeature(class_6819.field_36163)) {
                generationSettings.addFeature(class_2893.class_2895.field_13178, SpawnPlacedFeatures.PATCH_SUNFLOWER);
            }
        });
        BiomeModifications.addFeature((Predicate)BiomeSelectors.tag(SpawnTags.SMALL_ANTHILL_GENERATES), (class_2893.class_2895)class_2893.class_2895.field_13178, SpawnPlacedFeatures.SMALL_ANTHILL);
    }

    private static void registerStrippables() {
        StrippableBlockRegistry.register((class_2248)SpawnBlocks.ROTTEN_LOG, (class_2248)SpawnBlocks.STRIPPED_ROTTEN_LOG);
        StrippableBlockRegistry.register((class_2248)SpawnBlocks.ROTTEN_WOOD, (class_2248)SpawnBlocks.STRIPPED_ROTTEN_WOOD);
    }

    private static void registerFlammables() {
        FlammableBlockRegistry defaultInstance = FlammableBlockRegistry.getDefaultInstance();
        defaultInstance.add(SpawnBlocks.FALLEN_LEAVES, 60, 100);
        defaultInstance.add(SpawnBlocks.SUNFLOWER, 60, 100);
        defaultInstance.add(SpawnBlocks.ROTTEN_LOG, 5, 5);
        defaultInstance.add(SpawnBlocks.ROTTEN_WOOD, 5, 5);
        defaultInstance.add(SpawnBlocks.STRIPPED_ROTTEN_LOG, 5, 5);
        defaultInstance.add(SpawnBlocks.STRIPPED_ROTTEN_WOOD, 5, 5);
        defaultInstance.add(SpawnBlocks.CRACKED_ROTTEN_PLANKS, 5, 20);
        defaultInstance.add(SpawnBlocks.ROTTEN_PLANKS, 5, 20);
        defaultInstance.add(SpawnBlocks.ROTTEN_SLAB, 5, 20);
        defaultInstance.add(SpawnBlocks.ROTTEN_STAIRS, 5, 20);
        defaultInstance.add(SpawnBlocks.ROTTEN_FENCE, 5, 20);
        defaultInstance.add(SpawnBlocks.ROTTEN_FENCE_GATE, 5, 20);
    }

    private static void registerCompostables() {
        CompostingChanceRegistry defaultInstance = CompostingChanceRegistry.INSTANCE;
        defaultInstance.add((class_1935)SpawnItems.FALLEN_LEAVES, (Object)Float.valueOf(0.25f));
        defaultInstance.add((class_1935)SpawnItems.SUNFLOWER, (Object)Float.valueOf(0.65f));
        defaultInstance.add((class_1935)SpawnItems.TUNA_SANDWICH, (Object)Float.valueOf(0.8f));
        defaultInstance.add((class_1935)SpawnItems.SNAIL_SHELL, (Object)Float.valueOf(0.8f));
        defaultInstance.add((class_1935)SpawnItems.ROTTEN_LOG, (Object)Float.valueOf(1.0f));
        defaultInstance.add((class_1935)SpawnItems.ROTTEN_WOOD, (Object)Float.valueOf(1.0f));
        defaultInstance.add((class_1935)SpawnItems.STRIPPED_ROTTEN_LOG, (Object)Float.valueOf(1.0f));
        defaultInstance.add((class_1935)SpawnItems.STRIPPED_ROTTEN_WOOD, (Object)Float.valueOf(1.0f));
        defaultInstance.add((class_1935)SpawnItems.CRACKED_ROTTEN_PLANKS, (Object)Float.valueOf(1.0f));
        defaultInstance.add((class_1935)SpawnItems.ROTTEN_PLANKS, (Object)Float.valueOf(1.0f));
    }

    @Environment(value=EnvType.CLIENT)
    public static class Client {
        public static void clientInit() {
            Client.registerModelLayers();
            Client.registerParticles();
            Client.registerBlockRenderLayers();
            Client.registerScreens();
        }

        private static void registerScreens() {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)OPEN_HAMSTER_SCREEN, (client, handler, buf, responseSender) -> {
                int id = buf.readInt();
                class_638 level = client.field_1687;
                Optional.ofNullable(level).ifPresent(world -> {
                    class_1297 entity = world.method_8469(id);
                    if (entity instanceof Hamster) {
                        Hamster hamster = (Hamster)entity;
                        int slotCount = buf.readInt();
                        int syncId = buf.readInt();
                        class_746 clientPlayerEntity = client.field_1724;
                        class_1277 simpleInventory = new class_1277(slotCount);
                        assert (clientPlayerEntity != null);
                        HamsterInventoryMenu hamsterInventoryMenu = new HamsterInventoryMenu(syncId, clientPlayerEntity.method_31548(), (class_1263)simpleInventory, hamster);
                        clientPlayerEntity.field_7512 = hamsterInventoryMenu;
                        client.execute(() -> client.method_1507((class_437)new HamsterInventoryScreen(hamsterInventoryMenu, clientPlayerEntity.method_31548(), hamster)));
                    }
                });
            });
        }

        private static void registerBlockRenderLayers() {
            BlockRenderLayerMap.INSTANCE.putBlocks(class_1921.method_23583(), new class_2248[]{SpawnBlocks.MUCUS, SpawnBlocks.MUCUS_BLOCK, SpawnBlocks.GHOSTLY_MUCUS_BLOCK, SpawnBlocks.SNAIL_EGGS});
            BlockRenderLayerMap.INSTANCE.putBlocks(class_1921.method_23581(), new class_2248[]{SpawnBlocks.FALLEN_LEAVES, SpawnBlocks.ANT_FARM, SpawnBlocks.POTTED_SWEET_BERRY_BUSH, SpawnBlocks.SUNFLOWER, SpawnBlocks.SUNFLOWER_PLANT});
        }

        private static void registerModelLayers() {
            Reflection.initialize((Class[])new Class[]{SpawnEntityModelLayers.class});
            EntityRendererRegistry.register(SpawnEntityType.ANGLER_FISH, AnglerFishRenderer::new);
            EntityRendererRegistry.register(SpawnEntityType.TUNA, TunaRenderer::new);
            EntityRendererRegistry.register(SpawnEntityType.TUNA_EGG, TunaEggRenderer::new);
            EntityRendererRegistry.register(SpawnEntityType.SEAHORSE, SeahorseRenderer::new);
            EntityRendererRegistry.register(SpawnEntityType.SNAIL, SnailRenderer::new);
            EntityRendererRegistry.register(SpawnEntityType.HAMSTER, HamsterRenderer::new);
            EntityRendererRegistry.register(SpawnEntityType.ANT, AntRenderer::new);
        }

        private static void registerParticles() {
            ParticleFactoryRegistry.getInstance().register((class_2396)SpawnParticles.ANGLER_FISH_LANTERN_GLOW, class_5786.class_5957::new);
            ParticleFactoryRegistry.getInstance().register((class_2396)SpawnParticles.TUNA_EGG, TunaEggParticle.Factory::new);
        }
    }
}

