/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.emi.recipes.basin;

import com.google.common.collect.Lists;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.compat.emi.recipes.CreateEmiRecipe;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.Lang;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.class_1935;

public class BasinEmiRecipe
extends CreateEmiRecipe<BasinRecipe> {
    private final List<EmiIngredient> catalysts = Lists.newArrayList();
    private final boolean needsHeating;

    public BasinEmiRecipe(EmiRecipeCategory category, BasinRecipe recipe, boolean needsHeating) {
        super(category, recipe, 177, 108);
        if (!needsHeating) {
            this.height = 90;
        }
        this.needsHeating = needsHeating;
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.NONE)) {
            this.catalysts.add((EmiIngredient)EmiStack.of((class_1935)((class_1935)AllBlocks.BLAZE_BURNER.get())));
        }
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.KINDLED)) {
            this.catalysts.add((EmiIngredient)EmiStack.of((class_1935)((class_1935)AllItems.BLAZE_CAKE.get())));
        }
    }

    public List<EmiIngredient> getCatalysts() {
        return this.catalysts;
    }

    public void addWidgets(WidgetHolder widgets) {
        int i;
        int inputSize = this.input.size();
        int outputSize = this.output.size();
        int vRows = (1 + outputSize) / 2;
        HeatCondition requiredHeat = ((BasinRecipe)this.recipe).getRequiredHeat();
        if (vRows <= 2) {
            BasinEmiRecipe.addTexture(widgets, AllGuiTextures.JEI_DOWN_ARROW, 136, 32 - 19 * (vRows - 1));
        }
        boolean noHeat = requiredHeat == HeatCondition.NONE;
        AllGuiTextures shadow = noHeat ? AllGuiTextures.JEI_SHADOW : AllGuiTextures.JEI_LIGHT;
        BasinEmiRecipe.addTexture(widgets, shadow, 81, 58 + (noHeat ? 10 : 30));
        if (this.needsHeating) {
            AllGuiTextures heatBar = noHeat ? AllGuiTextures.JEI_NO_HEAT_BAR : AllGuiTextures.JEI_HEAT_BAR;
            BasinEmiRecipe.addTexture(widgets, heatBar, 4, 80);
            widgets.addText(Lang.translateDirect(requiredHeat.getTranslationKey(), new Object[0]).method_30937(), 9, 86, requiredHeat.getColor(), true);
        }
        int xOff = inputSize < 3 ? (3 - inputSize) * 19 / 2 : 0;
        int yOff = 0;
        for (i = 0; i < inputSize; ++i) {
            EmiIngredient stack = (EmiIngredient)this.input.get(i);
            BasinEmiRecipe.addSlot(widgets, stack, xOff + 16 + i % 3 * 19, yOff + 50 - i / 3 * 19);
        }
        for (i = 0; i < outputSize; ++i) {
            int x = 140 - (outputSize % 2 != 0 && i == outputSize - 1 ? 0 : (i % 2 == 0 ? 10 : -9));
            int y = 50 - 20 * (i / 2) + yOff;
            EmiStack stack = (EmiStack)this.output.get(i);
            BasinEmiRecipe.addSlot(widgets, (EmiIngredient)stack, x, y).recipeContext((EmiRecipe)this);
        }
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.NONE)) {
            widgets.addSlot((EmiIngredient)EmiStack.of((class_1935)((class_1935)AllBlocks.BLAZE_BURNER.get())), 133, 81).drawBack(false).catalyst(true);
        }
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.KINDLED)) {
            widgets.addSlot((EmiIngredient)EmiStack.of((class_1935)((class_1935)AllItems.BLAZE_CAKE.get())), 152, 81).drawBack(false);
        }
    }
}

