/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.plugins.impl.mp3;

import de.maxhenkel.lame4j.ShortArrayBuffer;
import de.maxhenkel.voicechat.api.mp3.Mp3Decoder;
import de.maxhenkel.voicechat.natives.LameManager;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioFormat;

public class Mp3DecoderImpl
implements Mp3Decoder {
    private final de.maxhenkel.lame4j.Mp3Decoder decoder;
    private IOException decodeError;
    @Nullable
    private short[] samples;
    @Nullable
    private AudioFormat audioFormat;
    private int bitrate;

    private Mp3DecoderImpl(de.maxhenkel.lame4j.Mp3Decoder decoder) {
        this.decoder = decoder;
        this.bitrate = -1;
    }

    private void decodeIfNecessary() throws IOException {
        if (this.decodeError != null) {
            throw this.decodeError;
        }
        try {
            if (this.samples == null) {
                short[] samples;
                ShortArrayBuffer sampleBuffer = new ShortArrayBuffer(2048);
                while ((samples = this.decoder.decodeNextFrame()) != null) {
                    sampleBuffer.writeShorts(samples);
                }
                this.samples = sampleBuffer.toShortArray();
                this.audioFormat = this.decoder.createAudioFormat();
                this.bitrate = this.decoder.getBitRate();
            }
        }
        catch (IOException e) {
            this.decodeError = e;
            throw e;
        }
        finally {
            this.decoder.close();
        }
    }

    @Override
    public short[] decode() throws IOException {
        this.decodeIfNecessary();
        return this.samples;
    }

    @Override
    public AudioFormat getAudioFormat() throws IOException {
        this.decodeIfNecessary();
        return this.audioFormat;
    }

    @Override
    public int getBitrate() throws IOException {
        this.decodeIfNecessary();
        return this.bitrate;
    }

    @Nullable
    public static Mp3Decoder createDecoder(InputStream inputStream) {
        de.maxhenkel.lame4j.Mp3Decoder dec = LameManager.createDecoder(inputStream);
        if (dec == null) {
            return null;
        }
        return new Mp3DecoderImpl(dec);
    }
}

