/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.wiretap.config;

import de.maxhenkel.wiretap.configbuilder.ConfigBuilder;
import de.maxhenkel.wiretap.configbuilder.ConfigEntry;

public class ServerConfig {
    public final ConfigEntry<Double> microphonePickupRange;
    public final ConfigEntry<Double> speakerAudioRange;
    public final ConfigEntry<Integer> commandPermissionLevel;
    public final ConfigEntry<Integer> packetBufferSize;
    public final ConfigEntry<Boolean> anvilCrafting;
    public final ConfigEntry<String> speakerSoundEffect;
    public final ConfigEntry<String> microphoneSkinUrl;
    public final ConfigEntry<String> speakerSkinUrl;

    public ServerConfig(ConfigBuilder builder) {
        this.microphonePickupRange = builder.doubleEntry("microphone_pickup_range", 32.0, 1.0, 512.0, "The range in which microphones can pick up sounds");
        this.speakerAudioRange = builder.doubleEntry("speaker_audio_range", 32.0, 1.0, 512.0, "The audible range of speakers");
        this.commandPermissionLevel = builder.integerEntry("command_permission_level", 2, 0, Integer.MAX_VALUE, "The permission level required to use the commands");
        this.packetBufferSize = builder.integerEntry("packet_buffer_size", 6, 1, Integer.MAX_VALUE, "The amount of packets to buffer before playing");
        this.anvilCrafting = builder.booleanEntry("anvil_crafting", true, "Whether the items can be crafted in the anvil");
        this.speakerSoundEffect = builder.stringEntry("speaker_sound_effect", "old_speaker", "The sound effect to apply to the speaker", "Valid values are: 'none', 'old_speaker', 'low_quality'");
        this.microphoneSkinUrl = builder.stringEntry("microphone_skin_url", "http://textures.minecraft.net/texture/ccf0a27d246355e4dcbbd7b369d326cfed7aed1ba04e5dd9ba68cdecc4133d33", "The skin url for the microphone block");
        this.speakerSkinUrl = builder.stringEntry("speaker_skin_url", "http://textures.minecraft.net/texture/148a8c55891dec76764449f57ba677be3ee88a06921ca93b6cc7c9611a7af", "The skin url for the speaker block");
    }
}

