/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen.element;

import io.github.mortuusars.exposure.util.PagingDirection;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_4264;

public class Pager {
    public long lastChangedAt;
    public int changeCooldownMS = 50;
    public boolean playSound = true;
    public class_3414 changeSoundEvent;
    protected class_2960 texture;
    protected int pages;
    protected boolean cycled;
    protected int currentPage;
    protected class_4264 previousButton;
    protected class_4264 nextButton;

    public Pager(class_3414 changeSoundEvent) {
        this.changeSoundEvent = changeSoundEvent;
    }

    public void init(int pages, boolean cycled, class_4264 previousPageButton, class_4264 nextPageButton) {
        this.pages = pages;
        this.cycled = cycled;
        this.setPage(this.getCurrentPage());
        this.previousButton = previousPageButton;
        this.nextButton = nextPageButton;
        this.update();
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setPage(int value) {
        this.currentPage = class_3532.method_15340((int)value, (int)0, (int)this.pages);
    }

    public void update() {
        this.previousButton.field_22764 = this.canChangePage(PagingDirection.PREVIOUS);
        this.nextButton.field_22764 = this.canChangePage(PagingDirection.NEXT);
    }

    public boolean handleKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (class_310.method_1551().field_1690.field_1913.method_1417(keyCode, scanCode) || keyCode == 263) {
            if (!this.isOnCooldown()) {
                this.changePage(PagingDirection.PREVIOUS);
            }
            return true;
        }
        if (class_310.method_1551().field_1690.field_1849.method_1417(keyCode, scanCode) || keyCode == 262) {
            if (!this.isOnCooldown()) {
                this.changePage(PagingDirection.NEXT);
            }
            return true;
        }
        return false;
    }

    public boolean handleKeyReleased(int keyCode, int scanCode, int modifiers) {
        if (class_310.method_1551().field_1690.field_1849.method_1417(keyCode, scanCode) || keyCode == 262 || class_310.method_1551().field_1690.field_1913.method_1417(keyCode, scanCode) || keyCode == 263) {
            this.lastChangedAt = 0L;
            return true;
        }
        return false;
    }

    private boolean isOnCooldown() {
        return class_156.method_658() - this.lastChangedAt < (long)this.changeCooldownMS;
    }

    public boolean canChangePage(PagingDirection direction) {
        int newIndex = this.getCurrentPage() + direction.getValue();
        return this.pages > 1 && (this.cycled || 0 <= newIndex && newIndex < this.pages);
    }

    public boolean changePage(PagingDirection direction) {
        if (!this.canChangePage(direction)) {
            return false;
        }
        int oldPage = this.currentPage;
        int newPage = this.getCurrentPage() + direction.getValue();
        if (this.cycled && newPage >= this.pages) {
            newPage = 0;
        } else if (this.cycled && newPage < 0) {
            newPage = this.pages - 1;
        }
        if (oldPage == newPage) {
            return false;
        }
        this.setPage(newPage);
        this.onPageChanged(direction, oldPage, this.currentPage);
        return true;
    }

    public void onPageChanged(PagingDirection pagingDirection, int prevPage, int currentPage) {
        this.lastChangedAt = class_156.method_658();
        if (this.playSound) {
            this.playChangeSound();
        }
    }

    protected void playChangeSound() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)this.getChangeSound(), (float)0.8f, (float)1.0f));
    }

    protected class_3414 getChangeSound() {
        return this.changeSoundEvent;
    }
}

