/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.render.modifiers;

import io.github.mortuusars.exposure.render.modifiers.IPixelModifier;
import io.github.mortuusars.exposure.util.Color;
import io.github.mortuusars.exposure.util.HUSLColorConverter;
import net.minecraft.class_3532;
import net.minecraft.class_5253;
import org.apache.commons.lang3.StringUtils;

public class AgedHSBPixelModifier
implements IPixelModifier {
    public final int tintColor;
    public final double[] tintColorHsluv;
    public final float tintOpacity;
    public final int blackPoint;
    public final int whitePoint;

    public AgedHSBPixelModifier(int tintColor, float tintOpacity, int blackPoint, int whitePoint) {
        this.tintColor = tintColor;
        String hexStr = StringUtils.leftPad((String)Integer.toHexString(tintColor & 0xFFFFFF), (int)6, (String)"0");
        this.tintColorHsluv = HUSLColorConverter.hexToHsluv("#" + hexStr);
        this.tintOpacity = tintOpacity;
        this.blackPoint = blackPoint & 0xFF;
        this.whitePoint = whitePoint & 0xFF;
    }

    @Override
    public String getIdSuffix() {
        return "_sepia";
    }

    @Override
    public int modifyPixel(int ABGR) {
        int alpha = class_5253.class_8045.method_48342((int)ABGR);
        int blue = class_5253.class_8045.method_48347((int)ABGR);
        int green = class_5253.class_8045.method_48346((int)ABGR);
        int red = class_5253.class_8045.method_48345((int)ABGR);
        blue = (int)class_3532.method_37959((float)blue, (float)0.0f, (float)255.0f, (float)this.blackPoint, (float)this.whitePoint);
        green = (int)class_3532.method_37959((float)green, (float)0.0f, (float)255.0f, (float)this.blackPoint, (float)this.whitePoint);
        red = (int)class_3532.method_37959((float)red, (float)0.0f, (float)255.0f, (float)this.blackPoint, (float)this.whitePoint);
        float[] baseHSB = new float[3];
        Color.RGBtoHSB(red, green, blue, baseHSB);
        float[] tintHSB = new float[3];
        Color.RGBtoHSB(class_5253.class_5254.method_27765((int)this.tintColor), class_5253.class_5254.method_27766((int)this.tintColor), class_5253.class_5254.method_27767((int)this.tintColor), tintHSB);
        int luma = class_3532.method_15340((int)((int)(0.45 * (double)red + 0.65 * (double)green + 0.2 * (double)blue)), (int)0, (int)255);
        int tintedRGB = Color.HSBtoRGB(tintHSB[0], tintHSB[1], (float)luma / 255.0f);
        int newBlue = class_3532.method_15340((int)((int)class_3532.method_16439((float)this.tintOpacity, (float)blue, (float)class_5253.class_5254.method_27767((int)tintedRGB))), (int)0, (int)255);
        int newGreen = class_3532.method_15340((int)((int)class_3532.method_16439((float)this.tintOpacity, (float)green, (float)class_5253.class_5254.method_27766((int)tintedRGB))), (int)0, (int)255);
        int newRed = class_3532.method_15340((int)((int)class_3532.method_16439((float)this.tintOpacity, (float)red, (float)class_5253.class_5254.method_27765((int)tintedRGB))), (int)0, (int)255);
        return class_5253.class_8045.method_48344((int)alpha, (int)newBlue, (int)newGreen, (int)newRed);
    }

    public String toString() {
        return "AgedHSBPixelModifier{tintColor=#" + Integer.toHexString(this.tintColor) + ", tintOpacity=" + this.tintOpacity + ", blackPoint=" + this.blackPoint + ", whitePoint=" + this.whitePoint + "}";
    }
}

